/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ParallelHttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ParallelHttpShardHandler
extends HttpShardHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ExecutorService commExecutor;
    AtomicInteger attemptStart = new AtomicInteger(0);
    AtomicInteger attemptCount = new AtomicInteger(0);

    public ParallelHttpShardHandler(ParallelHttpShardHandlerFactory httpShardHandlerFactory) {
        super(httpShardHandlerFactory);
        this.commExecutor = httpShardHandlerFactory.commExecutor;
    }

    @Override
    protected boolean responsesPending() {
        return super.responsesPending() || this.attemptStart.get() > this.attemptCount.get();
    }

    @Override
    protected void makeShardRequest(ShardRequest sreq, String shard, ModifiableSolrParams params, LBSolrClient.Req lbReq, HttpShardHandler.SimpleSolrResponse ssr, ShardResponse srsp, long startTimeNS) {
        Runnable executeRequestRunnable = () -> {
            try {
                CompletableFuture future = this.lbClient.requestAsync(lbReq);
                future.whenComplete((BiConsumer)new HttpShardHandler.ShardRequestCallback(ssr, srsp, startTimeNS, sreq, shard, params));
                Object object = this.FUTURE_MAP_LOCK;
                synchronized (object) {
                    this.pending.incrementAndGet();
                    this.responseFutureMap.put(srsp, future);
                }
            }
            finally {
                this.attemptCount.incrementAndGet();
            }
        };
        this.attemptStart.incrementAndGet();
        CompletableFuture.runAsync(executeRequestRunnable, this.commExecutor);
    }
}

