/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.l10n.prefs;

import au.com.trgtd.tr.l10n.L10nUtils;
import au.com.trgtd.tr.l10n.Locale;
import au.com.trgtd.tr.l10n.prefs.L10nPrefs;
import au.com.trgtd.tr.l10n.prefs.L10nPrefsOptionsPanelController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

public class L10nPrefsPanel
extends JPanel {
    private final L10nPrefsOptionsPanelController controller;
    private JCheckBox enabledCheckBox;
    private JComboBox localeCombo;
    private JLabel localeLabel;

    L10nPrefsPanel(L10nPrefsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.enabledCheckBox = new JCheckBox(this.getMsg("access"));
        this.enabledCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                L10nPrefsPanel.this.localeCombo.setEnabled(L10nPrefsPanel.this.enabledCheckBox.isSelected());
            }
        });
        this.localeLabel = new JLabel(this.getMsg("locale"));
        this.localeCombo = new JComboBox<Locale>(new DefaultComboBoxModel<Locale>(Locale.values()));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]0", "0[]2[]0"));
        panel.add((Component)this.enabledCheckBox, "span, wrap");
        panel.add((Component)this.localeLabel, "align right, gapleft 30");
        panel.add((Component)this.localeCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    void load() {
        this.enabledCheckBox.setSelected(L10nPrefs.isEnabled());
        this.localeCombo.setSelectedItem((Object)L10nPrefs.getLocale());
        this.localeCombo.setEnabled(this.enabledCheckBox.isSelected());
    }

    void store() {
        boolean enabled = this.enabledCheckBox.isSelected();
        Locale locale = (Locale)((Object)this.localeCombo.getSelectedItem());
        if (locale == null) {
            locale = Locale.none;
        }
        L10nPrefs.setEnabled(enabled);
        L10nPrefs.setLanguage(locale);
        if (!enabled || locale == Locale.none) {
            L10nUtils.getDefault().setLocale(Locale.none);
        } else {
            L10nUtils.getDefault().setLocale(locale);
        }
    }

    boolean valid() {
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

