/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.io.Serializable;

public class LeakyExportCheckData
implements Serializable {
    private byte[] clearKey;
    private byte[] secretKeyPlain;
    private byte[] secretKeyEnc;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private byte[] iv;
    private SSL2CipherSuite cipherSuite;
    private byte[] encrypted;
    private int paddingLength;

    LeakyExportCheckData(TlsContext context, SSL2ClientMasterKeyMessage clientMessage, SSL2ServerVerifyMessage serverMessage) {
        this.clearKey = context.getClearKey();
        this.secretKeyPlain = context.getPreMasterSecret();
        this.secretKeyEnc = (byte[])clientMessage.getEncryptedKeyData().getValue();
        this.clientRandom = context.getClientRandom();
        this.serverRandom = context.getServerRandom();
        this.iv = context.getSSL2Iv();
        this.cipherSuite = context.getChooser().getSSL2CipherSuite();
        this.encrypted = (byte[])serverMessage.getEncryptedPart().getValue();
        this.paddingLength = (Integer)serverMessage.getPaddingLength().getValue();
    }

    public byte[] getClearKey() {
        return this.clearKey;
    }

    public byte[] getSecretKeyPlain() {
        return this.secretKeyPlain;
    }

    public byte[] getSecretKeyEnc() {
        return this.secretKeyEnc;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public SSL2CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public byte[] getEncrypted() {
        return this.encrypted;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }
}

