/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.util.UnlimitedStrengthEnabler;
import java.security.Provider;
import java.security.Security;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GeneralDelegate
extends Delegate {
    private static final Logger LOGGER = LogManager.getLogger();
    @Parameter(names={"-h", "-help"}, help=true, description="Prints usage for all the existing commands.")
    private boolean help;
    @Parameter(names={"-debug"}, description="Show extra debug output (sets logLevel to DEBUG)")
    private boolean debug;
    @Parameter(names={"-quiet"}, description="No output (sets logLevel to NONE)")
    private boolean quiet;
    @Parameter(names={"-keylogfile"}, description="Path to the keylogfile")
    protected String keylogfile = null;

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String getKeylogfile() {
        return this.keylogfile;
    }

    public void setKeylogfile(String keylogfile) {
        this.keylogfile = keylogfile;
    }

    @Override
    public void applyDelegate(Config config) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (this.isDebug()) {
            Configurator.setAllLevels((String)"de.rub.nds.tlsattacker", (Level)Level.DEBUG);
        } else if (this.quiet) {
            Configurator.setAllLevels((String)"de.rub.nds.tlsattacker", (Level)Level.OFF);
        }
        LOGGER.debug("Using the following security providers");
        for (Provider p : Security.getProviders()) {
            LOGGER.debug("Provider {}, version, {}", (Object)p.getName(), (Object)p.getVersion());
        }
        if (this.keylogfile != null) {
            config.setKeylogFilePath(this.keylogfile);
            config.setWriteKeylogFile(true);
        }
        UnlimitedStrengthEnabler.enable();
    }
}

