/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected long timeout;
    protected OutputStream outStream;
    protected PushbackInputStream inStream;
    private boolean initialized = false;
    private final ConnectionEndType type;
    private boolean isInStreamTerminating = true;

    public TransportHandler(long timeout, ConnectionEndType type, boolean isInStreamTerminating) {
        this.timeout = timeout;
        this.type = type;
        this.isInStreamTerminating = isInStreamTerminating;
    }

    public TransportHandler(long timeout, ConnectionEndType type) {
        this.timeout = timeout;
        this.type = type;
    }

    public abstract void closeConnection() throws IOException;

    public abstract void closeClientConnection() throws IOException;

    public byte[] fetchData(int amountOfData) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (int i = 0; i < amountOfData; ++i) {
            stream.write(this.inStream.read());
        }
        return stream.toByteArray();
    }

    public byte[] fetchData() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        long minTimeMillies = System.currentTimeMillis() + this.timeout;
        while (System.currentTimeMillis() < minTimeMillies && stream.toByteArray().length == 0) {
            if (this.inStream.available() != 0) {
                while (this.inStream.available() != 0) {
                    int read = this.inStream.read();
                    stream.write(read);
                }
                continue;
            }
            if (!this.isInStreamTerminating) continue;
            try {
                Thread.sleep(1L);
                int read = this.inStream.read();
                if (read == -1) {
                    return stream.toByteArray();
                }
                this.inStream.unread(read);
            }
            catch (SocketException E) {
                return stream.toByteArray();
            }
            catch (Exception exception) {
            }
        }
        return stream.toByteArray();
    }

    public void sendData(byte[] data) throws IOException {
        if (!this.initialized) {
            throw new IOException("Transporthandler is not initalized!");
        }
        this.outStream.write(data);
        this.outStream.flush();
    }

    protected final void setStreams(PushbackInputStream inStream, OutputStream outStream) {
        this.outStream = outStream;
        this.inStream = inStream;
        this.initialized = true;
    }

    public abstract void initialize() throws IOException;

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract boolean isClosed() throws IOException;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setIsInStreamTerminating(boolean isInStreamTerminating) {
        this.isInStreamTerminating = isInStreamTerminating;
    }

    public boolean isIsInStreamTerminating() {
        return this.isInStreamTerminating;
    }
}

