package Net::Flow::Constants;

use warnings;
use strict;

#use Readonly;

require Exporter;
use base qw(Exporter);

our @EXPORT_OK = ( qw( %informationElementsByName %informationElementsById ), );

our %informationElementsByName = (
	'absoluteError' => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 320,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'absoluteError',
		'range'             => undef,
		'units'             => 'none'
	},
	'anonymizationFlags' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 285,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'anonymizationFlags',
		'range'             => undef,
		'units'             => 'none'
	},
	'anonymizationTechnique' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 286,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'anonymizationTechnique',
		'range'             => undef,
		'units'             => 'none'
	},
	'applicationCategoryName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 372,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationCategoryName',
		'range'             => undef,
		'units'             => 'none'
	},
	'applicationDescription' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 94,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationDescription',
		'range'             => undef,
		'units'             => 'none'
	},
	'applicationGroupName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 374,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationGroupName',
		'range'             => undef,
		'units'             => 'none'
	},
	'applicationId' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 95,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationId',
		'range'             => undef,
		'units'             => 'none'
	},
	'applicationName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 96,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationName',
		'range'             => undef,
		'units'             => 'none'
	},
	'applicationSubCategoryName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 373,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationSubCategoryName',
		'range'             => undef,
		'units'             => 'none'
	},
	'basicList' => {
		'applicability'     => undef,
		'dataType'          => 'basicList',
		'dataTypeSemantics' => 'list',
		'elementId'         => 291,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'basicList',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpDestinationAsNumber' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 17,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpDestinationAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpNextAdjacentAsNumber' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 128,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpNextAdjacentAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpNextHopIPv4Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 18,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpNextHopIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpNextHopIPv6Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 63,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpNextHopIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpPrevAdjacentAsNumber' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 129,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpPrevAdjacentAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpSourceAsNumber' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 16,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpSourceAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'bgpValidityState' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 294,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'bgpValidityState',
		'range'             => undef,
		'units'             => 'none'
	},
	'biflowDirection' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 239,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'biflowDirection',
		'range'             => undef,
		'units'             => 'none'
	},
	'classificationEngineId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 101,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'classificationEngineId',
		'range'             => undef,
		'units'             => 'none'
	},
	'collectionTimeMilliseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 258,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'collectionTimeMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'collectorCertificate' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 274,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'collectorCertificate',
		'range'             => undef,
		'units'             => 'none'
	},
	'collectorIPv4Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 211,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'collectorIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'collectorIPv6Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 212,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'collectorIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'collectorTransportPort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 216,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'collectorTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'commonPropertiesId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 137,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'commonPropertiesId',
		'range'             => undef,
		'units'             => 'none'
	},
	'confidenceLevel' => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 338,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'confidenceLevel',
		'range'             => undef,
		'units'             => 'none'
	},
	'connectionCountNew' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 278,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'connectionCountNew',
		'range'             => undef,
		'units'             => 'none'
	},
	'connectionSumDuration' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 279,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'connectionSumDuration',
		'range'             => undef,
		'units'             => 'none'
	},
	'connectionTransactionId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 280,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'connectionTransactionId',
		'range'             => undef,
		'units'             => 'none'
	},
	'dataLinkFrameSection' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 315,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dataLinkFrameSection',
		'range'             => undef,
		'units'             => 'none'
	},
	'dataLinkFrameSize' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 312,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dataLinkFrameSize',
		'range'             => undef,
		'units'             => 'none'
	},
	'dataRecordsReliability' => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 276,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dataRecordsReliability',
		'range'             => undef,
		'units'             => 'none'
	},
	'deltaFlowCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 3,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'deltaFlowCount',
		'range'             => undef,
		'units'             => 'none'
	},
	'destinationIPv4Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 12,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'destinationIPv4Prefix' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 45,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv4Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	'destinationIPv4PrefixLength' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 13,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv4PrefixLength',
		'range'             => '0-32',
		'units'             => 'bits'
	},
	'destinationIPv6Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 28,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'destinationIPv6Prefix' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 169,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv6Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	'destinationIPv6PrefixLength' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 30,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv6PrefixLength',
		'range'             => '0-128',
		'units'             => 'bits'
	},
	'destinationMacAddress' => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 80,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'destinationMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'destinationTransportPort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 11,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'destinationTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'digestHashValue' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 326,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'digestHashValue',
		'range'             => undef,
		'units'             => 'none'
	},
	'distinctCountOfDestinationIPAddress' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 379,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfDestinationIPAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'distinctCountOfDestinationIPv4Address' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 381,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfDestinationIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'distinctCountOfDestinationIPv6Address' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 383,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfDestinationIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'distinctCountOfSourceIPAddress' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 378,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfSourceIPAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'distinctCountOfSourceIPv4Address' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 380,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfSourceIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'distinctCountOfSourceIPv6Address' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 382,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfSourceIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'dot1qCustomerDEI' => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 389,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qCustomerDEI',
		'range'             => undef,
		'units'             => 'none'
	},
	'dot1qCustomerPriority' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 246,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qCustomerPriority',
		'range'             => undef,
		'units'             => 'none'
	},
	'dot1qCustomerVlanId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 245,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qCustomerVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	'dot1qDEI' => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 388,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qDEI',
		'range'             => undef,
		'units'             => 'none'
	},
	'dot1qPriority' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 244,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qPriority',
		'range'             => undef,
		'units'             => 'none'
	},
	'dot1qVlanId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 243,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qVlanId',
		'range'             => undef,
		'units'             => 'octets'
	},
	'droppedOctetDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 132,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedOctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'droppedOctetTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 134,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'droppedPacketDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 133,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedPacketDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'droppedPacketTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 135,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'egressBroadcastPacketTotalCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 358,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressBroadcastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'egressInterface' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 14,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'egressInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	'egressInterfaceType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 369,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressInterfaceType',
		'range'             => undef,
		'units'             => 'none'
	},
	'egressPhysicalInterface' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 253,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressPhysicalInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	'egressUnicastPacketTotalCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 357,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressUnicastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'egressVRFID' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 235,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressVRFID',
		'range'             => undef,
		'units'             => 'none'
	},
	'encryptedTechnology' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 290,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'encryptedTechnology',
		'range'             => undef,
		'units'             => 'none'
	},
	'ethernetHeaderLength' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 240,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetHeaderLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ethernetPayloadLength' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 241,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetPayloadLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ethernetTotalLength' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 242,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ethernetType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 256,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetType',
		'range'             => undef,
		'units'             => 'none'
	},
	'exportedFlowRecordTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 42,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'exportedFlowRecordTotalCount',
		'range'             => undef,
		'units'             => 'flows'
	},
	'exportedMessageTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 41,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'exportedMessageTotalCount',
		'range'             => undef,
		'units'             => 'messages'
	},
	'exportedOctetTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 40,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'exportedOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'exporterCertificate' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 275,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'exporterCertificate',
		'range'             => undef,
		'units'             => 'none'
	},
	'exporterIPv4Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 130,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exporterIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'exporterIPv6Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 131,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exporterIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'exporterTransportPort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 217,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exporterTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'exportingProcessId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 144,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'exportingProcessId',
		'range'             => undef,
		'units'             => 'none'
	},
	'exportInterface' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 213,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exportInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	'exportProtocolVersion' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 214,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exportProtocolVersion',
		'range'             => undef,
		'units'             => 'none'
	},
	'exportSctpStreamId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 259,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'exportSctpStreamId',
		'range'             => undef,
		'units'             => 'none'
	},
	'exportTransportProtocol' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 215,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exportTransportProtocol',
		'range'             => undef,
		'units'             => 'none'
	},
	'firewallEvent' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 233,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'firewallEvent',
		'range'             => undef,
		'units'             => 'none'
	},
	'flowActiveTimeout' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 36,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowActiveTimeout',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'flowDirection' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 61,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowDirection',
		'range'             => undef,
		'units'             => 'none'
	},
	'flowDurationMicroseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 162,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowDurationMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'flowDurationMilliseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 161,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowDurationMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'flowEndDeltaMicroseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 159,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndDeltaMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'flowEndMicroseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 155,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'flowEndMilliseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 153,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'flowEndNanoseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 157,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	'flowEndReason' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 136,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowEndReason',
		'range'             => undef,
		'units'             => 'none'
	},
	'flowEndSeconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 151,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'flowEndSysUpTime' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 21,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndSysUpTime',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'flowId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 148,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'flowId',
		'range'             => undef,
		'units'             => 'none'
	},
	'flowIdleTimeout' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 37,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowIdleTimeout',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'flowKeyIndicator' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 173,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'flowKeyIndicator',
		'range'             => undef,
		'units'             => 'none'
	},
	'flowLabelIPv6' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 31,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'flowLabelIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	'flowStartDeltaMicroseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 158,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartDeltaMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'flowStartMicroseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 154,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'flowStartMilliseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 152,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'flowStartNanoseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 156,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	'flowStartSeconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 150,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'flowStartSysUpTime' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 22,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartSysUpTime',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'fragmentFlags' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 197,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'fragmentFlags',
		'range'             => undef,
		'units'             => 'none'
	},
	'fragmentIdentification' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 54,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'fragmentIdentification',
		'range'             => undef,
		'units'             => 'none'
	},
	'fragmentOffset' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 88,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'fragmentOffset',
		'range'             => undef,
		'units'             => 'none'
	},
	'greKey' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 296,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'greKey',
		'range'             => '0x0-0xFFFFFFFF',
		'units'             => 'none'
	},
	'hashDigestOutput' => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 333,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashDigestOutput',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashInitialiserValue' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 334,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashInitialiserValue',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashIPPayloadOffset' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 327,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashIPPayloadOffset',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashIPPayloadSize' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 328,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashIPPayloadSize',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashOutputRangeMax' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 330,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashOutputRangeMax',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashOutputRangeMin' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 329,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashOutputRangeMin',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashSelectedRangeMax' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 332,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashSelectedRangeMax',
		'range'             => undef,
		'units'             => 'none'
	},
	'hashSelectedRangeMin' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 331,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashSelectedRangeMin',
		'range'             => undef,
		'units'             => 'none'
	},
	'icmpCodeIPv4' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 177,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpCodeIPv4',
		'range'             => undef,
		'units'             => 'none'
	},
	'icmpCodeIPv6' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 179,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpCodeIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	'icmpTypeCodeIPv4' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 32,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeCodeIPv4',
		'range'             => undef,
		'units'             => 'none'
	},
	'icmpTypeCodeIPv6' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 139,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeCodeIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	'icmpTypeIPv4' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 176,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeIPv4',
		'range'             => undef,
		'units'             => 'none'
	},
	'icmpTypeIPv6' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 178,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	'igmpType' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 33,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'igmpType',
		'range'             => undef,
		'units'             => 'none'
	},
	'ignoredOctetTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 165,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'ignoredOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ignoredPacketTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 164,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'ignoredPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'informationElementDataType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 339,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementDataType',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementDescription' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 340,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementDescription',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 303,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementId',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementIndex' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 287,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementIndex',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 341,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementName',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementRangeBegin' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 342,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementRangeBegin',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementRangeEnd' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 343,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementRangeEnd',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementSemantics' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 344,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementSemantics',
		'range'             => undef,
		'units'             => 'none'
	},
	'informationElementUnits' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 345,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementUnits',
		'range'             => undef,
		'units'             => 'none'
	},
	'ingressBroadcastPacketTotalCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 356,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressBroadcastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'ingressInterface' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 10,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'ingressInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	'ingressInterfaceType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 368,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressInterfaceType',
		'range'             => undef,
		'units'             => 'none'
	},
	'ingressMulticastPacketTotalCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 355,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressMulticastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'ingressPhysicalInterface' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 252,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressPhysicalInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	'ingressUnicastPacketTotalCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 354,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressUnicastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'ingressVRFID' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 234,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressVRFID',
		'range'             => undef,
		'units'             => 'none'
	},
	'initiatorOctets' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 231,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'initiatorOctets',
		'range'             => undef,
		'units'             => 'octets'
	},
	'initiatorPackets' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 298,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'initiatorPackets',
		'range'             => undef,
		'units'             => 'packets'
	},
	'interfaceDescription' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 83,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'interfaceDescription',
		'range'             => undef,
		'units'             => 'none'
	},
	'interfaceName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 82,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'interfaceName',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipClassOfService' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 5,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipClassOfService',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipDiffServCodePoint' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 195,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipDiffServCodePoint',
		'range'             => '0-63',
		'units'             => 'none'
	},
	'ipHeaderLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 189,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipHeaderLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ipHeaderPacketSection' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 313,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ipHeaderPacketSection',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipNextHopIPv4Address' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 15,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'ipNextHopIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipNextHopIPv6Address' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 62,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'ipNextHopIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipPayloadLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 204,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'ipPayloadLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ipPayloadPacketSection' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 314,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ipPayloadPacketSection',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipPrecedence' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 196,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipPrecedence',
		'range'             => '0-7',
		'units'             => 'none'
	},
	'IPSecSPI' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 295,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'IPSecSPI',
		'range'             => '0x0-0xFFFFFFFF',
		'units'             => 'none'
	},
	'ipTotalLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 224,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'ipTTL' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 192,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	'ipv4IHL' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 207,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipv4IHL',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipv4Options' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 208,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'ipv4Options',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipv6ExtensionHeaders' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 64,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'ipv6ExtensionHeaders',
		'range'             => undef,
		'units'             => 'none'
	},
	'ipVersion' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 60,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipVersion',
		'range'             => undef,
		'units'             => 'none'
	},
	'isMulticast' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 206,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'isMulticast',
		'range'             => undef,
		'units'             => 'none'
	},
	'layer2OctetDeltaCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 352,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'layer2OctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'layer2OctetTotalCount' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 353,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'layer2OctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'layer2SegmentId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 351,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'layer2SegmentId',
		'range'             => undef,
		'units'             => 'none'
	},
	'lineCardId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 141,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'lineCardId',
		'range'             => undef,
		'units'             => 'none'
	},
	'lowerCILimit' => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 337,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'lowerCILimit',
		'range'             => undef,
		'units'             => 'none'
	},
	'maxExportSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 260,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxExportSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'maxFlowEndMicroseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 268,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'maxFlowEndMilliseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 269,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'maxFlowEndNanoseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 270,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	'maxFlowEndSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 261,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'maximumIpTotalLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 26,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'maximumIpTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'maximumTTL' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 53,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'maximumTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	'messageMD5Checksum' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 262,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'messageMD5Checksum',
		'range'             => undef,
		'units'             => 'none'
	},
	'messageScope' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 263,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'messageScope',
		'range'             => undef,
		'units'             => 'none'
	},
	'meteringProcessId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 143,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'meteringProcessId',
		'range'             => undef,
		'units'             => 'none'
	},
	'metroEvcId' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 247,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'metroEvcId',
		'range'             => undef,
		'units'             => 'none'
	},
	'metroEvcType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 248,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'metroEvcType',
		'range'             => undef,
		'units'             => 'none'
	},
	'minExportSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 264,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minExportSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'minFlowStartMicroseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 271,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'minFlowStartMilliseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 272,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'minFlowStartNanoseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 273,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	'minFlowStartSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 265,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'minimumIpTotalLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 25,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'minimumIpTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'minimumTTL' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 52,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'minimumTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	'monitoringIntervalEndMilliSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 360,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'monitoringIntervalEndMilliSeconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'monitoringIntervalStartMilliSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 359,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'monitoringIntervalStartMilliSeconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'mplsLabelStackDepth' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 202,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackDepth',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 201,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'mplsLabelStackSection' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 316,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'mplsLabelStackSection',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection10' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 79,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection10',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection2' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 71,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection2',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection3' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 72,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection3',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection4' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 73,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection4',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection5' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 74,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection5',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection6' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 75,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection6',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection7' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 76,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection7',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection8' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 77,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection8',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsLabelStackSection9' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 78,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection9',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsPayloadLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 194,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsPayloadLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'mplsPayloadPacketSection' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 317,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'mplsPayloadPacketSection',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsTopLabelExp' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 203,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsTopLabelExp',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsTopLabelIPv4Address' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 47,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsTopLabelIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsTopLabelIPv6Address' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 140,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsTopLabelIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsTopLabelPrefixLength' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 91,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'mplsTopLabelPrefixLength',
		'range'             => '0-32',
		'units'             => 'bits'
	},
	'mplsTopLabelStackSection' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 70,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsTopLabelStackSection',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsTopLabelTTL' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 200,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsTopLabelTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	'mplsTopLabelType' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 46,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsTopLabelType',
		'range'             => undef,
		'units'             => 'none'
	},
	'mplsVpnRouteDistinguisher' => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 90,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsVpnRouteDistinguisher',
		'range'             => undef,
		'units'             => 'none'
	},
	'multicastReplicationFactor' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 99,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'multicastReplicationFactor',
		'range'             => undef,
		'units'             => 'none'
	},
	'natEvent' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 230,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natEvent',
		'range'             => undef,
		'units'             => 'none'
	},
	'natOriginatingAddressRealm' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 229,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natOriginatingAddressRealm',
		'range'             => undef,
		'units'             => 'none'
	},
	'natPoolId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 283,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natPoolId',
		'range'             => undef,
		'units'             => 'none'
	},
	'natPoolName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 284,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natPoolName',
		'range'             => undef,
		'units'             => 'none'
	},
	'natType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 297,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natType',
		'range'             => '',
		'units'             => 'none'
	},
	'nextHeaderIPv6' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 193,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'nextHeaderIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	'notSentFlowTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 166,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'notSentFlowTotalCount',
		'range'             => undef,
		'units'             => 'flows'
	},
	'notSentOctetTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 168,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'notSentOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'notSentPacketTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 167,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'notSentPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'observationDomainId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 149,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'observationDomainId',
		'range'             => undef,
		'units'             => 'none'
	},
	'observationDomainName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 300,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationDomainName',
		'range'             => undef,
		'units'             => 'none'
	},
	'observationPointId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 138,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'observationPointId',
		'range'             => undef,
		'units'             => 'none'
	},
	'observationPointType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 277,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationPointType',
		'range'             => undef,
		'units'             => 'none'
	},
	'observationTimeMicroseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 324,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'observationTimeMilliseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 323,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'observationTimeNanoseconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 325,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	'observationTimeSeconds' => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 322,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	'observedFlowTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 163,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'observedFlowTotalCount',
		'range'             => undef,
		'units'             => 'flows'
	},
	'octetDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 1,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'octetDeltaSumOfSquares' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 198,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetDeltaSumOfSquares',
		'range'             => undef,
		'units'             => 'none'
	},
	'octetTotalCount' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 85,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'octetTotalSumOfSquares' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 199,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetTotalSumOfSquares',
		'range'             => undef,
		'units'             => 'octets'
	},
	'opaqueOctets' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 266,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'opaqueOctets',
		'range'             => undef,
		'units'             => 'none'
	},
	'originalFlowsCompleted' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 377,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'originalFlowsCompleted',
		'range'             => undef,
		'units'             => 'none'
	},
	'originalFlowsInitiated' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 376,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'originalFlowsInitiated',
		'range'             => undef,
		'units'             => 'none'
	},
	'originalFlowsPresent' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 375,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'originalFlowsPresent',
		'range'             => undef,
		'units'             => 'none'
	},
	'p2pTechnology' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 288,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'p2pTechnology',
		'range'             => undef,
		'units'             => 'none'
	},
	'packetDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 2,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'packetDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'packetTotalCount' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 86,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'packetTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'paddingOctets' => {
		'applicability'     => 'option',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 210,
		'enterpriseId'      => undef,
		'group'             => 'padding',
		'name'              => 'paddingOctets',
		'range'             => undef,
		'units'             => 'none'
	},
	'payloadLengthIPv6' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 191,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'payloadLengthIPv6',
		'range'             => undef,
		'units'             => 'octets'
	},
	'portId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 142,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'portId',
		'range'             => undef,
		'units'             => 'none'
	},
	'portRangeEnd' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 362,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeEnd',
		'range'             => undef,
		'units'             => 'none'
	},
	'portRangeNumPorts' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 364,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeNumPorts',
		'range'             => undef,
		'units'             => 'none'
	},
	'portRangeStart' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 361,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeStart',
		'range'             => undef,
		'units'             => 'none'
	},
	'portRangeStepSize' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 363,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeStepSize',
		'range'             => undef,
		'units'             => 'none'
	},
	'postDestinationMacAddress' => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 57,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postDestinationMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'postDot1qCustomerVlanId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 255,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postDot1qCustomerVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	'postDot1qVlanId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 254,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postDot1qVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	'postIpClassOfService' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 55,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'postIpClassOfService',
		'range'             => undef,
		'units'             => 'none'
	},
	'postIpDiffServCodePoint' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 98,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postIpDiffServCodePoint',
		'range'             => '0-63',
		'units'             => 'none'
	},
	'postIpPrecedence' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 257,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postIpPrecedence',
		'range'             => '0-7',
		'units'             => 'none'
	},
	'postMCastOctetDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 20,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastOctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'postMCastOctetTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 175,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'postMCastPacketDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 19,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastPacketDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'postMCastPacketTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 174,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'postMplsTopLabelExp' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 237,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postMplsTopLabelExp',
		'range'             => undef,
		'units'             => 'none'
	},
	'postNAPTDestinationTransportPort' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 228,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNAPTDestinationTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'postNAPTSourceTransportPort' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 227,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNAPTSourceTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'postNATDestinationIPv4Address' => {
		'applicability'     => undef,
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 226,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATDestinationIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'postNATDestinationIPv6Address' => {
		'applicability'     => undef,
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 282,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATDestinationIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'postNATSourceIPv4Address' => {
		'applicability'     => undef,
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 225,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATSourceIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'postNATSourceIPv6Address' => {
		'applicability'     => undef,
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 281,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATSourceIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'postOctetDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 23,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postOctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'postOctetTotalCount' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 171,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	'postPacketDeltaCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 24,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postPacketDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'postPacketTotalCount' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 172,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'postSourceMacAddress' => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 81,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postSourceMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'postVlanId' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 59,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	'privateEnterpriseNumber' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 346,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'privateEnterpriseNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'protocolIdentifier' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 4,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'protocolIdentifier',
		'range'             => undef,
		'units'             => 'none'
	},
	'pseudoWireControlWord' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 251,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'pseudoWireControlWord',
		'range'             => undef,
		'units'             => 'none'
	},
	'pseudoWireId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 249,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'pseudoWireId',
		'range'             => undef,
		'units'             => 'none'
	},
	'pseudoWireType' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 250,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'pseudoWireType',
		'range'             => undef,
		'units'             => 'none'
	},
	'relativeError' => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 321,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'relativeError',
		'range'             => undef,
		'units'             => 'none'
	},
	'responderOctets' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 232,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'responderOctets',
		'range'             => undef,
		'units'             => 'octets'
	},
	'responderPackets' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 299,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'responderPackets',
		'range'             => undef,
		'units'             => 'packets'
	},
	'rfc3550JitterMicroseconds' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 386,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rfc3550JitterMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'rfc3550JitterMilliseconds' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 385,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rfc3550JitterMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'rfc3550JitterNanoseconds' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 387,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rfc3550JitterNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	'rtpSequenceNumber' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 370,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rtpSequenceNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'samplingPacketInterval' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 305,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingPacketInterval',
		'range'             => undef,
		'units'             => 'packets'
	},
	'samplingPacketSpace' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 306,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingPacketSpace',
		'range'             => undef,
		'units'             => 'packets'
	},
	'samplingPopulation' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 310,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingPopulation',
		'range'             => undef,
		'units'             => 'packets'
	},
	'samplingProbability' => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 311,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingProbability',
		'range'             => undef,
		'units'             => 'none'
	},
	'samplingSize' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 309,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingSize',
		'range'             => undef,
		'units'             => 'packets'
	},
	'samplingTimeInterval' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 307,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingTimeInterval',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'samplingTimeSpace' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 308,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingTimeSpace',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	'selectionSequenceId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 301,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectionSequenceId',
		'range'             => undef,
		'units'             => 'none'
	},
	'selectorAlgorithm' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 304,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorAlgorithm',
		'range'             => undef,
		'units'             => 'none'
	},
	'selectorId' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 302,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorId',
		'range'             => undef,
		'units'             => 'none'
	},
	'selectorIdTotalPktsObserved' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 318,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorIdTotalPktsObserved',
		'range'             => undef,
		'units'             => 'packets'
	},
	'selectorIdTotalPktsSelected' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 319,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorIdTotalPktsSelected',
		'range'             => undef,
		'units'             => 'packets'
	},
	'selectorName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 335,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorName',
		'range'             => undef,
		'units'             => 'none'
	},
	'sessionScope' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 267,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'sessionScope',
		'range'             => undef,
		'units'             => 'none'
	},
	'sourceIPv4Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 8,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'sourceIPv4Prefix' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 44,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv4Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	'sourceIPv4PrefixLength' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 9,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv4PrefixLength',
		'range'             => '0-32',
		'units'             => 'bits'
	},
	'sourceIPv6Address' => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 27,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'sourceIPv6Prefix' => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 170,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv6Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	'sourceIPv6PrefixLength' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 29,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv6PrefixLength',
		'range'             => '0-128',
		'units'             => 'bits'
	},
	'sourceMacAddress' => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 56,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'sourceMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'sourceTransportPort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 7,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'sourceTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'staIPv4Address' => {
		'applicability'     => undef,
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 366,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'staIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	'staMacAddress' => {
		'applicability'     => undef,
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 365,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'staMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	'subTemplateList' => {
		'applicability'     => undef,
		'dataType'          => 'subTemplateList',
		'dataTypeSemantics' => 'list',
		'elementId'         => 292,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'subTemplateList',
		'range'             => undef,
		'units'             => 'none'
	},
	'subTemplateMultiList' => {
		'applicability'     => undef,
		'dataType'          => 'subTemplateMultiList',
		'dataTypeSemantics' => 'list',
		'elementId'         => 293,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'subTemplateMultiList',
		'range'             => undef,
		'units'             => 'none'
	},
	'systemInitTimeMilliseconds' => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 160,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'systemInitTimeMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	'tcpAcknowledgementNumber' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 185,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpAcknowledgementNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpAckTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 222,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpAckTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'tcpControlBits' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 6,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'tcpControlBits',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpDestinationPort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 183,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpDestinationPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpFinTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 219,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpFinTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'tcpHeaderLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 188,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpHeaderLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'tcpOptions' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 209,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'tcpOptions',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpPshTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 221,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpPshTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'tcpRstTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 220,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpRstTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'tcpSequenceNumber' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 184,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpSequenceNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpSourcePort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 182,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpSourcePort',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpSynTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 218,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpSynTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'tcpUrgentPointer' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 187,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpUrgentPointer',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpUrgTotalCount' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 223,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpUrgTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	'tcpWindowScale' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 238,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpWindowScale',
		'range'             => undef,
		'units'             => 'none'
	},
	'tcpWindowSize' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 186,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpWindowSize',
		'range'             => undef,
		'units'             => 'none'
	},
	'templateId' => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 145,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'templateId',
		'range'             => undef,
		'units'             => 'none'
	},
	'totalLengthIPv4' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 190,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'totalLengthIPv4',
		'range'             => undef,
		'units'             => 'octets'
	},
	'tunnelTechnology' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 289,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'tunnelTechnology',
		'range'             => undef,
		'units'             => 'none'
	},
	'udpDestinationPort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 181,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'udpDestinationPort',
		'range'             => undef,
		'units'             => 'none'
	},
	'udpMessageLength' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 205,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'udpMessageLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	'udpSourcePort' => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 180,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'udpSourcePort',
		'range'             => undef,
		'units'             => 'none'
	},
	'upperCILimit' => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 336,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'upperCILimit',
		'range'             => undef,
		'units'             => 'none'
	},
	'userName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 371,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'userName',
		'range'             => undef,
		'units'             => 'none'
	},
	'valueDistributionMethod' => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 384,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'valueDistributionMethod',
		'range'             => undef,
		'units'             => 'none'
	},
	'virtualStationInterfaceId' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 347,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationInterfaceId',
		'range'             => undef,
		'units'             => 'none'
	},
	'virtualStationInterfaceName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 348,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationInterfaceName',
		'range'             => undef,
		'units'             => 'none'
	},
	'virtualStationName' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 350,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationName',
		'range'             => undef,
		'units'             => 'none'
	},
	'virtualStationUUID' => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 349,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationUUID',
		'range'             => undef,
		'units'             => 'none'
	},
	'vlanId' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 58,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'vlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	'VRFname' => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 236,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'VRFname',
		'range'             => undef,
		'units'             => 'none'
	},
	'wlanChannelId' => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 146,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'wlanChannelId',
		'range'             => undef,
		'units'             => 'none'
	},
	'wlanSSID' => {
		'applicability'     => 'data',
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 147,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'wlanSSID',
		'range'             => undef,
		'units'             => 'none'
	},
	'wtpMacAddress' => {
		'applicability'     => undef,
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 367,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'wtpMacAddress',
		'range'             => undef,
		'units'             => 'none'
	}
);

our %informationElementsById = (
	1 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 1,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	2 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 2,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'packetDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	3 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 3,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'deltaFlowCount',
		'range'             => undef,
		'units'             => 'none'
	},
	4 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 4,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'protocolIdentifier',
		'range'             => undef,
		'units'             => 'none'
	},
	5 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 5,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipClassOfService',
		'range'             => undef,
		'units'             => 'none'
	},
	6 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 6,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'tcpControlBits',
		'range'             => undef,
		'units'             => 'none'
	},
	7 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 7,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'sourceTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	8 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 8,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	9 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 9,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv4PrefixLength',
		'range'             => '0-32',
		'units'             => 'bits'
	},
	10 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 10,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'ingressInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	11 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 11,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'destinationTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	12 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 12,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	13 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 13,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv4PrefixLength',
		'range'             => '0-32',
		'units'             => 'bits'
	},
	14 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 14,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'egressInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	15 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 15,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'ipNextHopIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	16 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 16,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpSourceAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	17 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 17,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpDestinationAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	18 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 18,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpNextHopIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	19 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 19,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastPacketDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	20 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 20,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastOctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	21 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 21,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndSysUpTime',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	22 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 22,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartSysUpTime',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	23 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 23,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postOctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	24 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 24,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postPacketDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	25 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 25,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'minimumIpTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	26 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 26,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'maximumIpTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	27 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 27,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	28 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 28,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	29 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 29,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv6PrefixLength',
		'range'             => '0-128',
		'units'             => 'bits'
	},
	30 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 30,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv6PrefixLength',
		'range'             => '0-128',
		'units'             => 'bits'
	},
	31 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 31,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'flowLabelIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	32 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 32,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeCodeIPv4',
		'range'             => undef,
		'units'             => 'none'
	},
	33 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 33,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'igmpType',
		'range'             => undef,
		'units'             => 'none'
	},
	36 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 36,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowActiveTimeout',
		'range'             => undef,
		'units'             => 'seconds'
	},
	37 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 37,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowIdleTimeout',
		'range'             => undef,
		'units'             => 'seconds'
	},
	40 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 40,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'exportedOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	41 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 41,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'exportedMessageTotalCount',
		'range'             => undef,
		'units'             => 'messages'
	},
	42 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 42,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'exportedFlowRecordTotalCount',
		'range'             => undef,
		'units'             => 'flows'
	},
	44 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 44,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv4Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	45 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 45,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv4Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	46 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 46,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsTopLabelType',
		'range'             => undef,
		'units'             => 'none'
	},
	47 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 47,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsTopLabelIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	52 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 52,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'minimumTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	53 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 53,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'maximumTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	54 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 54,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'fragmentIdentification',
		'range'             => undef,
		'units'             => 'none'
	},
	55 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 55,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'postIpClassOfService',
		'range'             => undef,
		'units'             => 'none'
	},
	56 => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 56,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'sourceMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	57 => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 57,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postDestinationMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	58 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 58,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'vlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	59 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 59,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	60 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 60,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipVersion',
		'range'             => undef,
		'units'             => 'none'
	},
	61 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 61,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowDirection',
		'range'             => undef,
		'units'             => 'none'
	},
	62 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 62,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'ipNextHopIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	63 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 63,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpNextHopIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	64 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 64,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'ipv6ExtensionHeaders',
		'range'             => undef,
		'units'             => 'none'
	},
	70 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 70,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsTopLabelStackSection',
		'range'             => undef,
		'units'             => 'none'
	},
	71 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 71,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection2',
		'range'             => undef,
		'units'             => 'none'
	},
	72 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 72,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection3',
		'range'             => undef,
		'units'             => 'none'
	},
	73 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 73,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection4',
		'range'             => undef,
		'units'             => 'none'
	},
	74 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 74,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection5',
		'range'             => undef,
		'units'             => 'none'
	},
	75 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 75,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection6',
		'range'             => undef,
		'units'             => 'none'
	},
	76 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 76,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection7',
		'range'             => undef,
		'units'             => 'none'
	},
	77 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 77,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection8',
		'range'             => undef,
		'units'             => 'none'
	},
	78 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 78,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection9',
		'range'             => undef,
		'units'             => 'none'
	},
	79 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 79,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackSection10',
		'range'             => undef,
		'units'             => 'none'
	},
	80 => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 80,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'destinationMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	81 => {
		'applicability'     => 'data',
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 81,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postSourceMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	82 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 82,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'interfaceName',
		'range'             => undef,
		'units'             => 'none'
	},
	83 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 83,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'interfaceDescription',
		'range'             => undef,
		'units'             => 'none'
	},
	85 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 85,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	86 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 86,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'packetTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	88 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 88,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'fragmentOffset',
		'range'             => undef,
		'units'             => 'none'
	},
	90 => {
		'applicability'     => 'all',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 90,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsVpnRouteDistinguisher',
		'range'             => undef,
		'units'             => 'none'
	},
	91 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 91,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'mplsTopLabelPrefixLength',
		'range'             => '0-32',
		'units'             => 'bits'
	},
	94 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 94,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationDescription',
		'range'             => undef,
		'units'             => 'none'
	},
	95 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 95,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationId',
		'range'             => undef,
		'units'             => 'none'
	},
	96 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 96,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationName',
		'range'             => undef,
		'units'             => 'none'
	},
	98 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 98,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postIpDiffServCodePoint',
		'range'             => '0-63',
		'units'             => 'none'
	},
	99 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 99,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'multicastReplicationFactor',
		'range'             => undef,
		'units'             => 'none'
	},
	101 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 101,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'classificationEngineId',
		'range'             => undef,
		'units'             => 'none'
	},
	128 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 128,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpNextAdjacentAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	129 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 129,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'bgpPrevAdjacentAsNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	130 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 130,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exporterIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	131 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 131,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exporterIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	132 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 132,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedOctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	133 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 133,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedPacketDeltaCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	134 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 134,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	135 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 135,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'droppedPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	136 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 136,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowEndReason',
		'range'             => undef,
		'units'             => 'none'
	},
	137 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 137,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'commonPropertiesId',
		'range'             => undef,
		'units'             => 'none'
	},
	138 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 138,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'observationPointId',
		'range'             => undef,
		'units'             => 'none'
	},
	139 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 139,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeCodeIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	140 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 140,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'mplsTopLabelIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	141 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 141,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'lineCardId',
		'range'             => undef,
		'units'             => 'none'
	},
	142 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 142,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'portId',
		'range'             => undef,
		'units'             => 'none'
	},
	143 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 143,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'meteringProcessId',
		'range'             => undef,
		'units'             => 'none'
	},
	144 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 144,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'exportingProcessId',
		'range'             => undef,
		'units'             => 'none'
	},
	145 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 145,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'templateId',
		'range'             => undef,
		'units'             => 'none'
	},
	146 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 146,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'wlanChannelId',
		'range'             => undef,
		'units'             => 'none'
	},
	147 => {
		'applicability'     => 'data',
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 147,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'wlanSSID',
		'range'             => undef,
		'units'             => 'none'
	},
	148 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 148,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'flowId',
		'range'             => undef,
		'units'             => 'none'
	},
	149 => {
		'applicability'     => 'option',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 149,
		'enterpriseId'      => undef,
		'group'             => 'scope',
		'name'              => 'observationDomainId',
		'range'             => undef,
		'units'             => 'none'
	},
	150 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 150,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	151 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 151,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	152 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 152,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	153 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 153,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	154 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 154,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	155 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 155,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	156 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 156,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	157 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 157,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	158 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 158,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowStartDeltaMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	159 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 159,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'flowEndDeltaMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	160 => {
		'applicability'     => 'data',
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 160,
		'enterpriseId'      => undef,
		'group'             => 'timestamp',
		'name'              => 'systemInitTimeMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	161 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 161,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowDurationMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	162 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 162,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'flowDurationMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	163 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 163,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'observedFlowTotalCount',
		'range'             => undef,
		'units'             => 'flows'
	},
	164 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 164,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'ignoredPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	165 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 165,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'ignoredOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	166 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 166,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'notSentFlowTotalCount',
		'range'             => undef,
		'units'             => 'flows'
	},
	167 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 167,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'notSentPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	168 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 168,
		'enterpriseId'      => undef,
		'group'             => 'processCounter',
		'name'              => 'notSentOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	169 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 169,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'destinationIPv6Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	170 => {
		'applicability'     => 'data',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 170,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'sourceIPv6Prefix',
		'range'             => undef,
		'units'             => 'none'
	},
	171 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 171,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	172 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 172,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	173 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 173,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'flowKeyIndicator',
		'range'             => undef,
		'units'             => 'none'
	},
	174 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 174,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	175 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 175,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'postMCastOctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	176 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 176,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeIPv4',
		'range'             => undef,
		'units'             => 'none'
	},
	177 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 177,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpCodeIPv4',
		'range'             => undef,
		'units'             => 'none'
	},
	178 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 178,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpTypeIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	179 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 179,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'icmpCodeIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	180 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 180,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'udpSourcePort',
		'range'             => undef,
		'units'             => 'none'
	},
	181 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 181,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'udpDestinationPort',
		'range'             => undef,
		'units'             => 'none'
	},
	182 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 182,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpSourcePort',
		'range'             => undef,
		'units'             => 'none'
	},
	183 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 183,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpDestinationPort',
		'range'             => undef,
		'units'             => 'none'
	},
	184 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 184,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpSequenceNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	185 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 185,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpAcknowledgementNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	186 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 186,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpWindowSize',
		'range'             => undef,
		'units'             => 'none'
	},
	187 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 187,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpUrgentPointer',
		'range'             => undef,
		'units'             => 'none'
	},
	188 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 188,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpHeaderLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	189 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 189,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipHeaderLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	190 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 190,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'totalLengthIPv4',
		'range'             => undef,
		'units'             => 'octets'
	},
	191 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 191,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'payloadLengthIPv6',
		'range'             => undef,
		'units'             => 'octets'
	},
	192 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 192,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	193 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 193,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'nextHeaderIPv6',
		'range'             => undef,
		'units'             => 'none'
	},
	194 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 194,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsPayloadLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	195 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 195,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipDiffServCodePoint',
		'range'             => '0-63',
		'units'             => 'none'
	},
	196 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 196,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipPrecedence',
		'range'             => '0-7',
		'units'             => 'none'
	},
	197 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 197,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'fragmentFlags',
		'range'             => undef,
		'units'             => 'none'
	},
	198 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 198,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetDeltaSumOfSquares',
		'range'             => undef,
		'units'             => 'none'
	},
	199 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 199,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'octetTotalSumOfSquares',
		'range'             => undef,
		'units'             => 'octets'
	},
	200 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 200,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsTopLabelTTL',
		'range'             => undef,
		'units'             => 'hops'
	},
	201 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 201,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	202 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 202,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsLabelStackDepth',
		'range'             => undef,
		'units'             => 'none'
	},
	203 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 203,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'mplsTopLabelExp',
		'range'             => undef,
		'units'             => 'none'
	},
	204 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 204,
		'enterpriseId'      => undef,
		'group'             => 'derived',
		'name'              => 'ipPayloadLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	205 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 205,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'udpMessageLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	206 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 206,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'isMulticast',
		'range'             => undef,
		'units'             => 'none'
	},
	207 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 207,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipv4IHL',
		'range'             => undef,
		'units'             => 'none'
	},
	208 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 208,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'ipv4Options',
		'range'             => undef,
		'units'             => 'none'
	},
	209 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 209,
		'enterpriseId'      => undef,
		'group'             => 'minMax',
		'name'              => 'tcpOptions',
		'range'             => undef,
		'units'             => 'none'
	},
	210 => {
		'applicability'     => 'option',
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 210,
		'enterpriseId'      => undef,
		'group'             => 'padding',
		'name'              => 'paddingOctets',
		'range'             => undef,
		'units'             => 'none'
	},
	211 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 211,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'collectorIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	212 => {
		'applicability'     => 'all',
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 212,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'collectorIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	213 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 213,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exportInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	214 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 214,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exportProtocolVersion',
		'range'             => undef,
		'units'             => 'none'
	},
	215 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 215,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exportTransportProtocol',
		'range'             => undef,
		'units'             => 'none'
	},
	216 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 216,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'collectorTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	217 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 217,
		'enterpriseId'      => undef,
		'group'             => 'config',
		'name'              => 'exporterTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	218 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 218,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpSynTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	219 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 219,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpFinTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	220 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 220,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpRstTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	221 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 221,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpPshTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	222 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 222,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpAckTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	223 => {
		'applicability'     => 'data',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 223,
		'enterpriseId'      => undef,
		'group'             => 'flowCounter',
		'name'              => 'tcpUrgTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	224 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 224,
		'enterpriseId'      => undef,
		'group'             => 'ipHeader',
		'name'              => 'ipTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	225 => {
		'applicability'     => undef,
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 225,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATSourceIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	226 => {
		'applicability'     => undef,
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 226,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATDestinationIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	227 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 227,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNAPTSourceTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	228 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 228,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNAPTDestinationTransportPort',
		'range'             => undef,
		'units'             => 'none'
	},
	229 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 229,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natOriginatingAddressRealm',
		'range'             => undef,
		'units'             => 'none'
	},
	230 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 230,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natEvent',
		'range'             => undef,
		'units'             => 'none'
	},
	231 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 231,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'initiatorOctets',
		'range'             => undef,
		'units'             => 'octets'
	},
	232 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 232,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'responderOctets',
		'range'             => undef,
		'units'             => 'octets'
	},
	233 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 233,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'firewallEvent',
		'range'             => undef,
		'units'             => 'none'
	},
	234 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 234,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressVRFID',
		'range'             => undef,
		'units'             => 'none'
	},
	235 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'default',
		'elementId'         => 235,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressVRFID',
		'range'             => undef,
		'units'             => 'none'
	},
	236 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 236,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'VRFname',
		'range'             => undef,
		'units'             => 'none'
	},
	237 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 237,
		'enterpriseId'      => undef,
		'group'             => 'subIpHeader',
		'name'              => 'postMplsTopLabelExp',
		'range'             => undef,
		'units'             => 'none'
	},
	238 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 238,
		'enterpriseId'      => undef,
		'group'             => 'transportHeader',
		'name'              => 'tcpWindowScale',
		'range'             => undef,
		'units'             => 'none'
	},
	239 => {
		'applicability'     => 'all',
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 239,
		'enterpriseId'      => undef,
		'group'             => 'misc',
		'name'              => 'biflowDirection',
		'range'             => undef,
		'units'             => 'none'
	},
	240 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 240,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetHeaderLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	241 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 241,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetPayloadLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	242 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 242,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetTotalLength',
		'range'             => undef,
		'units'             => 'octets'
	},
	243 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 243,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qVlanId',
		'range'             => undef,
		'units'             => 'octets'
	},
	244 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 244,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qPriority',
		'range'             => undef,
		'units'             => 'none'
	},
	245 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 245,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qCustomerVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	246 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 246,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qCustomerPriority',
		'range'             => undef,
		'units'             => 'none'
	},
	247 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 247,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'metroEvcId',
		'range'             => undef,
		'units'             => 'none'
	},
	248 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 248,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'metroEvcType',
		'range'             => undef,
		'units'             => 'none'
	},
	249 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 249,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'pseudoWireId',
		'range'             => undef,
		'units'             => 'none'
	},
	250 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 250,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'pseudoWireType',
		'range'             => undef,
		'units'             => 'none'
	},
	251 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 251,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'pseudoWireControlWord',
		'range'             => undef,
		'units'             => 'none'
	},
	252 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 252,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressPhysicalInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	253 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 253,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressPhysicalInterface',
		'range'             => undef,
		'units'             => 'none'
	},
	254 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 254,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postDot1qVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	255 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 255,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postDot1qCustomerVlanId',
		'range'             => undef,
		'units'             => 'none'
	},
	256 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 256,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ethernetType',
		'range'             => undef,
		'units'             => 'none'
	},
	257 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 257,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postIpPrecedence',
		'range'             => '0-7',
		'units'             => 'none'
	},
	258 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 258,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'collectionTimeMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	259 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 259,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'exportSctpStreamId',
		'range'             => undef,
		'units'             => 'none'
	},
	260 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 260,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxExportSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	261 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 261,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	262 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 262,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'messageMD5Checksum',
		'range'             => undef,
		'units'             => 'none'
	},
	263 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 263,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'messageScope',
		'range'             => undef,
		'units'             => 'none'
	},
	264 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 264,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minExportSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	265 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 265,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	266 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 266,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'opaqueOctets',
		'range'             => undef,
		'units'             => 'none'
	},
	267 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 267,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'sessionScope',
		'range'             => undef,
		'units'             => 'none'
	},
	268 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 268,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	269 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 269,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	270 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 270,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'maxFlowEndNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	271 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 271,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	272 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 272,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	273 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 273,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'minFlowStartNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	274 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 274,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'collectorCertificate',
		'range'             => undef,
		'units'             => 'none'
	},
	275 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 275,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'exporterCertificate',
		'range'             => undef,
		'units'             => 'none'
	},
	276 => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 276,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dataRecordsReliability',
		'range'             => undef,
		'units'             => 'none'
	},
	277 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 277,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationPointType',
		'range'             => undef,
		'units'             => 'none'
	},
	278 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 278,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'connectionCountNew',
		'range'             => undef,
		'units'             => 'none'
	},
	279 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'default',
		'elementId'         => 279,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'connectionSumDuration',
		'range'             => undef,
		'units'             => 'none'
	},
	280 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 280,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'connectionTransactionId',
		'range'             => undef,
		'units'             => 'none'
	},
	281 => {
		'applicability'     => undef,
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 281,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATSourceIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	282 => {
		'applicability'     => undef,
		'dataType'          => 'ipv6Address',
		'dataTypeSemantics' => 'default',
		'elementId'         => 282,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'postNATDestinationIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	283 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 283,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natPoolId',
		'range'             => undef,
		'units'             => 'none'
	},
	284 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 284,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natPoolName',
		'range'             => undef,
		'units'             => 'none'
	},
	285 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 285,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'anonymizationFlags',
		'range'             => undef,
		'units'             => 'none'
	},
	286 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 286,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'anonymizationTechnique',
		'range'             => undef,
		'units'             => 'none'
	},
	287 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 287,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementIndex',
		'range'             => undef,
		'units'             => 'none'
	},
	288 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 288,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'p2pTechnology',
		'range'             => undef,
		'units'             => 'none'
	},
	289 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 289,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'tunnelTechnology',
		'range'             => undef,
		'units'             => 'none'
	},
	290 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 290,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'encryptedTechnology',
		'range'             => undef,
		'units'             => 'none'
	},
	291 => {
		'applicability'     => undef,
		'dataType'          => 'basicList',
		'dataTypeSemantics' => 'list',
		'elementId'         => 291,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'basicList',
		'range'             => undef,
		'units'             => 'none'
	},
	292 => {
		'applicability'     => undef,
		'dataType'          => 'subTemplateList',
		'dataTypeSemantics' => 'list',
		'elementId'         => 292,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'subTemplateList',
		'range'             => undef,
		'units'             => 'none'
	},
	293 => {
		'applicability'     => undef,
		'dataType'          => 'subTemplateMultiList',
		'dataTypeSemantics' => 'list',
		'elementId'         => 293,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'subTemplateMultiList',
		'range'             => undef,
		'units'             => 'none'
	},
	294 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 294,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'bgpValidityState',
		'range'             => undef,
		'units'             => 'none'
	},
	295 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 295,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'IPSecSPI',
		'range'             => '0x0-0xFFFFFFFF',
		'units'             => 'none'
	},
	296 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 296,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'greKey',
		'range'             => '0x0-0xFFFFFFFF',
		'units'             => 'none'
	},
	297 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 297,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'natType',
		'range'             => '',
		'units'             => 'none'
	},
	298 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 298,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'initiatorPackets',
		'range'             => undef,
		'units'             => 'packets'
	},
	299 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 299,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'responderPackets',
		'range'             => undef,
		'units'             => 'packets'
	},
	300 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 300,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationDomainName',
		'range'             => undef,
		'units'             => 'none'
	},
	301 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 301,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectionSequenceId',
		'range'             => undef,
		'units'             => 'none'
	},
	302 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 302,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorId',
		'range'             => undef,
		'units'             => 'none'
	},
	303 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 303,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementId',
		'range'             => undef,
		'units'             => 'none'
	},
	304 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 304,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorAlgorithm',
		'range'             => undef,
		'units'             => 'none'
	},
	305 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 305,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingPacketInterval',
		'range'             => undef,
		'units'             => 'packets'
	},
	306 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 306,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingPacketSpace',
		'range'             => undef,
		'units'             => 'packets'
	},
	307 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 307,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingTimeInterval',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	308 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 308,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingTimeSpace',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	309 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 309,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingSize',
		'range'             => undef,
		'units'             => 'packets'
	},
	310 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 310,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingPopulation',
		'range'             => undef,
		'units'             => 'packets'
	},
	311 => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 311,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'samplingProbability',
		'range'             => undef,
		'units'             => 'none'
	},
	312 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 312,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dataLinkFrameSize',
		'range'             => undef,
		'units'             => 'none'
	},
	313 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 313,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ipHeaderPacketSection',
		'range'             => undef,
		'units'             => 'none'
	},
	314 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 314,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ipPayloadPacketSection',
		'range'             => undef,
		'units'             => 'none'
	},
	315 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 315,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dataLinkFrameSection',
		'range'             => undef,
		'units'             => 'none'
	},
	316 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 316,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'mplsLabelStackSection',
		'range'             => undef,
		'units'             => 'none'
	},
	317 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'default',
		'elementId'         => 317,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'mplsPayloadPacketSection',
		'range'             => undef,
		'units'             => 'none'
	},
	318 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 318,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorIdTotalPktsObserved',
		'range'             => undef,
		'units'             => 'packets'
	},
	319 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 319,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorIdTotalPktsSelected',
		'range'             => undef,
		'units'             => 'packets'
	},
	320 => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 320,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'absoluteError',
		'range'             => undef,
		'units'             => 'none'
	},
	321 => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 321,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'relativeError',
		'range'             => undef,
		'units'             => 'none'
	},
	322 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeSeconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 322,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeSeconds',
		'range'             => undef,
		'units'             => 'seconds'
	},
	323 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 323,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	324 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMicroseconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 324,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	325 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeNanoseconds',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 325,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'observationTimeNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	326 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 326,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'digestHashValue',
		'range'             => undef,
		'units'             => 'none'
	},
	327 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 327,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashIPPayloadOffset',
		'range'             => undef,
		'units'             => 'none'
	},
	328 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 328,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashIPPayloadSize',
		'range'             => undef,
		'units'             => 'none'
	},
	329 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 329,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashOutputRangeMin',
		'range'             => undef,
		'units'             => 'none'
	},
	330 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 330,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashOutputRangeMax',
		'range'             => undef,
		'units'             => 'none'
	},
	331 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 331,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashSelectedRangeMin',
		'range'             => undef,
		'units'             => 'none'
	},
	332 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 332,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashSelectedRangeMax',
		'range'             => undef,
		'units'             => 'none'
	},
	333 => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 333,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashDigestOutput',
		'range'             => undef,
		'units'             => 'none'
	},
	334 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 334,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'hashInitialiserValue',
		'range'             => undef,
		'units'             => 'none'
	},
	335 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 335,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'selectorName',
		'range'             => undef,
		'units'             => 'none'
	},
	336 => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 336,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'upperCILimit',
		'range'             => undef,
		'units'             => 'none'
	},
	337 => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 337,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'lowerCILimit',
		'range'             => undef,
		'units'             => 'none'
	},
	338 => {
		'applicability'     => undef,
		'dataType'          => 'float64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 338,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'confidenceLevel',
		'range'             => undef,
		'units'             => 'none'
	},
	339 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 339,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementDataType',
		'range'             => undef,
		'units'             => 'none'
	},
	340 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 340,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementDescription',
		'range'             => undef,
		'units'             => 'none'
	},
	341 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 341,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementName',
		'range'             => undef,
		'units'             => 'none'
	},
	342 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 342,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementRangeBegin',
		'range'             => undef,
		'units'             => 'none'
	},
	343 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 343,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementRangeEnd',
		'range'             => undef,
		'units'             => 'none'
	},
	344 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 344,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementSemantics',
		'range'             => undef,
		'units'             => 'none'
	},
	345 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 345,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'informationElementUnits',
		'range'             => undef,
		'units'             => 'none'
	},
	346 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 346,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'privateEnterpriseNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	347 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 347,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationInterfaceId',
		'range'             => undef,
		'units'             => 'none'
	},
	348 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 348,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationInterfaceName',
		'range'             => undef,
		'units'             => 'none'
	},
	349 => {
		'applicability'     => undef,
		'dataType'          => 'octetArray',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 349,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationUUID',
		'range'             => undef,
		'units'             => 'none'
	},
	350 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 350,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'virtualStationName',
		'range'             => undef,
		'units'             => 'none'
	},
	351 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 351,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'layer2SegmentId',
		'range'             => undef,
		'units'             => 'none'
	},
	352 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 352,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'layer2OctetDeltaCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	353 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 353,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'layer2OctetTotalCount',
		'range'             => undef,
		'units'             => 'octets'
	},
	354 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 354,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressUnicastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	355 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 355,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressMulticastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	356 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 356,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressBroadcastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	357 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 357,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressUnicastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	358 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 358,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressBroadcastPacketTotalCount',
		'range'             => undef,
		'units'             => 'packets'
	},
	359 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 359,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'monitoringIntervalStartMilliSeconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	360 => {
		'applicability'     => undef,
		'dataType'          => 'dateTimeMilliseconds',
		'dataTypeSemantics' => 'default',
		'elementId'         => 360,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'monitoringIntervalEndMilliSeconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	361 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 361,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeStart',
		'range'             => undef,
		'units'             => 'none'
	},
	362 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 362,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeEnd',
		'range'             => undef,
		'units'             => 'none'
	},
	363 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 363,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeStepSize',
		'range'             => undef,
		'units'             => 'none'
	},
	364 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 364,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'portRangeNumPorts',
		'range'             => undef,
		'units'             => 'none'
	},
	365 => {
		'applicability'     => undef,
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 365,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'staMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	366 => {
		'applicability'     => undef,
		'dataType'          => 'ipv4Address',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 366,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'staIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	367 => {
		'applicability'     => undef,
		'dataType'          => 'macAddress',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 367,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'wtpMacAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	368 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 368,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'ingressInterfaceType',
		'range'             => undef,
		'units'             => 'none'
	},
	369 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'identifier',
		'elementId'         => 369,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'egressInterfaceType',
		'range'             => undef,
		'units'             => 'none'
	},
	370 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned16',
		'dataTypeSemantics' => 'default',
		'elementId'         => 370,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rtpSequenceNumber',
		'range'             => undef,
		'units'             => 'none'
	},
	371 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 371,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'userName',
		'range'             => undef,
		'units'             => 'none'
	},
	372 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 372,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationCategoryName',
		'range'             => undef,
		'units'             => 'none'
	},
	373 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 373,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationSubCategoryName',
		'range'             => undef,
		'units'             => 'none'
	},
	374 => {
		'applicability'     => undef,
		'dataType'          => 'string',
		'dataTypeSemantics' => 'default',
		'elementId'         => 374,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'applicationGroupName',
		'range'             => undef,
		'units'             => 'none'
	},
	375 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 375,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'originalFlowsPresent',
		'range'             => undef,
		'units'             => 'none'
	},
	376 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 376,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'originalFlowsInitiated',
		'range'             => undef,
		'units'             => 'none'
	},
	377 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'deltaCounter',
		'elementId'         => 377,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'originalFlowsCompleted',
		'range'             => undef,
		'units'             => 'none'
	},
	378 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 378,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfSourceIPAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	379 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 379,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfDestinationIPAddress',
		'range'             => undef,
		'units'             => 'none'
	},
	380 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 380,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfSourceIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	381 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 381,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfDestinationIPv4Address',
		'range'             => undef,
		'units'             => 'none'
	},
	382 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 382,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfSourceIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	383 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned64',
		'dataTypeSemantics' => 'totalCounter',
		'elementId'         => 383,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'distinctCountOfDestinationIPv6Address',
		'range'             => undef,
		'units'             => 'none'
	},
	384 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned8',
		'dataTypeSemantics' => 'default',
		'elementId'         => 384,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'valueDistributionMethod',
		'range'             => undef,
		'units'             => 'none'
	},
	385 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 385,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rfc3550JitterMilliseconds',
		'range'             => undef,
		'units'             => 'milliseconds'
	},
	386 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 386,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rfc3550JitterMicroseconds',
		'range'             => undef,
		'units'             => 'microseconds'
	},
	387 => {
		'applicability'     => undef,
		'dataType'          => 'unsigned32',
		'dataTypeSemantics' => 'quantity',
		'elementId'         => 387,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'rfc3550JitterNanoseconds',
		'range'             => undef,
		'units'             => 'nanoseconds'
	},
	388 => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 388,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qDEI',
		'range'             => undef,
		'units'             => 'none'
	},
	389 => {
		'applicability'     => undef,
		'dataType'          => 'boolean',
		'dataTypeSemantics' => 'flags',
		'elementId'         => 389,
		'enterpriseId'      => undef,
		'group'             => undef,
		'name'              => 'dot1qCustomerDEI',
		'range'             => undef,
		'units'             => 'none'
	}
);

1;

__END__


# Local Variables: ***
# mode:CPerl ***
# cperl-indent-level:2 ***
# perl-indent-level:2 ***
# tab-width: 2 ***
# indent-tabs-mode: nil ***
# End: ***
#
# vim: ts=2 sw=2 expandtab
