<?php
/**
 * VariablesService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * VariablesService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class VariablesService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteVariablesID
     *
     * Delete a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteVariablesID($variable_id, $zap_trace_span = null)
    {
        $this->deleteVariablesIDWithHttpInfo($variable_id, $zap_trace_span);
    }

    /**
     * Operation deleteVariablesIDWithHttpInfo
     *
     * Delete a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariablesIDWithHttpInfo($variable_id, $zap_trace_span = null)
    {
        $request = $this->deleteVariablesIDRequest($variable_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteVariablesID'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteVariablesIDRequest($variable_id, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling deleteVariablesID'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteVariablesIDLabelsID
     *
     * Delete a label from a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $label_id The label ID to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteVariablesIDLabelsID($variable_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteVariablesIDLabelsIDWithHttpInfo($variable_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteVariablesIDLabelsIDWithHttpInfo
     *
     * Delete a label from a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $label_id The label ID to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariablesIDLabelsIDWithHttpInfo($variable_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteVariablesIDLabelsIDRequest($variable_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteVariablesIDLabelsID'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $label_id The label ID to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteVariablesIDLabelsIDRequest($variable_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling deleteVariablesIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteVariablesIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getVariables
     *
     * List all variables
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The name of the organization. (optional)
     * @param  string $org_id The organization ID. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Variables|string|string
     */
    public function getVariables($zap_trace_span = null, $org = null, $org_id = null)
    {
        list($response) = $this->getVariablesWithHttpInfo($zap_trace_span, $org, $org_id);
        return $response;
    }

    /**
     * Operation getVariablesWithHttpInfo
     *
     * List all variables
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The name of the organization. (optional)
     * @param  string $org_id The organization ID. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Variables|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariablesWithHttpInfo($zap_trace_span = null, $org = null, $org_id = null)
    {
        $request = $this->getVariablesRequest($zap_trace_span, $org, $org_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Variables';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getVariables'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The name of the organization. (optional)
     * @param  string $org_id The organization ID. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getVariablesRequest($zap_trace_span = null, $org = null, $org_id = null)
    {

        $resourcePath = '/api/v2/variables';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getVariablesID
     *
     * Retrieve a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Variable|string|string
     */
    public function getVariablesID($variable_id, $zap_trace_span = null)
    {
        list($response) = $this->getVariablesIDWithHttpInfo($variable_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getVariablesIDWithHttpInfo
     *
     * Retrieve a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Variable|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariablesIDWithHttpInfo($variable_id, $zap_trace_span = null)
    {
        $request = $this->getVariablesIDRequest($variable_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Variable';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getVariablesID'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getVariablesIDRequest($variable_id, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling getVariablesID'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getVariablesIDLabels
     *
     * List all labels for a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getVariablesIDLabels($variable_id, $zap_trace_span = null)
    {
        list($response) = $this->getVariablesIDLabelsWithHttpInfo($variable_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getVariablesIDLabelsWithHttpInfo
     *
     * List all labels for a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariablesIDLabelsWithHttpInfo($variable_id, $zap_trace_span = null)
    {
        $request = $this->getVariablesIDLabelsRequest($variable_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getVariablesIDLabels'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getVariablesIDLabelsRequest($variable_id, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling getVariablesIDLabels'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchVariablesID
     *
     * Update a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\Variable $variable Variable update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Variable|string
     */
    public function patchVariablesID($variable_id, $variable, $zap_trace_span = null)
    {
        list($response) = $this->patchVariablesIDWithHttpInfo($variable_id, $variable, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchVariablesIDWithHttpInfo
     *
     * Update a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\Variable $variable Variable update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Variable|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchVariablesIDWithHttpInfo($variable_id, $variable, $zap_trace_span = null)
    {
        $request = $this->patchVariablesIDRequest($variable_id, $variable, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Variable';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchVariablesID'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\Variable $variable Variable update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchVariablesIDRequest($variable_id, $variable, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling patchVariablesID'
            );
        }
        // verify the required parameter 'variable' is set
        if ($variable === null || (is_array($variable) && count($variable) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable when calling patchVariablesID'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($variable)) {
            $_tempBody = $variable;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postVariables
     *
     * Create a variable
     *
     * @param  \InfluxDB2\Model\Variable $variable Variable to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Variable|string
     */
    public function postVariables($variable, $zap_trace_span = null)
    {
        list($response) = $this->postVariablesWithHttpInfo($variable, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postVariablesWithHttpInfo
     *
     * Create a variable
     *
     * @param  \InfluxDB2\Model\Variable $variable Variable to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Variable|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postVariablesWithHttpInfo($variable, $zap_trace_span = null)
    {
        $request = $this->postVariablesRequest($variable, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Variable';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postVariables'
     *
     * @param  \InfluxDB2\Model\Variable $variable Variable to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postVariablesRequest($variable, $zap_trace_span = null)
    {
        // verify the required parameter 'variable' is set
        if ($variable === null || (is_array($variable) && count($variable) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable when calling postVariables'
            );
        }

        $resourcePath = '/api/v2/variables';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($variable)) {
            $_tempBody = $variable;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postVariablesIDLabels
     *
     * Add a label to a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postVariablesIDLabels($variable_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postVariablesIDLabelsWithHttpInfo($variable_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postVariablesIDLabelsWithHttpInfo
     *
     * Add a label to a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postVariablesIDLabelsWithHttpInfo($variable_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postVariablesIDLabelsRequest($variable_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postVariablesIDLabels'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postVariablesIDLabelsRequest($variable_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling postVariablesIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postVariablesIDLabels'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putVariablesID
     *
     * Replace a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\Variable $variable Variable to replace (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Variable|string
     */
    public function putVariablesID($variable_id, $variable, $zap_trace_span = null)
    {
        list($response) = $this->putVariablesIDWithHttpInfo($variable_id, $variable, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putVariablesIDWithHttpInfo
     *
     * Replace a variable
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\Variable $variable Variable to replace (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Variable|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function putVariablesIDWithHttpInfo($variable_id, $variable, $zap_trace_span = null)
    {
        $request = $this->putVariablesIDRequest($variable_id, $variable, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Variable';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putVariablesID'
     *
     * @param  string $variable_id The variable ID. (required)
     * @param  \InfluxDB2\Model\Variable $variable Variable to replace (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putVariablesIDRequest($variable_id, $variable, $zap_trace_span = null)
    {
        // verify the required parameter 'variable_id' is set
        if ($variable_id === null || (is_array($variable_id) && count($variable_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable_id when calling putVariablesID'
            );
        }
        // verify the required parameter 'variable' is set
        if ($variable === null || (is_array($variable) && count($variable) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $variable when calling putVariablesID'
            );
        }

        $resourcePath = '/api/v2/variables/{variableID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($variable_id !== null) {
            $resourcePath = str_replace(
                '{' . 'variableID' . '}',
                ObjectSerializer::toPathValue($variable_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($variable)) {
            $_tempBody = $variable;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
