<?php
include('./common.php');

echo "<html>\n";
echo "<!-- RTG Version $VERSION -->\n";
echo "<head>\n";

/* Connect to RTG MySQL Database */
$dbc = @mysqli_connect($host, $user, $pass, $db, $port) or 
	die ("MySQL Connection Failed, Check Configuration.");

if (!isset($PHP_SELF) || $PHP_SELF == "")
{
	$PHP_SELF = "rtg.php";
	$errors = isset($_GET['errors'])?$_GET['errors']:"";
	$scalex = isset($_GET['scalex'])?$_GET['scalex']:"";
	$scaley = isset($_GET['scaley'])?$_GET['scaley']:"";
	$aggr = isset($_GET['aggr'])?$_GET['aggr']:"";
	$percentile = isset($_GET['percentile'])?$_GET['percentile']:"";
	$nth = isset($_GET['nth'])?$_GET['nth']:"";
	$xplot = isset($_GET['xplot'])?$_GET['xplot']:"";
	$yplot = isset($_GET['yplot'])?$_GET['yplot']:"";
	$borderb = isset($_GET['borderb'])?$_GET['borderb']:"";
	$iid = isset($_GET['iid'])?$_GET['iid']:"";
	$rid = isset($_GET['rid'])?$_GET['rid']:"";
	$syear = isset($_GET['syear'])?$_GET['syear']:"";
	$eyear = isset($_GET['eyear'])?$_GET['eyear']:"";
	$smonth = isset($_GET['smonth'])?$_GET['smonth']:"";
	$emonth = isset($_GET['emonth'])?$_GET['emonth']:"";
	$sday = isset($_GET['sday'])?$_GET['sday']:"";
	$eday = isset($_GET['eday'])?$_GET['eday']:"";
	$shour = isset($_GET['shour'])?$_GET['shour']:"";
	$ehour = isset($_GET['ehour'])?$_GET['ehour']:"";
	$smin = isset($_GET['smin'])?$_GET['smin']:"";
	$emin = isset($_GET['emin'])?$_GET['emin']:"";
}

# Determine router, interface names as necessary
if (($rid != "") && ($iid != ""))
{
	$selectQuery = "SELECT `a`.`name`,`a`.`description`,`a`.`speed`,`b`.`name` " .
		"AS `router` FROM `interface` `a`,`router` `b` WHERE " .
		"`a`.`rid`=`b`.`rid` AND " .
		"`a`.`rid`=" . mysqli_real_escape_string($dbc, $rid) . " AND " .
		"`a`.`id`=" . mysqli_real_escape_String($dbc, $iid[0]);
	$selectResult = mysqli_query($dbc, $selectQuery);
	$selectRow = mysqli_fetch_object($selectResult);
	$interfaces = mysqli_num_rows($selectResult);
	$name = $selectRow->name;
	$description = $selectRow->description;
	$speed = ($selectRow->speed)/1000000;
	$router = $selectRow->router;
} else if (($rid != "") && ($iid == ""))
{
	$selectQuery = "SELECT `name` AS `router` FROM `router` WHERE " .
		"`rid`=" . mysqli_real_escape_string($dbc, $rid);
	$selectResult = mysqli_query($dbc, $selectQuery,);
	$selectRow = mysqli_fetch_object($selectResult);
	$router = $selectRow->router;
}

# Generate Title 
echo "<title>RTG: ";
if (($rid != "") && ($iid != ""))
	echo htmlentities($router) . ": " . htmlentities($name);
else if (($rid != "") && ($iid == ""))
	echo htmlentities($router);
echo "</title>\n";
?>

</head>
<body background="rtgback.png" bgcolor="ffffff">
<a href="http://rtg.sourceforge.net"><img src="rtg.png" border="0" alt="[RTG Home Page]" /></a>
<p>

<?php
echo "<form action=\"$PHP_SELF\" method=\"get\">\n";

if (($rid == "") && ($iid == ""))
{
	echo "<select name=\"rid\" size=10>\n";
	$selectQuery = "SELECT DISTINCT(`name`),`rid` FROM `router` ORDER BY `name`";
	$selectResult = mysqli_query($dbc, $selectQuery);
	while ($selectRow = mysqli_fetch_object($selectResult))
		echo "<option value=\"" . $selectRow->rid . "\">" . $selectRow->name . "</option>\n";
	echo "</select>\n";
}

if (($smonth != "") && ($iid == ""))
{
	echo "<blockquote><font size=+1><strong>\n";
	echo "Please select an interface!\n";
	echo "</strong></font></blockquote>\n";
}

if (($rid != "") && ($iid == ""))
{
	echo "<select name=\"rid\" size=10>\n";
	echo "<option selected value=\"$rid\">$router</option>\n";
	echo "</select>\n";

	echo "<select multiple name=\"iid[]\" size=10>\n"; 
	$selectQuery = "SELECT `id`,`name`,`description` FROM `interface` WHERE " .
		"`rid`=" . mysqli_real_escape_string($dbc, $rid) . " ORDER BY `name`";
	$selectResult = mysqli_query($dbc, $selectQuery);
	while ($selectRow = mysqli_fetch_object($selectResult))
		echo "<option value=\"" . $selectRow->id . "\">" .
			$selectRow->name . " (" . $selectRow->description . ")</option>\n";
	echo "</select>\n";

	echo "<p><table>\n";
	echo "<tr><td>From: </td>\n";
	echo "<td><input type=\"text\" name=\"smonth\" size=3 maxlength=2 value=\"";
	printf("%02d", date("m"));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"sday\" size=3 maxlength=2 value=\"";
	printf("%02d", date("d"));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"syear\" size=5 maxlength=4 value=\"";
	printf("%04d", date("Y"));
	echo "\" /></td>\n";
	echo "<td><input type=\"text\" name=\"shour\" size=3 maxlength=2 value=\"00\" />:\n";
	echo "<input type=\"text\" name=\"smin\" size=3 maxlength=2 value=\"00\" /></td></tr>\n";

	echo "<tr><td>To: </td>\n";
	echo "<td><input type=\"text\" name=\"emonth\" size=3 maxlength=2 value=\"";
	printf("%02d", date("m"));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"eday\" size=3 maxlength=2 value=\"";
	printf("%02d", date("d"));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"eyear\" size=5 maxlength=4 value=\"";
	printf("%04d", date("Y"));
	echo "\" /></td>\n";
	echo "<td><input type=\"text\" name=\"ehour\" size=3 maxlength=2 value=\"23\" />:\n";
	echo "<input type=\"text\" name=\"emin\" size=3 maxlength=2 value=\"59\" /></td></tr>\n";

	echo "<tr><td>Aggregate Interfaces: </td><td><input type=\"checkbox\" name=\"aggr\" /></td></tr>\n";
	echo "<tr><td><input type=\"text\" name=\"nth\" size=2 maxlength=2 value=\"95\" />th Percentile: </td>\n";
	echo "<td><input type=\"checkbox\" name=\"percentile\" /></td></tr>\n";
	echo "<tr><td>Fit to Data: </td><td><input type=\"checkbox\" name=\"scalex\" /></td></tr>\n";
	echo "<tr><td>Fit to Speed: </td><td><input type=\"checkbox\" name=\"scaley\" /></td></tr>\n";
	echo "<tr><td>X Size: </td><td><input type=\"text\" name=\"xplot\" size=3 value=\"500\" /></td></tr>\n";
	echo "<tr><td>Y Size: </td><td><input type=\"text\" name=\"yplot\" size=3 value=\"150\" /></td></tr>\n";
	echo "<tr><td>BorderB: </td><td><input type=\"text\" name=\"borderb\" size=3 value=\"70\" /></td></tr>\n";
	echo "</table>\n";
}

if (($bt != "" || $smonth != "") && ($iid != ""))
{ 
	/* Format into GNU date syntax */
	if ($bt == "")
	{
		$bt = strtotime("$syear-$smonth-$sday $shour:$smin:00");
		$et = strtotime("$eyear-$emonth-$eday $ehour:$emin:59");
	}

	$range = "`dtime`>FROM_UNIXTIME(" . mysqli_real_escape_string($dbc, $bt) . 
		") AND `dtime`<=FROM_UNIXTIME(" . mysqli_real_escape_string($dbc, $et) . ") " .
		" AND `id`=" . mysqli_real_escape_string($dbc, $iid[0]);

	$selectQuery = "SELECT `description`,`name`,`speed` FROM `interface` " .
		"WHERE `rid`=" . mysqli_real_escape_string($dbc, $rid) . " AND " .
		"`id`=" . mysqli_real_escape_string($dbc, $iid[0]);
	$selectResult = mysqli_query($dbc, $selectQuery);
	$selectRow = mysqli_fetch_object($selectResult);
	echo "<table border=0>\n";
	echo "<tr><td><i>Device</i>:</td><td>" . htmlentities($router) . " (" . htmlentities($rid) . ")</td></tr>\n";
	echo "<tr><td><i>Interface</i>:</td><td>" . htmlentities($selectRow->name) . " (" . htmlentities($iid[0]) . ")</td></tr>\n";
	printf("<tr><td><i>Speed</i>:</td><td>%2.3f Mbps</td></tr>\n", $selectRow->speed / 1000000);
	echo "<tr><td><i>Description</i>:</td><td>" . htmlentities($selectRow->description) . "</td></tr>\n";
	echo strftime("<tr><td><i>Period</i>:</td><td>%m/%d/%Y %H:%M - ", $bt);
	echo strftime("%m/%d/%Y %H:%M</td></tr>\n", $et);
	echo "</table>\n";
	echo "<p>\n";
 
	$args = "t1=ifInOctets_" . urlencode($rid) . "&amp;t2=ifOutOctets_" . urlencode($rid) . 
		"&amp;begin=" . urlencode($bt) . "&amp;end=" . urlencode($et) . 
		"&amp;units=bits/s&amp;factor=8" . 
		"&amp;title=" . urlencode($selectRow->description) .
		"&amp;t1_name=" . urlencode("Input Octets") . 
		"&amp;t2_name=" . urlencode("Output Octets");
	foreach ($iid as $value)
		$args .= "&amp;iid=" . urlencode($value);
	if ($scalex != "")
		$args .= "&amp;scalex=yes";
	if ($scaley != "")
		$args .= "&amp;scaley=yes";
	if ($xplot != "")
		$args .= "&amp;xplot=" . urlencode($xplot);
	if ($yplot != "")
		$args .= "&amp;yplot=" . urlencode($yplot);
	if ($borderb != "")
		$args .= "&amp;borderb=" . urlencode($borderb);
	if ($aggr != "")
		$args .= "&amp;aggr=yes";
	if ($percentile != "")
		$args .= "&amp;percentile=" . urlencode($nth);
	echo "<img src=\"rtgplot.cgi?$args\" alt=\"Traffic graph\" /><br />\n";

	$args = "t1=ifInUcastPkts_" . urlencode($rid) . "&amp;t2=ifOutUcastPkts_" . urlencode($rid) . 
		"&amp;begin=" . urlencode($bt) . "&amp;end=" . urlencode($et) . "&amp;units=pkts/s" .
		"&amp;title=" . urlencode($selectRow->description) .
		"&amp;t1_name=" . urlencode("Input Packets") . 
		"&amp;t2_name=" . urlencode("Output Packets");
	foreach ($iid as $value)
		$args .= "&amp;iid=" . urlencode($value);
	if ($scalex != "")
		$args .= "&amp;scalex=yes";
	if ($xplot != "")
		$args .= "&amp;xplot=" . urlencode($xplot);
	if ($yplot != "")
		$args .= "&amp;yplot=" . urlencode($yplot);
	if ($borderb != "")
		$args .= "&amp;borderb=" . urlencode($borderb);
	if ($aggr != "")
		$args .= "&amp;aggr=yes";
	if ($percentile != "")
		$args .= "&amp;percentile=" . urlencode($nth);
	echo "<img src=\"rtgplot.cgi?$args\" alt=\"Packet graph\" /><br />\n";

	if ($errors != "")
	echo "<img src=\"rtgplot.cgi?t1=ifInErrors_" . urlencode($rid) . "&amp;begin=" . urlencode($bt) . 
		"&amp;end=" . urlencode($et) . "&amp;units=errors&amp;impulses=yes" .
		"&amp;title=" . urlencode($selectRow->description) . 
		"&amp;t1_name=" . urlencode("Errors") . "\" alt=\"Error graph\" />\n";
} 

mysqli_close($dbc);
?>

<p>
<input type="submit" value="Ok" />
</form>
<br />
<hr />
<font face="Arial" size="2">
<?php
 echo "<a href=\"http://rtg.sourceforge.net\">RTG</a> Version $VERSION</font>";
?>
</body>
</html>
