/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.visitors.typeinference.ITypeConstraint;
import java.util.Collections;
import java.util.List;

public class TypeSearchVarInfo {
    private final SSAVar var;
    private boolean typeResolved;
    private ArgType currentType;
    private List<ArgType> candidateTypes;
    private int currentIndex = -1;
    private List<ITypeConstraint> constraints;

    public TypeSearchVarInfo(SSAVar var) {
        this.var = var;
    }

    public void markResolved(ArgType type) {
        this.currentType = type;
        this.typeResolved = true;
        this.candidateTypes = Collections.emptyList();
    }

    public void reset() {
        if (this.typeResolved) {
            return;
        }
        this.currentIndex = 0;
        this.currentType = this.candidateTypes.get(0);
    }

    public boolean nextType() {
        if (this.typeResolved) {
            return false;
        }
        int len = this.candidateTypes.size();
        this.currentIndex = (this.currentIndex + 1) % len;
        this.currentType = this.candidateTypes.get(this.currentIndex);
        return this.currentIndex == 0;
    }

    public SSAVar getVar() {
        return this.var;
    }

    public boolean isTypeResolved() {
        return this.typeResolved;
    }

    public void setTypeResolved(boolean typeResolved) {
        this.typeResolved = typeResolved;
    }

    public ArgType getCurrentType() {
        return this.currentType;
    }

    public void setCurrentType(ArgType currentType) {
        this.currentType = currentType;
    }

    public List<ArgType> getCandidateTypes() {
        return this.candidateTypes;
    }

    public void setCandidateTypes(List<ArgType> candidateTypes) {
        this.candidateTypes = candidateTypes;
    }

    public List<ITypeConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<ITypeConstraint> constraints) {
        this.constraints = constraints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.var.toShortString());
        if (this.typeResolved) {
            sb.append(", resolved type: ").append(this.currentType);
        } else {
            sb.append(", currentType=").append(this.currentType);
            sb.append(", candidateTypes=").append(this.candidateTypes);
            sb.append(", constraints=").append(this.constraints);
        }
        return sb.toString();
    }
}

