/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.IDEUtil;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swing.MigLayout;

public class SwingDemo
extends JFrame {
    public static final int INITIAL_INDEX = 0;
    private static final boolean DEBUG = false;
    private static final boolean OPAQUE = false;
    private static final String[][] panels = new String[][]{{"Welcome", "\n\n         \"MigLayout makes complex layouts easy and normal layouts one-liners.\""}, {"Quick Start", "This is an example of how to build a common dialog type. Note that there are no special components, nested panels or absolute references to cell positions. If you look at the source code you will see that the layout code is very simple to understand."}, {"Plain", "A simple example on how simple it is to create normal forms. No builders needed since the whole layout manager works like a builder."}, {"Alignments", "Shows how the alignment of components are specified. At the top/left is the alignment for the column/row. The components have no alignments specified.\n\nNote that baseline alignment will be interpreted as 'center' before JDK 6."}, {"Cell Alignments", "Shows how components are aligned when both column/row alignments and component constraints are specified. At the top/left are the alignment for the column/row and the text on the buttons is the component constraint that will override the column/row alignment if it is an alignment.\n\nNote that baseline alignment will be interpreted as 'center' before JDK 6."}, {"Basic Sizes", "A simple example that shows how to use the column or row min/preferred/max size to set the sizes of the contained components and also an example that shows how to do this directly in the component constraints."}, {"Growing", "A simple example that shows how to use the growx and growy constraint to set the sizes and how they should grow to fit the available size. Both the column/row and the component grow/shrink constraints can be set, but the components will always be confined to the space given by its column/row."}, {"Grow Shrink", "Demonstrates the very flexible grow and shrink constraints that can be set on a component.\nComponents can be divided into grow/shrink groups and also have grow/shrink weight within each of those groups.\n\nBy default components shrink to their inherent (or specified) minimum size, but they don't grow."}, {"Span", "This example shows the powerful spanning and splitting that can be specified in the component constraints. With spanning any number of cells can be merged with the additional option to split that space for more than one component. This makes layouts very flexible and reduces the number of times you will need nested panels to very few."}, {"Flow Direction", "Shows the different flow directions. Flow direction for the layout specifies if the next cell will be in the x or y dimension. Note that it can be a different flow direction in the slit cell (the middle cell is slit in two). Wrap is set to 3 for all panels."}, {"Grouping", "Sizes for both components and columns/rows can be grouped so they get the same size. For instance buttons in a button bar can be given a size-group so that they will all get the same minimum and preferred size (the largest within the group). Size-groups can be set for the width, height or both."}, {"Units", "Demonstrates the basic units that are understood by MigLayout. These units can be extended by the user by adding one or more UnitConverter(s)."}, {"Component Sizes", "Minimum, preferred and maximum component sizes can be overridden in the component constraints using any unit type. The format to do this is short and simple to understand. You simply specify the min, preferred and max sizes with a colon between.\n\nAbove are some examples of this. An exclamation mark means that the value will be used for all sizes."}, {"Bound Sizes", "Shows how to create columns that are stable between tabs using minimum sizes."}, {"Cell Position", "Even though MigLayout has automatic grid flow you can still specify the cell position explicitly. You can even combine absolute (x, y) and flow (skip, wrap and newline) constraints to build your layout."}, {"Orientation", "MigLayout supports not only right-to-left orientation, but also bottom-to-top. You can even set the flow direction so that the flow is vertical instead of horizontal. It will automatically pick up if right-to-left is to be used depending on the ComponentWrapper, but it can also be manually set for every layout."}, {"Absolute Position", "Demonstrates the option to place any number of components using absolute coordinates. This can be just the position (if min/preferred size) using \"x y p p\" format orthe bounds using the \"x1 y1 x2 y2\" format. Any unit can be used and percent is relative to the parent.\nAbsolute components will not disturb the flow or occupy cells in the grid. Absolute positioned components will be taken into account when calculating the container's preferred size."}, {"Component Links", "Components can be linked to any side of any other component. It can be a forward, backward or cyclic link references, as long as it is stable and won't continue to change value over many iterations.Links are referencing the ID of another component. The ID can be overridden by the component's constrains or is provided by the ComponentWrapper. For instance it will use the component's 'name' on Swing.\nSince the links can be combined with any expression (such as 'butt1.x+10' or 'max(button.x, 200)' the links are very customizable."}, {"Docking", "Docking components can be added around the grid. The docked component will get the whole width/height on the docked side by default, however this can be overridden. When all docked components are laid out, whatever space is left will be available for the normal grid laid out components. Docked components does not in any way affect the flow in the grid.\n\nSince the docking runs in the same code path as the normal layout code the same properties can be specified for the docking components. You can for instance set the sizes and alignment or link other components to their docked component's bounds."}, {"Button Bars", "Button order is very customizable and are by default different on the supported platforms. E.g. Gaps, button order and minimum button size are properties that are 'per platform'. MigLayout picks up the current platform automatically and adjusts the button order and minimum button size accordingly, all without using a button builder or any other special code construct."}, {"Visual Bounds", "Human perceptible bounds may not be the same as the mathematical bounds for the component. This is for instance the case if there is a drop shadow painted by the component's border. MigLayout can compensate for this in a simple way. Note the top middle tab-component, it is not aligned visually correct on Windows XP. For the second tab the bounds are corrected automatically on Windows XP."}, {"Debug", "Demonstrates the non-intrusive way to get visual debugging aid. There is no need to use a special DebugPanel or anything that will need code changes. The user can simply turn on debug on the layout manager by using the \"debug\" constraint and it will continuously repaint the panel with debug information on top. This means you don't have to change your code to debug!"}, {"Layout Showdown", "This is an implementation of the Layout Showdown posted on java.net by John O'Conner. The first tab is a pure implemenetation of the showdown that follows all the rules. The second tab is a slightly fixed version that follows some improved layout guidelines.The source code is for both the first and for the fixed version. Note the simplification of the code for the fixed version. Writing better layouts with MiG Layout is reasier that writing bad.\n\nReference: http://weblogs.java.net/blog/joconner/archive/2006/10/more_informatio.html"}, {"API Constraints1", "This dialog shows the constraint API added to v2.0. It works the same way as the string constraints but with chained method calls. See the source code for details."}, {"API Constraints2", "This dialog shows the constraint API added to v2.0. It works the same way as the string constraints but with chained method calls. See the source code for details."}};
    private int lastIndex = -10;
    private JPanel contentPanel = new JPanel(new MigLayout("wrap", "[]unrel[grow]", "[grow][pref]"));
    private JTabbedPane layoutPickerTabPane = new JTabbedPane();
    private JList pickerList = new JList(new DefaultListModel());
    private JTabbedPane southTabPane = new JTabbedPane();
    private JScrollPane descrTextAreaScroll = this.createTextAreaScroll("", 5, 80, true);
    private JTextArea descrTextArea = (JTextArea)this.descrTextAreaScroll.getViewport().getView();
    private JScrollPane sourceTextAreaScroll = null;
    private JTextArea sourceTextArea = null;
    private JPanel layoutDisplayPanel = new JPanel(new BorderLayout(0, 0));
    private static boolean buttonOpaque = true;
    private static boolean contentAreaFilled = true;
    private JFrame sourceFrame = null;
    private JTextArea sourceFrameTextArea = null;
    private static int benchRuns = 0;
    private static long startupMillis = 0L;
    private static long timeToShowMillis = 0L;
    private static long benchRunTime = 0L;
    private static String benchOutFileName = null;
    private static boolean append = false;
    private static long lastRunTimeStart = 0L;
    private static StringBuffer runTimeSB = null;
    private final ToolTipListener toolTipListener = new ToolTipListener();
    private final ConstraintListener constraintListener = new ConstraintListener();
    private static final Font BUTT_FONT = new Font("monospaced", 0, 12);
    static final Color LABEL_COLOR = new Color(0, 70, 213);

    public static void main(String[] args) {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "MiGLayout Swing Demo");
        }
        catch (Throwable ex) {
            // empty catch block
        }
        startupMillis = System.currentTimeMillis();
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.startsWith("-laf")) {
                    laf = arg.substring(4);
                    continue;
                }
                if (arg.startsWith("-bench")) {
                    benchRuns = 10;
                    try {
                        benchRuns = Integer.parseInt(arg.substring(6));
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (arg.startsWith("-bout")) {
                    benchOutFileName = arg.substring(5);
                    continue;
                }
                if (arg.startsWith("-append")) {
                    append = true;
                    continue;
                }
                if (arg.startsWith("-verbose")) {
                    runTimeSB = new StringBuffer(256);
                    continue;
                }
                if (arg.equals("-steel")) {
                    laf = "javax.swing.plaf.metal.MetalLookAndFeel";
                    System.setProperty("swing.metalTheme", "steel");
                    continue;
                }
                if (arg.equals("-ocean")) {
                    laf = "javax.swing.plaf.metal.MetalLookAndFeel";
                    continue;
                }
                System.out.println("Usage: [-laf[look_&_feel_class_name]] [-bench[#_of_runs]] [-bout[benchmark_results_filename]] [-append] [-steel] [-ocean]\n -laf    Set the Application Look&Feel. (Look and feel must be in Classpath)\n -bench  Run demo as benchmark. Run count can be appended. 10 is default.\n -bout   Benchmark results output filename.\n -append Appends the result to the -bout file.\n -verbose Print the times of every run.\n -steel  Sets the old Steel theme for Sun's Metal look&feel.\n -ocean  Sets the Ocean theme for Sun's Metal look&feel.\n\nExamples:\n java -jar swingdemoapp.jar -bench -boutC:/bench.txt -append\n java -jar swingdemoapp.jar -ocean -bench20\n java -cp c:\\looks-2.0.4.jar;.\\swingdemoapp.jar net.miginfocom.demo.SwingDemo -lafcom.jgoodies.looks.plastic.PlasticLookAndFeel -bench20 -boutC:/bench.txt");
                System.exit(0);
            }
        }
        if (benchRuns == 0) {
            LayoutUtil.setDesignTime(null, true);
        }
        if (laf.endsWith("WindowsLookAndFeel")) {
            buttonOpaque = false;
        }
        if (laf.endsWith("AquaLookAndFeel")) {
            contentAreaFilled = false;
        }
        final String laff = laf;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(laff);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                new SwingDemo();
            }
        });
    }

    public SwingDemo() {
        super("MigLayout Swing Demo v2.5 - Mig Layout v" + LayoutUtil.getVersion());
        if (benchRuns == 0) {
            this.sourceTextAreaScroll = this.createTextAreaScroll("", 5, 80, true);
            this.sourceTextArea = (JTextArea)this.sourceTextAreaScroll.getViewport().getView();
        }
        this.contentPanel.add((Component)this.layoutPickerTabPane, "spany,grow");
        this.contentPanel.add((Component)this.layoutDisplayPanel, "grow");
        this.contentPanel.add((Component)this.southTabPane, "growx");
        this.setContentPane(this.contentPanel);
        this.pickerList.setOpaque(false);
        ((DefaultListCellRenderer)this.pickerList.getCellRenderer()).setOpaque(false);
        this.pickerList.setSelectionForeground(new Color(0, 0, 220));
        this.pickerList.setBackground(null);
        this.pickerList.setBorder(new EmptyBorder(2, 5, 0, 4));
        this.pickerList.setFont(this.pickerList.getFont().deriveFont(1));
        this.layoutPickerTabPane.addTab("Example Browser", this.pickerList);
        this.descrTextAreaScroll.setBorder(null);
        this.descrTextAreaScroll.setOpaque(false);
        this.descrTextAreaScroll.getViewport().setOpaque(false);
        this.descrTextArea.setOpaque(false);
        this.descrTextArea.setEditable(false);
        this.descrTextArea.setBorder(new EmptyBorder(0, 4, 0, 4));
        this.southTabPane.addTab("Description", this.descrTextAreaScroll);
        if (this.sourceTextArea != null) {
            this.sourceTextAreaScroll.setBorder(null);
            this.sourceTextAreaScroll.setOpaque(false);
            this.sourceTextAreaScroll.getViewport().setOpaque(false);
            this.sourceTextAreaScroll.setHorizontalScrollBarPolicy(30);
            this.sourceTextArea.setOpaque(false);
            this.sourceTextArea.setLineWrap(false);
            this.sourceTextArea.setWrapStyleWord(false);
            this.sourceTextArea.setEditable(false);
            this.sourceTextArea.setBorder(new EmptyBorder(0, 4, 0, 4));
            this.sourceTextArea.setFont(new Font("monospaced", 0, 11));
            this.southTabPane.addTab("Source Code", this.sourceTextAreaScroll);
            this.southTabPane.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        SwingDemo.this.showSourceInFrame();
                    }
                }
            });
        }
        for (int i = 0; i < panels.length; ++i) {
            ((DefaultListModel)this.pickerList.getModel()).addElement(panels[i][0]);
        }
        try {
            if (UIManager.getLookAndFeel().getID().equals("Aqua")) {
                this.setSize(1000, 750);
            } else {
                this.setSize(900, 650);
            }
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(3);
            this.setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        this.pickerList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int ix = SwingDemo.this.pickerList.getSelectedIndex();
                if (ix == -1 || SwingDemo.this.lastIndex == ix) {
                    return;
                }
                SwingDemo.this.lastIndex = ix;
                String methodName = "create" + panels[ix][0].replace(' ', '_');
                SwingDemo.this.layoutDisplayPanel.removeAll();
                try {
                    SwingDemo.this.pickerList.requestFocusInWindow();
                    JComponent panel = (JComponent)SwingDemo.class.getMethod(methodName, new Class[0]).invoke((Object)SwingDemo.this, new Object[0]);
                    SwingDemo.this.layoutDisplayPanel.add(panel);
                    SwingDemo.this.descrTextArea.setText(panels[ix][1]);
                    SwingDemo.this.descrTextArea.setCaretPosition(0);
                    SwingDemo.this.contentPanel.revalidate();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                SwingDemo.this.southTabPane.setSelectedIndex(0);
            }
        });
        this.pickerList.requestFocusInWindow();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        if (benchRuns > 0) {
            this.doBenchmark();
        } else {
            this.pickerList.setSelectedIndex(0);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getID() == 401 && e.getKeyCode() == 66 && (e.getModifiersEx() & 0x80) > 0) {
                        startupMillis = System.currentTimeMillis();
                        timeToShowMillis = System.currentTimeMillis() - startupMillis;
                        benchRuns = 1;
                        SwingDemo.this.doBenchmark();
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void doBenchmark() {
        Thread benchThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int j = 0; j < benchRuns; ++j) {
                    lastRunTimeStart = System.currentTimeMillis();
                    int iCnt = SwingDemo.this.pickerList.getModel().getSize();
                    for (int i = 0; i < iCnt; ++i) {
                        if (benchRuns > 0 && panels[i][0].equals("Visual Bounds")) continue;
                        final int ii = i;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    SwingDemo.this.pickerList.setSelectedIndex(ii);
                                    Toolkit.getDefaultToolkit().sync();
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Component[] comps = SwingDemo.this.layoutDisplayPanel.getComponents();
                        for (int cIx = 0; cIx < comps.length; ++cIx) {
                            if (!(comps[cIx] instanceof JTabbedPane)) continue;
                            final JTabbedPane tp = (JTabbedPane)comps[cIx];
                            int kCnt = tp.getTabCount();
                            for (int k = 0; k < kCnt; ++k) {
                                final int kk = k;
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            tp.setSelectedIndex(kk);
                                            Toolkit.getDefaultToolkit().sync();
                                            if (timeToShowMillis == 0L) {
                                                timeToShowMillis = System.currentTimeMillis() - startupMillis;
                                            }
                                        }
                                    });
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (runTimeSB == null) continue;
                    runTimeSB.append("Run ").append(j).append(": ");
                    runTimeSB.append(System.currentTimeMillis() - lastRunTimeStart).append(" millis.\n");
                }
                benchRunTime = System.currentTimeMillis() - startupMillis - timeToShowMillis;
                String message = "Java Version:       " + System.getProperty("java.version") + "\n" + "Look & Feel:        " + UIManager.getLookAndFeel().getDescription() + "\n" + "Time to Show:       " + timeToShowMillis + " millis.\n" + (runTimeSB != null ? runTimeSB.toString() : "") + "Benchmark Run Time: " + benchRunTime + " millis.\n" + "Average Run Time:   " + benchRunTime / (long)benchRuns + " millis (" + benchRuns + " runs).\n\n";
                if (benchOutFileName == null) {
                    JOptionPane.showMessageDialog(SwingDemo.this, message, "Results", 1);
                } else {
                    FileWriter fw = null;
                    try {
                        fw = new FileWriter(benchOutFileName, append);
                        fw.write(message);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (fw != null) {
                            try {
                                fw.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                System.out.println(message);
            }
        };
        benchThread.start();
    }

    private void setSource(String source) {
        if (benchRuns > 0 || this.sourceTextArea == null) {
            return;
        }
        if (source.length() > 0) {
            source = source.replaceAll("\t\t", "");
            source = "DOUBLE CLICK TAB TO SHOW SOURCE IN SEPARATE WINDOW!\n===================================================\n\n" + source;
        }
        this.sourceTextArea.setText(source);
        this.sourceTextArea.setCaretPosition(0);
        if (this.sourceFrame != null && this.sourceFrame.isVisible()) {
            this.sourceFrameTextArea.setText(source.length() > 105 ? source.substring(105) : "No Source Code Available!");
            this.sourceFrameTextArea.setCaretPosition(0);
        }
    }

    private void showSourceInFrame() {
        if (this.sourceTextArea == null) {
            return;
        }
        JScrollPane sourceFrameTextAreaScroll = this.createTextAreaScroll("", 5, 80, true);
        this.sourceFrameTextArea = (JTextArea)sourceFrameTextAreaScroll.getViewport().getView();
        sourceFrameTextAreaScroll.setBorder(null);
        sourceFrameTextAreaScroll.setHorizontalScrollBarPolicy(30);
        this.sourceFrameTextArea.setLineWrap(false);
        this.sourceFrameTextArea.setWrapStyleWord(false);
        this.sourceFrameTextArea.setEditable(false);
        this.sourceFrameTextArea.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.sourceFrameTextArea.setFont(new Font("monospaced", 0, 12));
        String source = this.sourceTextArea.getText();
        this.sourceFrameTextArea.setText(source.length() > 105 ? source.substring(105) : "No Source Code Available!");
        this.sourceFrameTextArea.setCaretPosition(0);
        this.sourceFrame = new JFrame("Source Code");
        this.sourceFrame.getContentPane().add((Component)sourceFrameTextAreaScroll, "Center");
        this.sourceFrame.setSize(700, 800);
        this.sourceFrame.setLocationRelativeTo(this);
        this.sourceFrame.setVisible(true);
    }

    public JComponent createTest() {
        JPanel thisp = new JPanel();
        MigLayout layout = new MigLayout();
        thisp.setLayout(layout);
        return thisp;
    }

    public JComponent createAPI_Constraints1() {
        JTabbedPane tabbedPane = new JTabbedPane();
        LC layC = new LC().fill().wrap();
        AC colC = new AC().align("right", 1).fill(2, 4).grow(100.0f, 2, 4).align("right", 3).gap("15", 2);
        AC rowC = new AC().align("top", 7).gap("15!", 6).grow(100.0f, 8);
        JPanel panel = this.createTabPanel(new MigLayout(layC, colC, rowC));
        JScrollPane list2 = new JScrollPane(new JList<String>(new String[]{"Mouse, Mickey"}));
        panel.add((Component)list2, new CC().spanY().growY().minWidth("150").gapX(null, "10"));
        panel.add(new JLabel("Last Name"));
        panel.add(new JTextField());
        panel.add(new JLabel("First Name"));
        panel.add((Component)new JTextField(), new CC().wrap().alignX("right"));
        panel.add(new JLabel("Phone"));
        panel.add(new JTextField());
        panel.add(new JLabel("Email"));
        panel.add(new JTextField());
        panel.add(new JLabel("Address 1"));
        panel.add((Component)new JTextField(), new CC().spanX().growX());
        panel.add(new JLabel("Address 2"));
        panel.add((Component)new JTextField(), new CC().spanX().growX());
        panel.add(new JLabel("City"));
        panel.add((Component)new JTextField(), new CC().wrap());
        panel.add(new JLabel("State"));
        panel.add(new JTextField());
        panel.add(new JLabel("Postal Code"));
        panel.add((Component)new JTextField(10), new CC().spanX(2).growX(0.0f));
        panel.add(new JLabel("Country"));
        panel.add((Component)new JTextField(), new CC().wrap());
        panel.add((Component)new JButton("New"), new CC().spanX(5).split(5).tag("other"));
        panel.add((Component)new JButton("Delete"), new CC().tag("other"));
        panel.add((Component)new JButton("Edit"), new CC().tag("other"));
        panel.add((Component)new JButton("Save"), new CC().tag("other"));
        panel.add((Component)new JButton("Cancel"), new CC().tag("cancel"));
        tabbedPane.addTab("Layout Showdown (improved)", panel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nLC layC = new LC().fill().wrap();\nAC colC = new AC().align(\"right\", 1).fill(2, 4).grow(100, 2, 4).align(\"right\", 3).gap(\"15\", 2);\nAC rowC = new AC().align(\"top\", 7).gap(\"15!\", 6).grow(100, 8);\n\nJPanel panel = createTabPanel(new MigLayout(layC, colC, rowC));    // Makes the background gradient\n\n// References to text fields not stored to reduce code clutter.\n\nJScrollPane list2 = new JScrollPane(new JList(new String[] {\"Mouse, Mickey\"}));\npanel.add(list2,                     new CC().spanY().growY().minWidth(\"150\").gapX(null, \"10\"));\n\npanel.add(new JLabel(\"Last Name\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"First Name\"));\npanel.add(new JTextField(),          new CC().wrap().alignX(\"right\"));\npanel.add(new JLabel(\"Phone\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"Email\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"Address 1\"));\npanel.add(new JTextField(),          new CC().spanX().growX());\npanel.add(new JLabel(\"Address 2\"));\npanel.add(new JTextField(),          new CC().spanX().growX());\npanel.add(new JLabel(\"City\"));\npanel.add(new JTextField(),          new CC().wrap());\npanel.add(new JLabel(\"State\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"Postal Code\"));\npanel.add(new JTextField(10),        new CC().spanX(2).growX(0));\npanel.add(new JLabel(\"Country\"));\npanel.add(new JTextField(),          new CC().wrap());\n\npanel.add(new JButton(\"New\"),        new CC().spanX(5).split(5).tag(\"other\"));\npanel.add(new JButton(\"Delete\"),     new CC().tag(\"other\"));\npanel.add(new JButton(\"Edit\"),       new CC().tag(\"other\"));\npanel.add(new JButton(\"Save\"),       new CC().tag(\"other\"));\npanel.add(new JButton(\"Cancel\"),     new CC().tag(\"cancel\"));\n\ntabbedPane.addTab(\"Layout Showdown (improved)\", panel);");
        return tabbedPane;
    }

    public JComponent createAPI_Constraints2() {
        JTabbedPane tabbedPane = new JTabbedPane();
        LC layC = new LC().fill().wrap();
        AC colC = new AC().align("right", 0).fill(1, 3).grow(100.0f, 1, 3).align("right", 2).gap("15", 1);
        AC rowC = new AC().index(6).gap("15!").align("top").grow(100.0f, 8);
        JPanel panel = this.createTabPanel(new MigLayout(layC, colC, rowC));
        panel.add(new JLabel("Last Name"));
        panel.add(new JTextField());
        panel.add(new JLabel("First Name"));
        panel.add((Component)new JTextField(), new CC().wrap());
        panel.add(new JLabel("Phone"));
        panel.add(new JTextField());
        panel.add(new JLabel("Email"));
        panel.add(new JTextField());
        panel.add(new JLabel("Address 1"));
        panel.add((Component)new JTextField(), new CC().spanX().growX());
        panel.add(new JLabel("Address 2"));
        panel.add((Component)new JTextField(), new CC().spanX().growX());
        panel.add(new JLabel("City"));
        panel.add((Component)new JTextField(), new CC().wrap());
        panel.add(new JLabel("State"));
        panel.add(new JTextField());
        panel.add(new JLabel("Postal Code"));
        panel.add((Component)new JTextField(10), new CC().spanX(2).growX(0.0f));
        panel.add(new JLabel("Country"));
        panel.add((Component)new JTextField(), new CC().wrap());
        panel.add((Component)this.createButton("New"), new CC().spanX(5).split(5).tag("other"));
        panel.add((Component)this.createButton("Delete"), new CC().tag("other"));
        panel.add((Component)this.createButton("Edit"), new CC().tag("other"));
        panel.add((Component)this.createButton("Save"), new CC().tag("other"));
        panel.add((Component)this.createButton("Cancel"), new CC().tag("cancel"));
        tabbedPane.addTab("Layout Showdown (improved)", panel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nLC layC = new LC().fill().wrap();\nAC colC = new AC().align(\"right\", 0).fill(1, 3).grow(100, 1, 3).align(\"right\", 2).gap(\"15\", 1);\nAC rowC = new AC().index(6).gap(\"15!\").align(\"top\").grow(100, 8);\n\nJPanel panel = createTabPanel(new MigLayout(layC, colC, rowC));    // Makes the background gradient\n\n// References to text fields not stored to reduce code clutter.\n\npanel.add(new JLabel(\"Last Name\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"First Name\"));\npanel.add(new JTextField(),          new CC().wrap());\npanel.add(new JLabel(\"Phone\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"Email\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"Address 1\"));\npanel.add(new JTextField(),          new CC().spanX().growX());\npanel.add(new JLabel(\"Address 2\"));\npanel.add(new JTextField(),          new CC().spanX().growX());\npanel.add(new JLabel(\"City\"));\npanel.add(new JTextField(),          new CC().wrap());\npanel.add(new JLabel(\"State\"));\npanel.add(new JTextField());\npanel.add(new JLabel(\"Postal Code\"));\npanel.add(new JTextField(10),        new CC().spanX(2).growX(0));\npanel.add(new JLabel(\"Country\"));\npanel.add(new JTextField(),          new CC().wrap());\n\npanel.add(createButton(\"New\"),        new CC().spanX(5).split(5).tag(\"other\"));\npanel.add(createButton(\"Delete\"),     new CC().tag(\"other\"));\npanel.add(createButton(\"Edit\"),       new CC().tag(\"other\"));\npanel.add(createButton(\"Save\"),       new CC().tag(\"other\"));\npanel.add(createButton(\"Cancel\"),     new CC().tag(\"cancel\"));\n\ntabbedPane.addTab(\"Layout Showdown (improved)\", panel);");
        return tabbedPane;
    }

    public JComponent createLayout_Showdown() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel p = this.createTabPanel(new MigLayout("", "[]15[][grow,fill]15[grow]"));
        JScrollPane list1 = new JScrollPane(new JList<String>(new String[]{"Mouse, Mickey"}));
        p.add((Component)list1, "spany, growy, wmin 150");
        p.add(new JLabel("Last Name"));
        p.add(new JTextField());
        p.add((Component)new JLabel("First Name"), "split");
        p.add((Component)new JTextField(), "growx, wrap");
        p.add(new JLabel("Phone"));
        p.add(new JTextField());
        p.add((Component)new JLabel("Email"), "split");
        p.add((Component)new JTextField(), "growx, wrap");
        p.add(new JLabel("Address 1"));
        p.add((Component)new JTextField(), "span, growx");
        p.add(new JLabel("Address 2"));
        p.add((Component)new JTextField(), "span, growx");
        p.add(new JLabel("City"));
        p.add((Component)new JTextField(), "wrap");
        p.add(new JLabel("State"));
        p.add(new JTextField());
        p.add((Component)new JLabel("Postal Code"), "split");
        p.add((Component)new JTextField(), "growx, wrap");
        p.add(new JLabel("Country"));
        p.add((Component)new JTextField(), "wrap 15");
        p.add((Component)this.createButton("New"), "span, split, align left");
        p.add((Component)this.createButton("Delete"), "");
        p.add((Component)this.createButton("Edit"), "");
        p.add((Component)this.createButton("Save"), "");
        p.add((Component)this.createButton("Cancel"), "wrap push");
        tabbedPane.addTab("Layout Showdown (pure)", p);
        JPanel p2 = this.createTabPanel(new MigLayout("", "[]15[][grow,fill]15[][grow,fill]"));
        JScrollPane list2 = new JScrollPane(new JList<String>(new String[]{"Mouse, Mickey"}));
        p2.add((Component)list2, "spany, growy, wmin 150");
        p2.add(new JLabel("Last Name"));
        p2.add(new JTextField());
        p2.add(new JLabel("First Name"));
        p2.add((Component)new JTextField(), "wrap");
        p2.add(new JLabel("Phone"));
        p2.add(new JTextField());
        p2.add(new JLabel("Email"));
        p2.add((Component)new JTextField(), "wrap");
        p2.add(new JLabel("Address 1"));
        p2.add((Component)new JTextField(), "span");
        p2.add(new JLabel("Address 2"));
        p2.add((Component)new JTextField(), "span");
        p2.add(new JLabel("City"));
        p2.add((Component)new JTextField(), "wrap");
        p2.add(new JLabel("State"));
        p2.add(new JTextField());
        p2.add(new JLabel("Postal Code"));
        p2.add((Component)new JTextField(10), "growx 0, wrap");
        p2.add(new JLabel("Country"));
        p2.add((Component)new JTextField(), "wrap 15");
        p2.add((Component)this.createButton("New"), "tag other, span, split");
        p2.add((Component)this.createButton("Delete"), "tag other");
        p2.add((Component)this.createButton("Edit"), "tag other");
        p2.add((Component)this.createButton("Save"), "tag other");
        p2.add((Component)this.createButton("Cancel"), "tag cancel, wrap push");
        tabbedPane.addTab("Layout Showdown (improved)", p2);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nJPanel p = createTabPanel(new MigLayout(\"\", \"[]15[][grow,fill]15[grow]\"));\n\nJScrollPane list1 = new JScrollPane(new JList(new String[] {\"Mouse, Mickey\"}));\n\np.add(list1,                     \"spany, growy, wmin 150\");\np.add(new JLabel(\"Last Name\"));\np.add(new JTextField());\np.add(new JLabel(\"First Name\"),  \"split\");  // split divides the cell\np.add(new JTextField(),          \"growx, wrap\");\np.add(new JLabel(\"Phone\"));\np.add(new JTextField());\np.add(new JLabel(\"Email\"),       \"split\");\np.add(new JTextField(),          \"growx, wrap\");\np.add(new JLabel(\"Address 1\"));\np.add(new JTextField(),          \"span, growx\"); // span merges cells\np.add(new JLabel(\"Address 2\"));\np.add(new JTextField(),          \"span, growx\");\np.add(new JLabel(\"City\"));\np.add(new JTextField(),          \"wrap\"); // wrap continues on next line\np.add(new JLabel(\"State\"));\np.add(new JTextField());\np.add(new JLabel(\"Postal Code\"), \"split\");\np.add(new JTextField(),          \"growx, wrap\");\np.add(new JLabel(\"Country\"));\np.add(new JTextField(),          \"wrap 15\");\n\np.add(createButton(\"New\"),        \"span, split, align left\");\np.add(createButton(\"Delete\"),     \"\");\np.add(createButton(\"Edit\"),       \"\");\np.add(createButton(\"Save\"),       \"\");\np.add(createButton(\"Cancel\"),     \"wrap push\");\n\ntabbedPane.addTab(\"Layout Showdown (pure)\", p);\n\t\t// Fixed version *******************************************\nJPanel p2 = createTabPanel(new MigLayout(\"\", \"[]15[][grow,fill]15[][grow,fill]\"));    // Makes the background gradient\n\n// References to text fields not stored to reduce code clutter.\n\nJScrollPane list2 = new JScrollPane(new JList(new String[] {\"Mouse, Mickey\"}));\np2.add(list2,                     \"spany, growy, wmin 150\");\np2.add(new JLabel(\"Last Name\"));\np2.add(new JTextField());\np2.add(new JLabel(\"First Name\"));\np2.add(new JTextField(),          \"wrap\");\np2.add(new JLabel(\"Phone\"));\np2.add(new JTextField());\np2.add(new JLabel(\"Email\"));\np2.add(new JTextField(),          \"wrap\");\np2.add(new JLabel(\"Address 1\"));\np2.add(new JTextField(),          \"span\");\np2.add(new JLabel(\"Address 2\"));\np2.add(new JTextField(),          \"span\");\np2.add(new JLabel(\"City\"));\np2.add(new JTextField(),          \"wrap\");\np2.add(new JLabel(\"State\"));\np2.add(new JTextField());\np2.add(new JLabel(\"Postal Code\"));\np2.add(new JTextField(10),        \"growx 0, wrap\");\np2.add(new JLabel(\"Country\"));\np2.add(new JTextField(),          \"wrap 15\");\n\np2.add(createButton(\"New\"),        \"tag other, span, split\");\np2.add(createButton(\"Delete\"),     \"tag other\");\np2.add(createButton(\"Edit\"),       \"tag other\");\np2.add(createButton(\"Save\"),       \"tag other\");\np2.add(createButton(\"Cancel\"),     \"tag cancel, wrap push\");\n\ntabbedPane.addTab(\"Layout Showdown (improved)\", p2);");
        return tabbedPane;
    }

    public JComponent createWelcome() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout lm = new MigLayout("ins 20, fill", "", "[grow]unrel[]");
        JPanel mainPanel = this.createTabPanel(lm);
        String s = "MigLayout's main purpose is to make layouts for SWT and Swing, and possibly other frameworks, much more powerful and a lot easier to create, especially for manual coding.\n\nThe motto is: \"MigLayout makes complex layouts easy and normal layouts one-liners.\"\n\nThe layout engine is very flexible and advanced, something that is needed to make it simple to use yet handle almost all layout use-cases.\n\nMigLayout can handle all layouts that the commonly used Swing Layout Managers can handle and this with a lot of extra features. It also incorporates most, if not all, of the open source alternatives FormLayout's and TableLayout's functionality.\n\n\nThanks to Karsten Lentzsch of JGoodies.com for allowing the reuse of the main demo application layout and for his inspiring talks that led to this layout Manager.\n\n\nMikael Grev\nMiG InfoCom AB\nmiglayout@miginfocom.com";
        JTextArea textArea = new JTextArea(s);
        textArea.setEditable(false);
        textArea.setSize(400, 400);
        if (PlatformDefaults.getCurrentPlatform() == 0) {
            textArea.setFont(new Font("tahoma", 1, 11));
        }
        textArea.setOpaque(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        JLabel label = new JLabel("You can Right Click any Component or Container to change the constraints for it!");
        label.setForeground(new Color(200, 0, 0));
        mainPanel.add((Component)textArea, "w 500:pref,ay top,grow,wrap");
        mainPanel.add((Component)label, "growx");
        label.setFont(label.getFont().deriveFont(1));
        tabbedPane.addTab("Welcome", mainPanel);
        this.setSource("");
        return tabbedPane;
    }

    public JComponent createVisual_Bounds() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel p1 = this.createTabPanel(new MigLayout("fill, ins 3, novisualpadding"));
        p1.setBorder(new LineBorder(Color.BLACK));
        JTabbedPane demoPane2 = new JTabbedPane();
        JPanel demoPanel2 = new JPanel();
        demoPanel2.setBackground(Color.WHITE);
        demoPane2.addTab("Demo Tab", demoPanel2);
        p1.add((Component)this.createTextArea("A JTextArea", 1, 100), "grow, aligny bottom, wmin 100");
        p1.add((Component)demoPane2, "grow, aligny bottom");
        p1.add((Component)this.createTextField("A JTextField", 100), "grow, aligny bottom, wmin 100");
        p1.add((Component)this.createTextArea("A JTextArea", 1, 100), "newline,grow, aligny bottom, wmin 100");
        p1.add((Component)this.createTextArea("A JTextArea", 1, 100), "grow, aligny bottom, wmin 100");
        p1.add((Component)this.createTextArea("A JTextArea", 1, 100), "grow, aligny bottom, wmin 100");
        JPanel p2 = this.createTabPanel(new MigLayout("center,center,fill,ins 3"));
        p2.setBorder(new LineBorder(Color.BLACK));
        JTabbedPane demoPane = new JTabbedPane();
        JPanel demoPanel = new JPanel();
        demoPanel.setBackground(Color.WHITE);
        demoPane.addTab("Demo Tab", demoPanel);
        p2.add((Component)this.createTextArea("A JTextArea", 1, 100), "grow, aligny bottom, wmin 100");
        p2.add((Component)demoPane, "grow, aligny bottom");
        p2.add((Component)this.createTextField("A JTextField", 100), "grow, aligny bottom, wmin 100");
        p2.add((Component)this.createTextArea("A JTextArea", 1, 100), "newline,grow, aligny bottom, wmin 100");
        p2.add((Component)this.createTextArea("A JTextArea", 1, 100), "grow, aligny bottom, wmin 100");
        p2.add((Component)this.createTextArea("A JTextArea", 1, 100), "grow, aligny bottom, wmin 100");
        tabbedPane.addTab("Visual Bounds (Not Corrected)", p1);
        tabbedPane.addTab("Visual Bounds (Corrected on XP)", p2);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// \"NON\"-corrected bounds\nJPanel p1 = createTabPanel(new MigLayout(\"fill, ins 3, novisualpadding\"));\np1.setBorder(new LineBorder(Color.BLACK));\n\nJTabbedPane demoPane2 = new JTabbedPane();\nJPanel demoPanel2 = new JPanel();\ndemoPanel2.setBackground(Color.WHITE);\ndemoPane2.addTab(\"Demo Tab\", demoPanel2);\n\np1.add(createTextArea(\"A JTextArea\", 1, 100), \"grow, aligny bottom, wmin 100\");\np1.add(demoPane2, \"grow, aligny bottom\");\np1.add(createTextField(\"A JTextField\", 100), \"grow, aligny bottom, wmin 100\");\np1.add(createTextArea(\"A JTextArea\", 1, 100), \"newline,grow, aligny bottom, wmin 100\");\np1.add(createTextArea(\"A JTextArea\", 1, 100), \"grow, aligny bottom, wmin 100\");\np1.add(createTextArea(\"A JTextArea\", 1, 100), \"grow, aligny bottom, wmin 100\");\n\nJPanel p2 = createTabPanel(new MigLayout(\"center,center,fill,ins 3\"));\np2.setBorder(new LineBorder(Color.BLACK));\n\nJTabbedPane demoPane = new JTabbedPane();\nJPanel demoPanel = new JPanel();\ndemoPanel.setBackground(Color.WHITE);\ndemoPane.addTab(\"Demo Tab\", demoPanel);\n\np2.add(createTextArea(\"A JTextArea\", 1, 100), \"grow, aligny bottom, wmin 100\");\np2.add(demoPane, \"grow, aligny bottom\");\np2.add(createTextField(\"A JTextField\", 100), \"grow, aligny bottom, wmin 100\");\np2.add(createTextArea(\"A JTextArea\", 1, 100), \"newline,grow, aligny bottom, wmin 100\");\np2.add(createTextArea(\"A JTextArea\", 1, 100), \"grow, aligny bottom, wmin 100\");\np2.add(createTextArea(\"A JTextArea\", 1, 100), \"grow, aligny bottom, wmin 100\");\n\ntabbedPane.addTab(\"Visual Bounds (Not Corrected)\", p1);\ntabbedPane.addTab(\"Visual Bounds (Corrected on XP)\", p2);");
        return tabbedPane;
    }

    public JComponent createDocking() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel p1 = this.createTabPanel(new MigLayout("fill"));
        p1.add((Component)this.createPanel("1. North"), "north");
        p1.add((Component)this.createPanel("2. West"), "west");
        p1.add((Component)this.createPanel("3. East"), "east");
        p1.add((Component)this.createPanel("4. South"), "south");
        Object[][] data = new String[20][6];
        for (int r = 0; r < data.length; ++r) {
            data[r] = new String[6];
            for (int c = 0; c < data[r].length; ++c) {
                data[r][c] = "Cell " + (r + 1) + ", " + (c + 1);
            }
        }
        JTable table = new JTable(data, new String[]{"Column 1", "Column 2", "Column 3", "Column 4", "Column 5", "Column 6"});
        p1.add((Component)new JScrollPane(table), "grow");
        JPanel p2 = this.createTabPanel(new MigLayout("fill", "[c]", ""));
        p2.add((Component)this.createPanel("1. North"), "north");
        p2.add((Component)this.createPanel("2. North"), "north");
        p2.add((Component)this.createPanel("3. West"), "west");
        p2.add((Component)this.createPanel("4. West"), "west");
        p2.add((Component)this.createPanel("5. South"), "south");
        p2.add((Component)this.createPanel("6. East"), "east");
        p2.add(this.createButton("7. Normal"));
        p2.add(this.createButton("8. Normal"));
        p2.add(this.createButton("9. Normal"));
        JPanel p3 = this.createTabPanel(new MigLayout());
        p3.add((Component)this.createPanel("1. North"), "north");
        p3.add((Component)this.createPanel("2. South"), "south");
        p3.add((Component)this.createPanel("3. West"), "west");
        p3.add((Component)this.createPanel("4. East"), "east");
        p3.add(this.createButton("5. Normal"));
        JPanel p4 = this.createTabPanel(new MigLayout());
        p4.add((Component)this.createPanel("1. North"), "north");
        p4.add((Component)this.createPanel("2. North"), "north");
        p4.add((Component)this.createPanel("3. West"), "west");
        p4.add((Component)this.createPanel("4. West"), "west");
        p4.add((Component)this.createPanel("5. South"), "south");
        p4.add((Component)this.createPanel("6. East"), "east");
        p4.add(this.createButton("7. Normal"));
        p4.add(this.createButton("8. Normal"));
        p4.add(this.createButton("9. Normal"));
        JPanel p5 = this.createTabPanel(new MigLayout("fillx", "[c]", ""));
        p5.add((Component)this.createPanel("1. North"), "north");
        p5.add((Component)this.createPanel("2. North"), "north");
        p5.add((Component)this.createPanel("3. West"), "west");
        p5.add((Component)this.createPanel("4. West"), "west");
        p5.add((Component)this.createPanel("5. South"), "south");
        p5.add((Component)this.createPanel("6. East"), "east");
        p5.add(this.createButton("7. Normal"));
        p5.add(this.createButton("8. Normal"));
        p5.add(this.createButton("9. Normal"));
        JPanel p6 = this.createTabPanel(new MigLayout("fill", "", ""));
        Random rand = new Random();
        String[] sides = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < 20; ++i) {
            int side = rand.nextInt(4);
            p6.add((Component)this.createPanel(i + 1 + " " + sides[side]), sides[side]);
        }
        p6.add((Component)this.createPanel("I'm in the Center!"), "dock center");
        tabbedPane.addTab("Docking 1 (fill)", p1);
        tabbedPane.addTab("Docking 2 (fill)", p2);
        tabbedPane.addTab("Docking 3", p3);
        tabbedPane.addTab("Docking 4", p4);
        tabbedPane.addTab("Docking 5 (fillx)", p5);
        tabbedPane.addTab("Random Docking", new JScrollPane(p6));
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nJPanel p1 = createTabPanel(new MigLayout(\"fill\"));\n\np1.add(createPanel(\"1. North\"), \"north\");\np1.add(createPanel(\"2. West\"), \"west\");\np1.add(createPanel(\"3. East\"), \"east\");\np1.add(createPanel(\"4. South\"), \"south\");\n\nString[][] data = new String[20][6];\nfor (int r = 0; r < data.length; r++) {\n\tdata[r] = new String[6];\n\tfor (int c = 0; c < data[r].length; c++)\n\t\tdata[r][c] = \"Cell \" + (r + 1) + \", \" + (c + 1);\n}\nJTable table = new JTable(data, new String[] {\"Column 1\", \"Column 2\", \"Column 3\", \"Column 4\", \"Column 5\", \"Column 6\"});\np1.add(new JScrollPane(table), \"grow\");\n\nJPanel p2 = createTabPanel(new MigLayout(\"fill\", \"[c]\", \"\"));\n\np2.add(createPanel(\"1. North\"), \"north\");\np2.add(createPanel(\"2. North\"), \"north\");\np2.add(createPanel(\"3. West\"), \"west\");\np2.add(createPanel(\"4. West\"), \"west\");\np2.add(createPanel(\"5. South\"), \"south\");\np2.add(createPanel(\"6. East\"), \"east\");\np2.add(createButton(\"7. Normal\"));\np2.add(createButton(\"8. Normal\"));\np2.add(createButton(\"9. Normal\"));\n\nJPanel p3 = createTabPanel(new MigLayout());\n\np3.add(createPanel(\"1. North\"), \"north\");\np3.add(createPanel(\"2. South\"), \"south\");\np3.add(createPanel(\"3. West\"), \"west\");\np3.add(createPanel(\"4. East\"), \"east\");\np3.add(createButton(\"5. Normal\"));\n\nJPanel p4 = createTabPanel(new MigLayout());\n\np4.add(createPanel(\"1. North\"), \"north\");\np4.add(createPanel(\"2. North\"), \"north\");\np4.add(createPanel(\"3. West\"), \"west\");\np4.add(createPanel(\"4. West\"), \"west\");\np4.add(createPanel(\"5. South\"), \"south\");\np4.add(createPanel(\"6. East\"), \"east\");\np4.add(createButton(\"7. Normal\"));\np4.add(createButton(\"8. Normal\"));\np4.add(createButton(\"9. Normal\"));\n\nJPanel p5 = createTabPanel(new MigLayout(\"fillx\", \"[c]\", \"\"));\n\np5.add(createPanel(\"1. North\"), \"north\");\np5.add(createPanel(\"2. North\"), \"north\");\np5.add(createPanel(\"3. West\"), \"west\");\np5.add(createPanel(\"4. West\"), \"west\");\np5.add(createPanel(\"5. South\"), \"south\");\np5.add(createPanel(\"6. East\"), \"east\");\np5.add(createButton(\"7. Normal\"));\np5.add(createButton(\"8. Normal\"));\np5.add(createButton(\"9. Normal\"));\n\nJPanel p6 = createTabPanel(new MigLayout(\"fill\", \"\", \"\"));\n\nRandom rand = new Random();\nString[] sides = {\"north\", \"east\", \"south\", \"west\"};\nfor (int i = 0; i < 20; i++) {\n\tint side = rand.nextInt(4);\n\tp6.add(createPanel((i + 1) + \" \" + sides[side]), sides[side]);\n}\np6.add(createButton(\"I'm in the middle!\"), \"grow\");\n\ntabbedPane.addTab(\"Docking 1 (fill)\", p1);\ntabbedPane.addTab(\"Docking 2 (fill)\", p2);\ntabbedPane.addTab(\"Docking 3\", p3);\ntabbedPane.addTab(\"Docking 4\", p4);\ntabbedPane.addTab(\"Docking 5 (fillx)\", p5);\ntabbedPane.addTab(\"Docking Spiral\", new JScrollPane(p6));");
        return tabbedPane;
    }

    public JComponent createAbsolute_Position() {
        JTabbedPane tabbedPane = new JTabbedPane();
        final JPanel posPanel = this.createTabPanel(new MigLayout());
        posPanel.add((Component)this.createButton(), "pos 0.5al 0al");
        posPanel.add((Component)this.createButton(), "pos 1al 0al");
        posPanel.add((Component)this.createButton(), "pos 0.5al 0.5al");
        posPanel.add((Component)this.createButton(), "pos 5in 45lp");
        posPanel.add((Component)this.createButton(), "pos 0.5al 0.5al");
        posPanel.add((Component)this.createButton(), "pos 0.5al 1.0al");
        posPanel.add((Component)this.createButton(), "pos 1al .25al");
        posPanel.add((Component)this.createButton(), "pos visual.x2-pref visual.y2-pref");
        posPanel.add((Component)this.createButton(), "pos 1al -1in");
        posPanel.add((Component)this.createButton(), "pos 100 100");
        posPanel.add((Component)this.createButton(), "pos (10+(20*3lp)) 200");
        posPanel.add((Component)this.createButton("Drag Window! (pos 500-container.xpos 500-container.ypos)"), "pos 500-container.xpos 500-container.ypos");
        JPanel boundsPanel = this.createTabPanel(new MigLayout());
        String constr = "pos (visual.x+visual.w*0.1) visual.y2-40 (visual.x2-visual.w*0.1) visual.y2";
        JLabel southLabel = this.createLabel(constr, 0);
        southLabel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        southLabel.setBackground(new Color(200, 200, 255, benchRuns == 0 ? 70 : 255));
        southLabel.setOpaque(true);
        southLabel.setFont(southLabel.getFont().deriveFont(1));
        boundsPanel.add((Component)southLabel, constr);
        boundsPanel.add((Component)this.createButton(), "pos 0 0 container.x2 n");
        boundsPanel.add((Component)this.createButton(), "pos visual.x 40 visual.x2 70");
        boundsPanel.add((Component)this.createButton(), "pos visual.x 100 visual.x2 p");
        boundsPanel.add((Component)this.createButton(), "pos 0.1al 0.4al n (visual.y2 - 10)");
        boundsPanel.add((Component)this.createButton(), "pos 0.9al 0.4al n visual.y2-10");
        boundsPanel.add((Component)this.createButton(), "pos 0.5al 0.5al, pad 3 0 -3 0");
        boundsPanel.add((Component)this.createButton(), "pos n n 50% 50%");
        boundsPanel.add((Component)this.createButton(), "pos 50% 50% n n");
        boundsPanel.add((Component)this.createButton(), "pos 50% n n 50%");
        boundsPanel.add((Component)this.createButton(), "pos n 50% 50% n");
        tabbedPane.addTab("X Y Positions", posPanel);
        tabbedPane.addTab("X1 Y1 X2 Y2 Bounds", boundsPanel);
        if (benchRuns == 0) {
            final JPanel glassPanel = this.createTabPanel(new MigLayout("align c c, ins 0"));
            final JButton butt = this.createButton("Press me!!");
            glassPanel.add(butt);
            butt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    butt.setEnabled(false);
                    final JPanel bg = new JPanel(new MigLayout("align c c,fill")){

                        public void paint(Graphics g) {
                            g.setColor(this.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paint(g);
                        }
                    };
                    bg.setOpaque(false);
                    SwingDemo.this.configureActiveComponet(bg);
                    final JLabel label = SwingDemo.this.createLabel("You don't need a GlassPane to be cool!");
                    label.setFont(label.getFont().deriveFont(30.0f));
                    label.setForeground(new Color(255, 255, 255, 0));
                    bg.add((Component)label, "align 50% 30%");
                    glassPanel.add(bg, "pos visual.x visual.y visual.x2 visual.y2", 0);
                    final long startTime = System.nanoTime();
                    final long endTime = startTime + 500000000L;
                    glassPanel.revalidate();
                    final Timer timer = new Timer(25, null);
                    timer.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            long now = System.nanoTime();
                            int alpha = (int)((double)(now - startTime) / (double)(endTime - startTime) * 300.0);
                            if (alpha < 150) {
                                bg.setBackground(new Color(100, 100, 100, alpha));
                            }
                            if (alpha > 150 && alpha < 405) {
                                label.setForeground(new Color(255, 255, 255, alpha - 150));
                                bg.repaint();
                            }
                            if (alpha > 405) {
                                timer.stop();
                            }
                        }
                    });
                    timer.start();
                }
            });
            tabbedPane.addTab("GlassPane Substitute", glassPanel);
            this.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent e) {
                    if (posPanel.isDisplayable()) {
                        posPanel.revalidate();
                    } else {
                        SwingDemo.this.removeComponentListener(this);
                    }
                }
            });
        }
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// Pos tab\nfinal JPanel posPanel = createTabPanel(new MigLayout());\n\nposPanel.add(createButton(), \"pos 0.5al 0al\");\nposPanel.add(createButton(), \"pos 1al 0al\");\nposPanel.add(createButton(), \"pos 0.5al 0.5al\");\nposPanel.add(createButton(), \"pos 5in 45lp\");\nposPanel.add(createButton(), \"pos 0.5al 0.5al\");\nposPanel.add(createButton(), \"pos 0.5al 1.0al\");\nposPanel.add(createButton(), \"pos 1al .25al\");\nposPanel.add(createButton(), \"pos visual.x2-pref visual.y2-pref\");\nposPanel.add(createButton(), \"pos 1al -1in\");\nposPanel.add(createButton(), \"pos 100 100\");\nposPanel.add(createButton(), \"pos (10+(20*3lp)) 200\");\nposPanel.add(createButton(\"Drag Window! (pos 500-container.xpos 500-container.ypos)\"),\n                            \"pos 500-container.xpos 500-container.ypos\");\n\n// Bounds tab\nJPanel boundsPanel = createTabPanel(new MigLayout());\n\nString constr = \"pos (visual.x+visual.w*0.1) visual.y2-40 (visual.x2-visual.w*0.1) visual.y2\";\nJLabel southLabel = createLabel(constr, SwingConstants.CENTER);\nsouthLabel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));\nsouthLabel.setBackground(new Color(200, 200, 255, 70));\nsouthLabel.setOpaque(true);\nsouthLabel.setFont(southLabel.getFont().deriveFont(Font.BOLD));\nboundsPanel.add(southLabel, constr);\n\nboundsPanel.add(createButton(), \"pos 0 0 container.x2 n\");\nboundsPanel.add(createButton(), \"pos visual.x 40 visual.x2 70\");\nboundsPanel.add(createButton(), \"pos visual.x 100 visual.x2 p\");\nboundsPanel.add(createButton(), \"pos 0.1al 0.4al n visual.y2-10\");\nboundsPanel.add(createButton(), \"pos 0.9al 0.4al n visual.y2-10\");\nboundsPanel.add(createButton(), \"pos 0.5al 0.5al, pad 3 0 -3 0\");\nboundsPanel.add(createButton(), \"pos n n 50% 50%\");\nboundsPanel.add(createButton(), \"pos 50% 50% n n\");\nboundsPanel.add(createButton(), \"pos 50% n n 50%\");\nboundsPanel.add(createButton(), \"pos n 50% 50% n\");\n\n// Glass pane tab\nfinal JPanel glassPanel = createTabPanel(new MigLayout(\"align c c, ins 0\"));\nfinal JButton butt = createButton(\"Press me!!\");\nglassPanel.add(butt);\n\nbutt.addActionListener(new ActionListener()\t\t{\n\tpublic void actionPerformed(ActionEvent e)\n\t{\n\t\tbutt.setEnabled(false);\n\t\tfinal JPanel bg = new JPanel(new MigLayout(\"align c c,fill\")) {\n\t\t\tpublic void paint(Graphics g)\n\t\t\t{\n\t\t\t\tg.setColor(getBackground());\n\t\t\t\tg.fillRect(0, 0, getWidth(), getHeight());\n\t\t\t\tsuper.paint(g);\n\t\t\t}\n\t\t};\n\t\tbg.setOpaque(OPAQUE);\n\t\tconfigureActiveComponet(bg);\n\n\t\tfinal JLabel label = createLabel(\"You don't need a GlassPane to be cool!\");\n\t\tlabel.setFont(label.getFont().deriveFont(30f));\n\t\tlabel.setForeground(new Color(255, 255, 255, 0));\n\t\tbg.add(label, \"align 50% 30%\");\n\n\t\tglassPanel.add(bg, \"pos visual.x visual.y visual.x2 visual.y2\", 0);\n\t\tfinal long startTime = System.nanoTime();\n\t\tfinal long endTime = startTime + 500000000L;\n\n\t\tglassPanel.revalidate();\n\n\t\tfinal javax.swing.Timer timer = new Timer(25, null);\n\n\t\ttimer.addActionListener(new ActionListener() {\n\t\t\tpublic void actionPerformed(ActionEvent e)\n\t\t\t{\n\t\t\t\tlong now = System.nanoTime();\n\t\t\t\tint alpha = (int) (((now - startTime) / (double) (endTime - startTime)) * 300);\n\t\t\t\tif (alpha < 150)\n\t\t\t\t\tbg.setBackground(new Color(100, 100, 100, alpha));\n\n\t\t\t\tif (alpha > 150 && alpha < 405) {\n\t\t\t\t\tlabel.setForeground(new Color(255, 255, 255, (alpha - 150)));\n\t\t\t\t\tbg.repaint();\n\t\t\t\t}\n\t\t\t\tif (alpha > 405)\n\t\t\t\t\ttimer.stop();\n\t\t\t}\n\t\t});\n\t\ttimer.start();\n\t}\n});\n\ntabbedPane.addTab(\"X Y Positions\", posPanel);\ntabbedPane.addTab(\"X1 Y1 X2 Y2 Bounds\", boundsPanel);\ntabbedPane.addTab(\"GlassPane Substitute\", glassPanel);\n\naddComponentListener(new ComponentAdapter() {\n\tpublic void componentMoved(ComponentEvent e) {\n\t\tif (posPanel.isDisplayable()) {\n\t\t\tposPanel.revalidate();\n\t\t} else {\n\t\t\tremoveComponentListener(this);\n\t\t}\n\t}\n});");
        return tabbedPane;
    }

    public JComponent createComponent_Links() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel linksPanel = this.createTabPanel(new MigLayout());
        JButton mini = this.createButton("Mini");
        mini.setMargin(new Insets(0, 1, 0, 1));
        linksPanel.add((Component)mini, "pos null ta.y ta.x2 null");
        linksPanel.add((Component)this.createTextArea("Components, Please Link to Me!\nMy ID is: 'ta'", 3, 30), "id ta, pos 0.5al 0.5al");
        linksPanel.add((Component)this.createButton(), "id b1,pos ta.x2 ta.y2");
        linksPanel.add((Component)this.createButton(), "pos b1.x2+rel b1.y visual.x2 null");
        linksPanel.add((Component)this.createButton(), "pos ta.x2+rel ta.y visual.x2 null");
        linksPanel.add((Component)this.createButton(), "pos null ta.y+(ta.h-pref)/2 ta.x-rel null");
        linksPanel.add((Component)this.createButton(), "pos ta.x ta.y2+100 ta.x2 null");
        linksPanel.add((Component)this.createCheck("pos (ta.x+indent) (ta.y2+rel)"), "pos (ta.x+indent) (ta.y2+rel)");
        JPanel externalPanel = this.createTabPanel(new MigLayout());
        JButton extButt = this.createButton("Bounds Externally Set!");
        extButt.setBounds(250, 130, 200, 40);
        externalPanel.add((Component)extButt, "id ext, external");
        externalPanel.add((Component)this.createButton(), "pos ext.x2 ext.y2");
        externalPanel.add((Component)this.createButton(), "pos null null ext.x ext.y");
        JPanel egPanel = this.createTabPanel(new MigLayout());
        egPanel.add((Component)this.createButton(), "id b1, endgroupx g1, pos 200 200");
        egPanel.add((Component)this.createButton(), "id b2, endgroupx g1, pos (b1.x+2ind) (b1.y2+rel)");
        egPanel.add((Component)this.createButton(), "id b3, endgroupx g1, pos (b1.x+4ind) (b2.y2+rel)");
        egPanel.add((Component)this.createButton(), "id b4, endgroupx g1, pos (b1.x+6ind) (b3.y2+rel)");
        JPanel gpPanel = this.createTabPanel(new MigLayout());
        gpPanel.add((Component)this.createButton(), "id grp1.b1, pos n 0.5al 50% n");
        gpPanel.add((Component)this.createButton(), "id grp1.b2, pos 50% 0.5al n n");
        gpPanel.add((Component)this.createButton(), "id grp1.b3, pos 0.5al n n b1.y");
        gpPanel.add((Component)this.createButton(), "id grp1.b4, pos 0.5al b1.y2 n n");
        gpPanel.add((Component)this.createButton(), "pos n grp1.y2 grp1.x n");
        gpPanel.add((Component)this.createButton(), "pos n n grp1.x grp1.y");
        gpPanel.add((Component)this.createButton(), "pos grp1.x2 n n grp1.y");
        gpPanel.add((Component)this.createButton(), "pos grp1.x2 grp1.y2");
        JPanel boundsPanel = new JPanel(null);
        boundsPanel.setBackground(new Color(200, 200, 255));
        gpPanel.add((Component)boundsPanel, "pos grp1.x grp1.y grp1.x2 grp1.y2");
        tabbedPane.addTab("Component Links", linksPanel);
        tabbedPane.addTab("External Components", externalPanel);
        tabbedPane.addTab("End Grouping", egPanel);
        tabbedPane.addTab("Group Bounds", gpPanel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nJPanel linksPanel = createTabPanel(new MigLayout());\n\n// Links tab\nJButton mini = createButton(\"Mini\");\nmini.setMargin(new Insets(0, 1, 0, 1));\nlinksPanel.add(mini, \"pos null ta.y ta.x2 null\");\nlinksPanel.add(createTextArea(\"Components, Please Link to Me!\\nMy ID is: 'ta'\", 3, 30), \"id ta, pos 0.5al 0.5al\");\nlinksPanel.add(createButton(), \"id b1,pos ta.x2 ta.y2\");\nlinksPanel.add(createButton(), \"pos b1.x2+rel b1.y visual.x2 null\");\nlinksPanel.add(createButton(), \"pos ta.x2+rel ta.y visual.x2 null\");\nlinksPanel.add(createButton(), \"pos null ta.y+(ta.h-pref)/2 ta.x-rel null\");\nlinksPanel.add(createButton(), \"pos ta.x ta.y2+100 ta.x2 null\");\nlinksPanel.add(createCheck(\"pos (ta.x+indent) (ta.y2+rel)\"),\n                           \"pos (ta.x+indent) (ta.y2+rel)\");\n\n// External tab\nJPanel externalPanel = createTabPanel(new MigLayout());\n\nJButton extButt = createButton(\"Bounds Externally Set!\");\nextButt.setBounds(250, 130, 200, 40);\nexternalPanel.add(extButt, \"id ext, external\");\nexternalPanel.add(createButton(), \"pos ext.x2 ext.y2\");\nexternalPanel.add(createButton(), \"pos null null ext.x ext.y\");\n\n// Start/End Group tab\nJPanel egPanel = createTabPanel(new MigLayout());\n\negPanel.add(createButton(), \"id b1, endgroupx g1, pos 200 200\");\negPanel.add(createButton(), \"id b2, endgroupx g1, pos (b1.x+2ind) (b1.y2+rel)\");\negPanel.add(createButton(), \"id b3, endgroupx g1, pos (b1.x+4ind) (b2.y2+rel)\");\negPanel.add(createButton(), \"id b4, endgroupx g1, pos (b1.x+6ind) (b3.y2+rel)\");\n\n// Group Bounds tab\nJPanel gpPanel = createTabPanel(new MigLayout());\n\ngpPanel.add(createButton(), \"id grp1.b1, pos n 0.5al 50% n\");\ngpPanel.add(createButton(), \"id grp1.b2, pos 50% 0.5al n n\");\ngpPanel.add(createButton(), \"id grp1.b3, pos 0.5al n n b1.y\");\ngpPanel.add(createButton(), \"id grp1.b4, pos 0.5al b1.y2 n n\");\n\ngpPanel.add(createButton(), \"pos n grp1.y2 grp1.x n\");\ngpPanel.add(createButton(), \"pos n n grp1.x grp1.y\");\ngpPanel.add(createButton(), \"pos grp1.x2 n n grp1.y\");\ngpPanel.add(createButton(), \"pos grp1.x2 grp1.y2\");\n\nJPanel boundsPanel = new JPanel(null);\nboundsPanel.setBackground(new Color(200, 200, 255));\ngpPanel.add(boundsPanel, \"pos grp1.x grp1.y grp1.x2 grp1.y2\");\n\n\ntabbedPane.addTab(\"Component Links\", linksPanel);\ntabbedPane.addTab(\"External Components\", externalPanel);\ntabbedPane.addTab(\"End Grouping\", egPanel);\ntabbedPane.addTab(\"Group Bounds\", gpPanel);");
        return tabbedPane;
    }

    public JComponent createFlow_Direction() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Layout: flowx, Cell: flowx", this.createFlowPanel("", "flowx"));
        tabbedPane.addTab("Layout: flowx, Cell: flowy", this.createFlowPanel("", "flowy"));
        tabbedPane.addTab("Layout: flowy, Cell: flowx", this.createFlowPanel("flowy", "flowx"));
        tabbedPane.addTab("Layout: flowy, Cell: flowy", this.createFlowPanel("flowy", "flowy"));
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\ntabbedPane.addTab(\"Layout: flowx, Cell: flowx\", createFlowPanel(\"\", \"flowx\"));\ntabbedPane.addTab(\"Layout: flowx, Cell: flowy\", createFlowPanel(\"\", \"flowy\"));\ntabbedPane.addTab(\"Layout: flowy, Cell: flowx\", createFlowPanel(\"flowy\", \"flowx\"));\ntabbedPane.addTab(\"Layout: flowy, Cell: flowy\", createFlowPanel(\"flowy\", \"flowy\"));\n\tpublic JPanel createFlowPanel(String gridFlow, String cellFlow)\n\t{\nMigLayout lm = new MigLayout(\"center, wrap 3,\" + gridFlow,\n                             \"[110,fill]\",\n                             \"[110,fill]\");\nJPanel panel = createTabPanel(lm);\n\nfor (int i = 0; i < 9; i++) {\n\tJButton b = createButton(\"\" + (i + 1));\n\tb.setFont(b.getFont().deriveFont(20f));\n\tpanel.add(b, cellFlow);\n}\n\nJButton b = createButton(\"5:2\");\nb.setFont(b.getFont().deriveFont(20f));\npanel.add(b, cellFlow + \",cell 1 1\");\n\nreturn panel;\n\t}");
        return tabbedPane;
    }

    public JPanel createFlowPanel(String gridFlow, String cellFlow) {
        MigLayout lm = new MigLayout("center, wrap 3," + gridFlow, "[110,fill]", "[110,fill]");
        JPanel panel = this.createTabPanel(lm);
        Font f = panel.getFont().deriveFont(20.0f);
        for (int i = 0; i < 9; ++i) {
            JComponent b = this.createPanel("" + (i + 1));
            b.setFont(f);
            panel.add((Component)b, cellFlow);
        }
        JComponent b = this.createPanel("5:2");
        b.setFont(f);
        panel.add((Component)b, cellFlow + ",cell 1 1");
        return panel;
    }

    public JComponent createDebug() {
        return this.createPlainImpl(true);
    }

    public JComponent createButton_Bars() {
        MigLayout lm = new MigLayout("ins 0 0 15lp 0", "[grow]", "[grow][baseline,nogrid]");
        final JPanel mainPanel = new JPanel(lm);
        final JLabel formatLabel = this.createLabel("");
        formatLabel.setFont(formatLabel.getFont().deriveFont(1));
        JTabbedPane tabbedPane = new JTabbedPane();
        JToggleButton winButt = this.createToggleButton("Windows");
        JToggleButton macButt = this.createToggleButton("Mac OS X");
        JButton helpButt = this.createButton("Help");
        if (benchRuns == 0) {
            winButt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlatformDefaults.setPlatform(0);
                    formatLabel.setText("'" + PlatformDefaults.getButtonOrder() + "'");
                    ((JPanel)((JFrame)Frame.getFrames()[0]).getContentPane()).revalidate();
                }
            });
            macButt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlatformDefaults.setPlatform(1);
                    formatLabel.setText(PlatformDefaults.getButtonOrder());
                    ((JPanel)((JFrame)Frame.getFrames()[0]).getContentPane()).revalidate();
                }
            });
            helpButt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(mainPanel, "See JavaDoc for PlatformConverter.getButtonBarOrder(..) for details on the format string.");
                }
            });
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(winButt);
        bg.add(macButt);
        if (benchRuns == 0) {
            if (PlatformDefaults.getCurrentPlatform() == 1) {
                macButt.doClick();
            } else {
                winButt.doClick();
            }
        }
        tabbedPane.addTab("Buttons", this.createButtonBarsPanel("help", false));
        tabbedPane.addTab("Buttons with Help2", this.createButtonBarsPanel("help2", false));
        tabbedPane.addTab("Buttons (Same width)", this.createButtonBarsPanel("help", true));
        mainPanel.add((Component)tabbedPane, "grow,wrap");
        mainPanel.add(this.createLabel("Button Order:"));
        mainPanel.add((Component)formatLabel, "growx");
        mainPanel.add(winButt);
        mainPanel.add(macButt);
        mainPanel.add((Component)helpButt, "gapbefore unrel");
        this.setSource("MigLayout lm = new MigLayout(\"ins 0 0 15lp 0\",\n                                  \"[grow]\",\n                                  \"[grow][baseline,nogrid,gap unrelated]\");\n\nfinal JPanel mainPanel = new JPanel(lm);\nfinal JLabel formatLabel = createLabel(\"\");\nformatLabel.setFont(formatLabel.getFont().deriveFont(Font.BOLD));\nJTabbedPane tabbedPane = new JTabbedPane();\n\nJToggleButton winButt = createToggleButton(\"Windows\");\n\nwinButt.addActionListener(new ActionListener() {\n\tpublic void actionPerformed(ActionEvent e) {\n\t\tPlatformDefaults.setPlatform(PlatformDefaults.WINDOWS_XP);\n\t\tformatLabel.setText(\"'\" + PlatformDefaults.getButtonOrder() + \"'\");\n\t\tSwingUtilities.updateComponentTreeUI(mainPanel);\n\t}\n});\n\nJToggleButton macButt = createToggleButton(\"Mac OS X\");\nmacButt.addActionListener(new ActionListener() {\n\tpublic void actionPerformed(ActionEvent e) {\n\t\tPlatformDefaults.setPlatform(PlatformDefaults.MAC_OSX);\n\t\tformatLabel.setText(PlatformDefaults.getButtonOrder());\n\t\tSwingUtilities.updateComponentTreeUI(mainPanel);\n\t}\n});\n\nJButton helpButt = createButton(\"Help\");\nhelpButt.addActionListener(new ActionListener() {\n\tpublic void actionPerformed(ActionEvent e) {\n\t\tJOptionPane.showMessageDialog(mainPanel, \"See JavaDoc for PlatformConverter.getButtonBarOrder(..) for details on the format string.\");\n\t}\n});\n\nButtonGroup bg = new ButtonGroup();\nbg.add(winButt);\nbg.add(macButt);\nwinButt.doClick();\n\ntabbedPane.addTab(\"Buttons\", createButtonBarsPanel(\"help\", false));\ntabbedPane.addTab(\"Buttons with Help2\", createButtonBarsPanel(\"help2\", false));\ntabbedPane.addTab(\"Buttons (Same width)\", createButtonBarsPanel(\"help\", true));\n\nmainPanel.add(tabbedPane, \"grow,wrap\");\n\nmainPanel.add(createLabel(\"Button Order:\"));\nmainPanel.add(formatLabel, \"growx\");\nmainPanel.add(winButt);\nmainPanel.add(macButt);\nmainPanel.add(helpButt, \"gapbefore unrel\");");
        return mainPanel;
    }

    private JComponent createButtonBarsPanel(String helpTag, boolean sizeLocked) {
        MigLayout lm = new MigLayout("nogrid, fillx, aligny 100%, gapy unrel");
        JPanel panel = this.createTabPanel(lm);
        String[][] buttons = new String[][]{{"OK"}, {"No", "Yes"}, {"Help", "Close"}, {"OK", "Help"}, {"OK", "Cancel", "Help"}, {"OK", "Cancel", "Apply", "Help"}, {"No", "Yes", "Cancel"}, {"Help", "< Back", "Forward >", "Cancel"}, {"Print...", "Cancel", "Help"}};
        for (int r = 0; r < buttons.length; ++r) {
            for (int i = 0; i < buttons[r].length; ++i) {
                String txt;
                String tag = txt = buttons[r][i];
                if (txt.equals("Help")) {
                    tag = helpTag;
                } else if (txt.equals("< Back")) {
                    tag = "back";
                } else if (txt.equals("Close")) {
                    tag = "cancel";
                } else if (txt.equals("Forward >")) {
                    tag = "next";
                } else if (txt.equals("Print...")) {
                    tag = "other";
                }
                String wrap = i == buttons[r].length - 1 ? ",wrap" : "";
                String sizeGroup = sizeLocked ? "sgx " + r + "," : "";
                panel.add((Component)this.createButton(txt), sizeGroup + "tag " + tag + wrap);
            }
        }
        return panel;
    }

    public JComponent createOrientation() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout lm = new MigLayout("flowy", "[grow,fill]", "[]20[]20[]20[]");
        JPanel mainPanel = this.createTabPanel(lm);
        MigLayout defLM = new MigLayout("", "[trailing][grow,fill]", "");
        JPanel defPanel = this.createTabPanel(defLM);
        this.addSeparator(defPanel, "Default Orientation");
        defPanel.add(this.createLabel("Level of Trust"));
        defPanel.add((Component)this.createTextField(""), "span,growx");
        defPanel.add(this.createLabel("Radar Presentation"));
        defPanel.add(this.createTextField(""));
        defPanel.add(this.createTextField(""));
        MigLayout rtlLM = new MigLayout("rtl,ttb", "[trailing][grow,fill]", "");
        JPanel rtlPanel = this.createTabPanel(rtlLM);
        this.addSeparator(rtlPanel, "Right to Left");
        rtlPanel.add(this.createLabel("Level of Trust"));
        rtlPanel.add((Component)this.createTextField(""), "span,growx");
        rtlPanel.add(this.createLabel("Radar Presentation"));
        rtlPanel.add(this.createTextField(""));
        rtlPanel.add(this.createTextField(""));
        MigLayout rtlbLM = new MigLayout("rtl,btt", "[trailing][grow,fill]", "");
        JPanel rtlbPanel = this.createTabPanel(rtlbLM);
        this.addSeparator(rtlbPanel, "Right to Left, Bottom to Top");
        rtlbPanel.add(this.createLabel("Level of Trust"));
        rtlbPanel.add((Component)this.createTextField(""), "span,growx");
        rtlbPanel.add(this.createLabel("Radar Presentation"));
        rtlbPanel.add(this.createTextField(""));
        rtlbPanel.add(this.createTextField(""));
        MigLayout ltrbLM = new MigLayout("ltr,btt", "[trailing][grow,fill]", "");
        JPanel ltrbPanel = this.createTabPanel(ltrbLM);
        this.addSeparator(ltrbPanel, "Left to Right, Bottom to Top");
        ltrbPanel.add(this.createLabel("Level of Trust"));
        ltrbPanel.add((Component)this.createTextField(""), "span,growx");
        ltrbPanel.add(this.createLabel("Radar Presentation"));
        ltrbPanel.add(this.createTextField(""));
        ltrbPanel.add(this.createTextField(""));
        mainPanel.add(defPanel);
        mainPanel.add(rtlPanel);
        mainPanel.add(rtlbPanel);
        mainPanel.add(ltrbPanel);
        tabbedPane.addTab("Orientation", mainPanel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nMigLayout lm = new MigLayout(\"flowy\", \"[grow,fill]\", \"[]0[]15lp[]0[]\");\nJPanel mainPanel = createTabPanel(lm);\n\n// Default orientation\nMigLayout defLM = new MigLayout(\"\", \"[][grow,fill]\", \"\");\n\nJPanel defPanel = createTabPanel(defLM);\naddSeparator(defPanel, \"Default Orientation\");\ndefPanel.add(createLabel(\"Level\"));\ndefPanel.add(createTextField(\"\"), \"span,growx\");\ndefPanel.add(createLabel(\"Radar\"));\ndefPanel.add(createTextField(\"\"));\ndefPanel.add(createTextField(\"\"));\n\n// Right-to-left, Top-to-bottom\nMigLayout rtlLM = new MigLayout(\"rtl,ttb\",\n                                \"[][grow,fill]\",\n                                \"\");\nJPanel rtlPanel = createTabPanel(rtlLM);\naddSeparator(rtlPanel, \"Right to Left\");\nrtlPanel.add(createLabel(\"Level\"));\nrtlPanel.add(createTextField(\"\"), \"span,growx\");\nrtlPanel.add(createLabel(\"Radar\"));\nrtlPanel.add(createTextField(\"\"));\nrtlPanel.add(createTextField(\"\"));\n\n// Right-to-left, Bottom-to-top\nMigLayout rtlbLM = new MigLayout(\"rtl,btt\",\n                                      \"[][grow,fill]\",\n                                      \"\");\nJPanel rtlbPanel = createTabPanel(rtlbLM);\naddSeparator(rtlbPanel, \"Right to Left, Bottom to Top\");\nrtlbPanel.add(createLabel(\"Level\"));\nrtlbPanel.add(createTextField(\"\"), \"span,growx\");\nrtlbPanel.add(createLabel(\"Radar\"));\nrtlbPanel.add(createTextField(\"\"));\nrtlbPanel.add(createTextField(\"\"));\n\n// Left-to-right, Bottom-to-top\nMigLayout ltrbLM = new MigLayout(\"ltr,btt\",\n                                      \"[][grow,fill]\",\n                                      \"\");\nJPanel ltrbPanel = createTabPanel(ltrbLM);\naddSeparator(ltrbPanel, \"Left to Right, Bottom to Top\");\nltrbPanel.add(createLabel(\"Level\"));\nltrbPanel.add(createTextField(\"\"), \"span,growx\");\nltrbPanel.add(createLabel(\"Radar\"));\nltrbPanel.add(createTextField(\"\"));\nltrbPanel.add(createTextField(\"\"));\n\nmainPanel.add(defPanel);\nmainPanel.add(rtlPanel);\nmainPanel.add(rtlbPanel);\nmainPanel.add(ltrbPanel);\n\ntabbedPane.addTab(\"Orientation\", mainPanel);");
        return tabbedPane;
    }

    public JComponent createCell_Position() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout absLM = new MigLayout("", "[100:pref,fill]", "[100:pref,fill]");
        JPanel absPanel = this.createTabPanel(absLM);
        absPanel.add((Component)this.createButton(), "cell 0 0");
        absPanel.add((Component)this.createButton(), "cell 2 0");
        absPanel.add((Component)this.createButton(), "cell 3 0");
        absPanel.add((Component)this.createButton(), "cell 1 1");
        absPanel.add((Component)this.createButton(), "cell 0 2");
        absPanel.add((Component)this.createButton(), "cell 2 2");
        absPanel.add((Component)this.createButton(), "cell 2 2");
        MigLayout relAwLM = new MigLayout("wrap", "[100:pref,fill][100:pref,fill][100:pref,fill][100:pref,fill]", "[100:pref,fill]");
        JPanel relAwPanel = this.createTabPanel(relAwLM);
        relAwPanel.add(this.createButton());
        relAwPanel.add((Component)this.createButton(), "skip");
        relAwPanel.add(this.createButton());
        relAwPanel.add((Component)this.createButton(), "skip,wrap");
        relAwPanel.add(this.createButton());
        relAwPanel.add((Component)this.createButton(), "skip,split");
        relAwPanel.add(this.createButton());
        MigLayout relWLM = new MigLayout("", "[100:pref,fill]", "[100:pref,fill]");
        JPanel relWPanel = this.createTabPanel(relWLM);
        relWPanel.add(this.createButton());
        relWPanel.add((Component)this.createButton(), "skip");
        relWPanel.add((Component)this.createButton(), "wrap");
        relWPanel.add((Component)this.createButton(), "skip,wrap");
        relWPanel.add(this.createButton());
        relWPanel.add((Component)this.createButton(), "skip,split");
        relWPanel.add(this.createButton());
        MigLayout mixLM = new MigLayout("", "[100:pref,fill]", "[100:pref,fill]");
        JPanel mixPanel = this.createTabPanel(mixLM);
        mixPanel.add(this.createButton());
        mixPanel.add((Component)this.createButton(), "cell 2 0");
        mixPanel.add(this.createButton());
        mixPanel.add((Component)this.createButton(), "cell 1 1,wrap");
        mixPanel.add(this.createButton());
        mixPanel.add((Component)this.createButton(), "cell 2 2,split");
        mixPanel.add(this.createButton());
        tabbedPane.addTab("Absolute", absPanel);
        tabbedPane.addTab("Relative + Wrap", relAwPanel);
        tabbedPane.addTab("Relative", relWPanel);
        tabbedPane.addTab("Mixed", mixPanel);
        this.setSource("\t\tJTabbedPane tabbedPane = new JTabbedPane();\n\n\t\t// Absolute grid position\n\t\tMigLayout absLM = new MigLayout(\"\",\n\t\t                                \"[100:pref,fill]\",\n\t\t                                \"[100:pref,fill]\");\n\t\tJPanel absPanel = createTabPanel(absLM);\n\t\tabsPanel.add(createPanel(), \"cell 0 0\");\n\t\tabsPanel.add(createPanel(), \"cell 2 0\");\n\t\tabsPanel.add(createPanel(), \"cell 3 0\");\n\t\tabsPanel.add(createPanel(), \"cell 1 1\");\n\t\tabsPanel.add(createPanel(), \"cell 0 2\");\n\t\tabsPanel.add(createPanel(), \"cell 2 2\");\n\t\tabsPanel.add(createPanel(), \"cell 2 2\");\n\n\n\t\t// Relative grid position with wrap\n\t\tMigLayout relAwLM = new MigLayout(\"wrap\",\n\t\t                                       \"[100:pref,fill][100:pref,fill][100:pref,fill][100:pref,fill]\",\n\t\t                                       \"[100:pref,fill]\");\n\t\tJPanel relAwPanel = createTabPanel(relAwLM);\n\t\trelAwPanel.add(createPanel());\n\t\trelAwPanel.add(createPanel(), \"skip\");\n\t\trelAwPanel.add(createPanel());\n\t\trelAwPanel.add(createPanel(), \"skip,wrap\");\n\t\trelAwPanel.add(createPanel());\n\t\trelAwPanel.add(createPanel(), \"skip,split\");\n\t\trelAwPanel.add(createPanel());\n\n\n\t\t// Relative grid position with manual wrap\n\t\tMigLayout relWLM = new MigLayout(\"\",\n\t\t                                      \"[100:pref,fill]\",\n\t\t                                      \"[100:pref,fill]\");\n\t\tJPanel relWPanel = createTabPanel(relWLM);\n\t\trelWPanel.add(createPanel());\n\t\trelWPanel.add(createPanel(), \"skip\");\n\t\trelWPanel.add(createPanel(), \"wrap\");\n\t\trelWPanel.add(createPanel(), \"skip,wrap\");\n\t\trelWPanel.add(createPanel());\n\t\trelWPanel.add(createPanel(), \"skip,split\");\n\n\t\trelWPanel.add(createPanel());\n\n\n\t\t// Mixed relative and absolute grid position\n\t\tMigLayout mixLM = new MigLayout(\"\",\n\t\t                                \"[100:pref,fill]\",\n\t\t                                \"[100:pref,fill]\");\n\t\tJPanel mixPanel = createTabPanel(mixLM);\n\t\tmixPanel.add(createPanel());\n\t\tmixPanel.add(createPanel(), \"cell 2 0\");\n\t\tmixPanel.add(createPanel());\n\t\tmixPanel.add(createPanel(), \"cell 1 1,wrap\");\n\t\tmixPanel.add(createPanel());\n\t\tmixPanel.add(createPanel(), \"cell 2 2,split\");\n\t\tmixPanel.add(createPanel());\n\n\t\ttabbedPane.addTab(\"Absolute\", absPanel);\n\t\ttabbedPane.addTab(\"Relative + Wrap\", relAwPanel);\n\t\ttabbedPane.addTab(\"Relative\", relWPanel);\n\t\ttabbedPane.addTab(\"Mixed\", mixPanel);");
        return tabbedPane;
    }

    public JComponent createPlain() {
        return this.createPlainImpl(false);
    }

    private JComponent createPlainImpl(boolean debug) {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout lm = new MigLayout(debug && benchRuns == 0 ? "debug, inset 20" : "ins 20", "[para]0[][100lp, fill][60lp][95lp, fill]", "");
        JPanel panel = this.createTabPanel(lm);
        this.addSeparator(panel, "Manufacturer");
        panel.add((Component)this.createLabel("Company"), "skip");
        panel.add((Component)this.createTextField(""), "span, growx");
        panel.add((Component)this.createLabel("Contact"), "skip");
        panel.add((Component)this.createTextField(""), "span, growx");
        panel.add((Component)this.createLabel("Order No"), "skip");
        panel.add((Component)this.createTextField(15), "wrap para");
        this.addSeparator(panel, "Inspector");
        panel.add((Component)this.createLabel("Name"), "skip");
        panel.add((Component)this.createTextField(""), "span, growx");
        panel.add((Component)this.createLabel("Reference No"), "skip");
        panel.add((Component)this.createTextField(""), "wrap");
        panel.add((Component)this.createLabel("Status"), "skip");
        panel.add((Component)this.createCombo(new String[]{"In Progress", "Finnished", "Released"}), "wrap para");
        this.addSeparator(panel, "Ship");
        panel.add((Component)this.createLabel("Shipyard"), "skip");
        panel.add((Component)this.createTextField(""), "span, growx");
        panel.add((Component)this.createLabel("Register No"), "skip");
        panel.add(this.createTextField(""));
        panel.add((Component)this.createLabel("Hull No"), "right");
        panel.add((Component)this.createTextField(15), "wrap");
        panel.add((Component)this.createLabel("Project StructureType"), "skip");
        panel.add(this.createCombo(new String[]{"New Building", "Convention", "Repair"}));
        if (debug) {
            panel.add((Component)this.createLabel("Red is cell bounds. Blue is component bounds."), "newline,ax left,span,gaptop 40,");
        }
        tabbedPane.addTab("Plain", panel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nMigLayout lm = new MigLayout((debug && benchRuns == 0 ? \"debug, inset 20\" : \"ins 20\"), \"[para]0[][100lp, fill][60lp][95lp, fill]\", \"\");\nJPanel panel = createTabPanel(lm);\n\naddSeparator(panel, \"Manufacturer\");\n\npanel.add(createLabel(\"Company\"),   \"skip\");\npanel.add(createTextField(\"\"),      \"span, growx\");\npanel.add(createLabel(\"Contact\"),   \"skip\");\npanel.add(createTextField(\"\"),      \"span, growx\");\npanel.add(createLabel(\"Order No\"),  \"skip\");\npanel.add(createTextField(15),      \"wrap para\");\n\naddSeparator(panel, \"Inspector\");\n\npanel.add(createLabel(\"Name\"),         \"skip\");\npanel.add(createTextField(\"\"),         \"span, growx\");\npanel.add(createLabel(\"Reference No\"), \"skip\");\npanel.add(createTextField(\"\"),         \"wrap\");\npanel.add(createLabel(\"Status\"),       \"skip\");\npanel.add(createCombo(new String[] {\"In Progress\", \"Finnished\", \"Released\"}), \"wrap para\");\n\naddSeparator(panel, \"Ship\");\n\npanel.add(createLabel(\"Shipyard\"),     \"skip\");\npanel.add(createTextField(\"\"),         \"span, growx\");\npanel.add(createLabel(\"Register No\"),  \"skip\");\npanel.add(createTextField(\"\"));\npanel.add(createLabel(\"Hull No\"),      \"right\");\npanel.add(createTextField(15), \"wrap\");\npanel.add(createLabel(\"Project StructureType\"), \"skip\");\npanel.add(createCombo(new String[] {\"New Building\", \"Convention\", \"Repair\"}));\n\nif (debug)\n\tpanel.add(createLabel(\"Red is cell bounds. Blue is component bounds.\"), \"newline,ax left,span,gaptop 40,\");\n\ntabbedPane.addTab(\"Plain\", panel);");
        return tabbedPane;
    }

    public JComponent createBound_Sizes() {
        JTabbedPane tabbedPane = new JTabbedPane();
        for (int i = 0; i < 2; ++i) {
            String colConstr = i == 0 ? "[right][300]" : "[right, 100lp:pref][300]";
            MigLayout LM1 = new MigLayout("wrap", colConstr, "");
            JPanel panel1 = this.createTabPanel(LM1);
            panel1.add(this.createLabel("File Number:"));
            panel1.add((Component)this.createTextField(""), "growx");
            panel1.add(this.createLabel("RFQ Number:"));
            panel1.add((Component)this.createTextField(""), "growx");
            panel1.add(this.createLabel("Entry Date:"));
            panel1.add(this.createTextField(6));
            panel1.add(this.createLabel("Sales Person:"));
            panel1.add((Component)this.createTextField(""), "growx");
            MigLayout LM2 = new MigLayout("wrap", colConstr, "");
            JPanel panel2 = this.createTabPanel(LM2);
            panel2.add(this.createLabel("Shipper:"));
            panel2.add((Component)this.createTextField(6), "split 2");
            panel2.add((Component)this.createTextField(""), "growx");
            panel2.add(this.createLabel("Consignee:"));
            panel2.add((Component)this.createTextField(6), "split 2");
            panel2.add((Component)this.createTextField(""), "growx");
            panel2.add(this.createLabel("Departure:"));
            panel2.add((Component)this.createTextField(6), "split 2");
            panel2.add((Component)this.createTextField(""), "growx");
            panel2.add(this.createLabel("Destination:"));
            panel2.add((Component)this.createTextField(6), "split 2");
            panel2.add((Component)this.createTextField(""), "growx");
            tabbedPane.addTab(i == 0 ? "Jumping 1" : "Stable 1", panel1);
            tabbedPane.addTab(i == 0 ? "Jumping 2" : "Stable 2", panel2);
        }
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nfor (int i = 0; i < 2; i++) {   // Jumping for 0 and Stable for 1\n\tString colConstr = i == 0 ? \"[right][300]\" : \"[right, 100lp:pref][300]\";\n\n\tMigLayout LM1 = new MigLayout(\"wrap\", colConstr, \"\");\n\tJPanel panel1 = createTabPanel(LM1);\n\tpanel1.add(createLabel(\"File Number:\"));\n\tpanel1.add(createTextField(\"\"), \"growx\");\n\tpanel1.add(createLabel(\"RFQ Number:\"));\n\tpanel1.add(createTextField(\"\"), \"growx\");\n\tpanel1.add(createLabel(\"Entry Date:\"));\n\tpanel1.add(createTextField(6));\n\tpanel1.add(createLabel(\"Sales Person:\"));\n\tpanel1.add(createTextField(\"\"), \"growx\");\n\n\tMigLayout LM2 = new MigLayout(\"wrap\", colConstr, \"\");\n\tJPanel panel2 = createTabPanel(LM2);\n\tpanel2.add(createLabel(\"Shipper:\"));\n\tpanel2.add(createTextField(6), \"split 2\");\n\tpanel2.add(createTextField(\"\"), \"growx\");\n\tpanel2.add(createLabel(\"Consignee:\"));\n\tpanel2.add(createTextField(6), \"split 2\");\n\tpanel2.add(createTextField(\"\"), \"growx\");\n\tpanel2.add(createLabel(\"Departure:\"));\n\tpanel2.add(createTextField(6), \"split 2\");\n\tpanel2.add(createTextField(\"\"), \"growx\");\n\tpanel2.add(createLabel(\"Destination:\"));\n\tpanel2.add(createTextField(6), \"split 2\");\n\tpanel2.add(createTextField(\"\"), \"growx\");\n\n\ttabbedPane.addTab(i == 0 ? \"Jumping 1\" : \"Stable 2\", panel1);\n\ttabbedPane.addTab(i == 0 ? \"Jumping 2\" : \"Stable 2\", panel2);\n}");
        return tabbedPane;
    }

    public JComponent createComponent_Sizes() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout LM = new MigLayout("wrap", "[right][0:pref,grow]", "");
        JPanel panel = this.createTabPanel(LM);
        JScrollPane descrText = this.createTextAreaScroll("Use slider to see how the components grow and shrink depending on the constraints set on them.", 0, 0, false);
        descrText.setOpaque(false);
        descrText.setBorder(new EmptyBorder(10, 10, 10, 10));
        ((JTextArea)descrText.getViewport().getView()).setOpaque(false);
        descrText.getViewport().setOpaque(false);
        JSplitPane splitPane = new JSplitPane(1, true, panel, descrText);
        splitPane.setOpaque(false);
        splitPane.setBorder(null);
        panel.add(this.createLabel("\"\""));
        panel.add(this.createTextField("8"));
        panel.add(this.createLabel("\"min!\""));
        panel.add((Component)this.createTextField("3", 3), "width min!");
        panel.add(this.createLabel("\"pref!\""));
        panel.add((Component)this.createTextField("3", 3), "width pref!");
        panel.add(this.createLabel("\"min:pref\""));
        panel.add((Component)this.createTextField("8", 8), "width min:pref");
        panel.add(this.createLabel("\"min:100:150\""));
        panel.add((Component)this.createTextField("8", 8), "width min:100:150");
        panel.add(this.createLabel("\"min:100:150, growx\""));
        panel.add((Component)this.createTextField("8", 8), "width min:100:150, growx");
        panel.add(this.createLabel("\"min:100, growx\""));
        panel.add((Component)this.createTextField("8", 8), "width min:100, growx");
        panel.add(this.createLabel("\"40!\""));
        panel.add((Component)this.createTextField("8", 8), "width 40!");
        panel.add(this.createLabel("\"40:40:40\""));
        panel.add((Component)this.createTextField("8", 8), "width 40:40:40");
        tabbedPane.addTab("Component Sizes", splitPane);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nMigLayout LM = new MigLayout(\"wrap\", \"[right][0:pref,grow]\", \"\");\n\nJPanel panel = createTabPanel(LM);\nJScrollPane descrText = createTextAreaScroll(\"Use slider to see how the components grow and shrink depending on the constraints set on them.\", 0, 0, false);\n\ndescrText.setOpaque(OPAQUE);\ndescrText.setBorder(new EmptyBorder(10, 10, 10, 10));\n((JTextArea) descrText.getViewport().getView()).setOpaque(OPAQUE);\ndescrText.getViewport().setOpaque(OPAQUE);\n\nJSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, panel, descrText);\nsplitPane.setOpaque(OPAQUE);\nsplitPane.setBorder(null);\n\npanel.add(createLabel(\"\\\"\\\"\"));\npanel.add(createTextField(\"8\", 8));\npanel.add(createLabel(\"\\\"min!\\\"\"));\npanel.add(createTextField(\"3\", 3), \"width min!\");\npanel.add(createLabel(\"\\\"pref!\\\"\"));\npanel.add(createTextField(\"3\", 3), \"width pref!\");\npanel.add(createLabel(\"\\\"min:pref\\\"\"));\npanel.add(createTextField(\"8\", 8), \"width min:pref\");\npanel.add(createLabel(\"\\\"min:100:150\\\"\"));\npanel.add(createTextField(\"8\", 8), \"width min:100:150\");\npanel.add(createLabel(\"\\\"min:100:150, growx\\\"\"));\npanel.add(createTextField(\"8\", 8), \"width min:100:150, growx\");\npanel.add(createLabel(\"\\\"min:100, growx\\\"\"));\npanel.add(createTextField(\"8\", 8), \"width min:100, growx\");\npanel.add(createLabel(\"\\\"40!\\\"\"));\npanel.add(createTextField(\"8\", 8), \"width 40!\");\npanel.add(createLabel(\"\\\"40:40:40\\\"\"));\npanel.add(createTextField(\"8\", 8), \"width 40:40:40\");\n\ntabbedPane.addTab(\"Component Sizes\", splitPane);");
        return tabbedPane;
    }

    public JComponent createCell_Alignments() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout hLM = new MigLayout("wrap", "[grow,left][grow,center][grow,right][grow,fill,center]", "[]unrel[][]");
        JPanel hPanel = this.createTabPanel(hLM);
        String[] sizes = new String[]{"", "growx", "growx 0", "left", "center", "right", "leading", "trailing"};
        hPanel.add((Component)this.createLabel("[left]"), "c");
        hPanel.add((Component)this.createLabel("[center]"), "c");
        hPanel.add((Component)this.createLabel("[right]"), "c");
        hPanel.add((Component)this.createLabel("[fill,center]"), "c, growx 0");
        for (int r = 0; r < sizes.length; ++r) {
            for (int c = 0; c < 4; ++c) {
                String text = sizes[r].length() > 0 ? sizes[r] : "default";
                hPanel.add((Component)this.createButton(text), sizes[r]);
            }
        }
        MigLayout vLM = new MigLayout("wrap,flowy", "[right][]", "[grow,top][grow,center][grow,bottom][grow,fill,bottom][grow,fill,baseline]");
        JPanel vPanel = this.createTabPanel(vLM);
        String[] vSizes = new String[]{"", "growy", "growy 0", "top", "aligny center", "bottom"};
        vPanel.add((Component)this.createLabel("[top]"), "aligny center");
        vPanel.add((Component)this.createLabel("[center]"), "aligny center");
        vPanel.add((Component)this.createLabel("[bottom]"), "aligny center");
        vPanel.add((Component)this.createLabel("[fill, bottom]"), "aligny center, growy 0");
        vPanel.add((Component)this.createLabel("[fill, baseline]"), "aligny center");
        for (int c = 0; c < vSizes.length; ++c) {
            for (int r = 0; r < 5; ++r) {
                String text = vSizes[c].length() > 0 ? vSizes[c] : "default";
                JButton b = this.createButton(text);
                if (r == 4 && c <= 1) {
                    b.setFont(new Font("sansserif", 0, 16 + c * 5));
                }
                vPanel.add((Component)b, vSizes[c]);
            }
        }
        tabbedPane.addTab("Horizontal", hPanel);
        tabbedPane.addTab("Vertical", vPanel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// Horizontal\nMigLayout hLM = new MigLayout(\"wrap\",\n                              \"[grow,left][grow,center][grow,right][grow,fill,center]\",\n                              \"[]unrel[][]\");\nJPanel hPanel = createTabPanel(hLM);\nString[] sizes = new String[] {\"\", \"growx\", \"growx 0\", \"left\", \"center\", \"right\", \"leading\", \"trailing\"};\nhPanel.add(createLabel(\"[left]\"), \"c\");\nhPanel.add(createLabel(\"[center]\"), \"c\");\nhPanel.add(createLabel(\"[right]\"), \"c\");\nhPanel.add(createLabel(\"[fill,center]\"), \"c, growx 0\");\n\nfor (int r = 0; r < sizes.length; r++) {\n\tfor (int c = 0; c < 4; c++) {\n\t\tString text = sizes[r].length() > 0 ? sizes[r] : \"default\";\n\t\thPanel.add(createButton(text), sizes[r]);\n\t}\n}\n\n// Vertical\nMigLayout vLM = new MigLayout(\"wrap,flowy\",\n                                   \"[right][]\",\n                                   \"[grow,top][grow,center][grow,bottom][grow,fill,bottom][grow,fill,baseline]\");\nJPanel vPanel = createTabPanel(vLM);\nString[] vSizes = new String[] {\"\", \"growy\", \"growy 0\", \"top\", \"center\", \"bottom\"};\nvPanel.add(createLabel(\"[top]\"), \"center\");\nvPanel.add(createLabel(\"[center]\"), \"center\");\nvPanel.add(createLabel(\"[bottom]\"), \"center\");\nvPanel.add(createLabel(\"[fill, bottom]\"), \"center, growy 0\");\nvPanel.add(createLabel(\"[fill, baseline]\"), \"center\");\n\nfor (int c = 0; c < vSizes.length; c++) {\n\tfor (int r = 0; r < 5; r++) {\n\t\tString text = vSizes[c].length() > 0 ? vSizes[c] : \"default\";\n\t\tJButton b = createButton(text);\n\t\tif (r == 4 && c <= 1)\n\t\t\tb.setFont(new Font(\"sansserif\", Font.PLAIN, 16 + c * 5));\n\t\tvPanel.add(b, vSizes[c]);\n\t}\n}\n\ntabbedPane.addTab(\"Horizontal\", hPanel);\ntabbedPane.addTab(\"Vertical\", vPanel);");
        return tabbedPane;
    }

    public JComponent createUnits() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout hLM = new MigLayout("wrap,nocache", "[right][]", "");
        JPanel hPanel = this.createTabPanel(hLM);
        String[] sizes = new String[]{"72pt", "25.4mm", "2.54cm", "1in", "72px", "96px", "120px", "25%", "20sp"};
        for (int i = 0; i < sizes.length; ++i) {
            hPanel.add(this.createLabel(sizes[i]));
            hPanel.add((Component)this.createTextField(""), "width " + sizes[i] + "!");
        }
        MigLayout hlpLM = new MigLayout("nocache", "[right][][]", "");
        JPanel hlpPanel = this.createTabPanel(hlpLM);
        hlpPanel.add(this.createLabel("9 cols"));
        hlpPanel.add(this.createTextField(9));
        String[] lpSizes = new String[]{"75lp", "75px", "88px", "100px"};
        hlpPanel.add((Component)this.createLabel("Width of createTextField(9)"), "wrap");
        for (int i = 0; i < lpSizes.length; ++i) {
            hlpPanel.add(this.createLabel(lpSizes[i]));
            hlpPanel.add((Component)this.createTextField(""), "width " + lpSizes[i] + "!, wrap");
        }
        MigLayout vLM = new MigLayout("wrap,flowy,nocache", "[c]", "[top][top]");
        JPanel vPanel = this.createTabPanel(vLM);
        String[] vSizes = new String[]{"72pt", "25.4mm", "2.54cm", "1in", "72px", "96px", "120px", "25%", "20sp"};
        for (int i = 0; i < sizes.length; ++i) {
            vPanel.add(this.createLabel(vSizes[i]));
            vPanel.add((Component)this.createTextArea("", 0, 5), "width 50!, height " + vSizes[i] + "!");
        }
        MigLayout vlpLM = new MigLayout("wrap,flowy,nocache", "[c]", "[top][top]40px[top][top]");
        JPanel vlpPanel = this.createTabPanel(vlpLM);
        vlpPanel.add(this.createLabel("4 rows"));
        vlpPanel.add((Component)this.createTextArea("", 4, 5), "width 50!");
        vlpPanel.add(this.createLabel("field"));
        vlpPanel.add(this.createTextField(5));
        String[] vlpSizes1 = new String[]{"63lp", "57px", "63px", "68px", "25%"};
        String[] vlpSizes2 = new String[]{"21lp", "21px", "23px", "24px", "10%"};
        for (int i = 0; i < vlpSizes1.length; ++i) {
            vlpPanel.add(this.createLabel(vlpSizes1[i]));
            vlpPanel.add((Component)this.createTextArea("", 1, 5), "width 50!, height " + vlpSizes1[i] + "!");
            vlpPanel.add(this.createLabel(vlpSizes2[i]));
            vlpPanel.add((Component)this.createTextField(5), "height " + vlpSizes2[i] + "!");
        }
        vlpPanel.add((Component)this.createLabel("button"), "skip 2");
        vlpPanel.add(this.createButton("..."));
        tabbedPane.addTab("Horizontal", hPanel);
        tabbedPane.addTab("Horizontal LP", hlpPanel);
        tabbedPane.addTab("Vertical", vPanel);
        tabbedPane.addTab("Vertical LP", vlpPanel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// Horizontal\nMigLayout hLM = new MigLayout(\"wrap,nocache\",\n\t\t\t\t\t\t\t  \"[right][]\",\n\t\t\t\t\t\t\t  \"\");\nJPanel hPanel = createTabPanel(hLM);\nString[] sizes = new String[] {\"72pt\", \"25.4mm\", \"2.54cm\", \"1in\", \"72px\", \"96px\", \"120px\", \"25%\", \"20sp\"};\nfor (int i = 0; i < sizes.length; i++) {\n\thPanel.add(createLabel(sizes[i]));\n\thPanel.add(createTextField(\"\"), \"width \" + sizes[i] + \"!\");\n}\n\n// Horizontal lp\nMigLayout hlpLM = new MigLayout(\"nocache\", \"[right][][]\", \"\");\nJPanel hlpPanel = createTabPanel(hlpLM);\nhlpPanel.add(createLabel(\"9 cols\"));\nhlpPanel.add(createTextField(9));\nString[] lpSizes = new String[] {\"75lp\", \"75px\", \"88px\", \"100px\"};\nhlpPanel.add(createLabel(\"Width of createTextField(9)\"), \"wrap\");\nfor (int i = 0; i < lpSizes.length; i++) {\n\thlpPanel.add(createLabel(lpSizes[i]));\n\thlpPanel.add(createTextField(\"\"), \"width \" + lpSizes[i] + \"!, wrap\");\n}\n\n// Vertical\nMigLayout vLM = new MigLayout(\"wrap,flowy,nocache\",\n\t\t\t\t\t\t\t  \"[c]\",\n\t\t\t\t\t\t\t  \"[top][top]\");\nJPanel vPanel = createTabPanel(vLM);\nString[] vSizes = new String[] {\"72pt\", \"25.4mm\", \"2.54cm\", \"1in\", \"72px\", \"96px\", \"120px\", \"25%\", \"20sp\"};\nfor (int i = 0; i < sizes.length; i++) {\n\tvPanel.add(createLabel(vSizes[i]));\n\tvPanel.add(createTextArea(\"\", 0, 5), \"width 50!, height \" + vSizes[i] + \"!\");\n}\n\n// Vertical lp\nMigLayout vlpLM = new MigLayout(\"wrap,flowy,nocache\",\n\t\t\t\t\t\t\t\t\"[c]\",\n\t\t\t\t\t\t\t\t\"[top][top]40px[top][top]\");\nJPanel vlpPanel = createTabPanel(vlpLM);\nvlpPanel.add(createLabel(\"4 rows\"));\nvlpPanel.add(createTextArea(\"\", 4, 5), \"width 50!\");\nvlpPanel.add(createLabel(\"field\"));\nvlpPanel.add(createTextField(5));\n\nString[] vlpSizes1 = new String[] {\"63lp\", \"57px\", \"63px\", \"68px\", \"25%\"};\nString[] vlpSizes2 = new String[] {\"21lp\", \"21px\", \"23px\", \"24px\", \"10%\"};\nfor (int i = 0; i < vlpSizes1.length; i++) {\n\tvlpPanel.add(createLabel(vlpSizes1[i]));\n\tvlpPanel.add(createTextArea(\"\", 1, 5), \"width 50!, height \" + vlpSizes1[i] + \"!\");\n\tvlpPanel.add(createLabel(vlpSizes2[i]));\n\tvlpPanel.add(createTextField(5), \"height \" + vlpSizes2[i] + \"!\");\n}\n\nvlpPanel.add(createLabel(\"button\"), \"skip 2\");\nvlpPanel.add(createButton(\"...\"));\n\ntabbedPane.addTab(\"Horizontal\", hPanel);\ntabbedPane.addTab(\"Horizontal LP\", hlpPanel);\ntabbedPane.addTab(\"Vertical\", vPanel);\ntabbedPane.addTab(\"Vertical LP\", vlpPanel);");
        return tabbedPane;
    }

    public JComponent createGrouping() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout ugM = new MigLayout("", "[]push[][][]", "");
        JPanel ugPanel = this.createTabPanel(ugM);
        ugPanel.add(this.createButton("Help"));
        ugPanel.add((Component)this.createButton("< Back"), "");
        ugPanel.add((Component)this.createButton("Forward >"), "gap push");
        ugPanel.add((Component)this.createButton("Apply"), "gap unrel");
        ugPanel.add((Component)this.createButton("Cancel"), "gap unrel");
        MigLayout gM = new MigLayout("nogrid, fillx");
        JPanel gPanel = this.createTabPanel(gM);
        gPanel.add((Component)this.createButton("Help"), "sg");
        gPanel.add((Component)this.createButton("< Back"), "sg,gap push");
        gPanel.add((Component)this.createButton("Forward >"), "sg");
        gPanel.add((Component)this.createButton("Apply"), "sg,gap unrel");
        gPanel.add((Component)this.createButton("Cancel"), "sg,gap unrel");
        MigLayout gcM = new MigLayout("", "[sg,fill]push[sg,fill][sg,fill]unrel[sg,fill]unrel[sg,fill]", "");
        JPanel gcPanel = this.createTabPanel(gcM);
        gcPanel.add(this.createButton("Help"));
        gcPanel.add(this.createButton("< Back"));
        gcPanel.add(this.createButton("Forward >"));
        gcPanel.add(this.createButton("Apply"));
        gcPanel.add(this.createButton("Cancel"));
        MigLayout ugrM = new MigLayout();
        JPanel ugrPanel = this.createTabPanel(ugrM);
        ugrPanel.add(this.createLabel("File Number:"));
        ugrPanel.add((Component)this.createTextField(30), "wrap");
        ugrPanel.add(this.createLabel("BL/MBL number:"));
        ugrPanel.add((Component)this.createTextField(7), "split 2");
        ugrPanel.add((Component)this.createTextField(7), "wrap");
        ugrPanel.add(this.createLabel("Entry Date:"));
        ugrPanel.add((Component)this.createTextField(7), "wrap");
        ugrPanel.add(this.createLabel("RFQ Number:"));
        ugrPanel.add((Component)this.createTextField(30), "wrap");
        ugrPanel.add(this.createLabel("Goods:"));
        ugrPanel.add((Component)this.createCheck("Dangerous"), "wrap");
        ugrPanel.add(this.createLabel("Shipper:"));
        ugrPanel.add((Component)this.createTextField(30), "wrap");
        ugrPanel.add(this.createLabel("Customer:"));
        ugrPanel.add((Component)this.createTextField(""), "split 2,growx");
        ugrPanel.add((Component)this.createButton("..."), "width 60px:pref,wrap");
        ugrPanel.add(this.createLabel("Port of Loading:"));
        ugrPanel.add((Component)this.createTextField(30), "wrap");
        ugrPanel.add(this.createLabel("Destination:"));
        ugrPanel.add((Component)this.createTextField(30), "wrap");
        MigLayout grM = new MigLayout("", "[]", "[sg]");
        JPanel grPanel = this.createTabPanel(grM);
        grPanel.add(this.createLabel("File Number:"));
        grPanel.add((Component)this.createTextField(30), "wrap");
        grPanel.add(this.createLabel("BL/MBL number:"));
        grPanel.add((Component)this.createTextField(7), "split 2");
        grPanel.add((Component)this.createTextField(7), "wrap");
        grPanel.add(this.createLabel("Entry Date:"));
        grPanel.add((Component)this.createTextField(7), "wrap");
        grPanel.add(this.createLabel("RFQ Number:"));
        grPanel.add((Component)this.createTextField(30), "wrap");
        grPanel.add(this.createLabel("Goods:"));
        grPanel.add((Component)this.createCheck("Dangerous"), "wrap");
        grPanel.add(this.createLabel("Shipper:"));
        grPanel.add((Component)this.createTextField(30), "wrap");
        grPanel.add(this.createLabel("Customer:"));
        grPanel.add((Component)this.createTextField(""), "split 2,growx");
        grPanel.add((Component)this.createButton("..."), "width 50px:pref,wrap");
        grPanel.add(this.createLabel("Port of Loading:"));
        grPanel.add((Component)this.createTextField(30), "wrap");
        grPanel.add(this.createLabel("Destination:"));
        grPanel.add((Component)this.createTextField(30), "wrap");
        tabbedPane.addTab("Ungrouped", ugPanel);
        tabbedPane.addTab("Grouped (Components)", gPanel);
        tabbedPane.addTab("Grouped (Columns)", gcPanel);
        tabbedPane.addTab("Ungrouped Rows", ugrPanel);
        tabbedPane.addTab("Grouped Rows", grPanel);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// Ungrouped\nMigLayout ugM = new MigLayout(\"\", \"[]push[][][]\", \"\");\nJPanel ugPanel = createTabPanel(ugM);\nugPanel.add(createButton(\"Help\"));\nugPanel.add(createButton(\"< Back\"), \"\");\nugPanel.add(createButton(\"Forward >\"), \"gap push\");\nugPanel.add(createButton(\"Apply\"), \"gap unrel\");\nugPanel.add(createButton(\"Cancel\"), \"gap unrel\");\n\n// Grouped Components\nMigLayout gM = new MigLayout(\"nogrid, fillx\");\nJPanel gPanel = createTabPanel(gM);\ngPanel.add(createButton(\"Help\"), \"sg\");\ngPanel.add(createButton(\"< Back\"), \"sg,gap push\");\ngPanel.add(createButton(\"Forward >\"), \"sg\");\ngPanel.add(createButton(\"Apply\"), \"sg,gap unrel\");\ngPanel.add(createButton(\"Cancel\"), \"sg,gap unrel\");\n\n// Grouped Columns\nMigLayout gcM = new MigLayout(\"\", \"[sg,fill]push[sg,fill][sg,fill]unrel[sg,fill]unrel[sg,fill]\", \"\");\nJPanel gcPanel = createTabPanel(gcM);\ngcPanel.add(createButton(\"Help\"));\ngcPanel.add(createButton(\"< Back\"));\ngcPanel.add(createButton(\"Forward >\"));\ngcPanel.add(createButton(\"Apply\"));\ngcPanel.add(createButton(\"Cancel\"));\n\n// Ungrouped Rows\nMigLayout ugrM = new MigLayout();     // no \"sg\" is the only difference to next panel\nJPanel ugrPanel = createTabPanel(ugrM);\nugrPanel.add(createLabel(\"File Number:\"));\nugrPanel.add(createTextField(30), \"wrap\");\nugrPanel.add(createLabel(\"BL/MBL number:\"));\nugrPanel.add(createTextField(7), \"split 2\");\nugrPanel.add(createTextField(7), \"wrap\");\nugrPanel.add(createLabel(\"Entry Date:\"));\nugrPanel.add(createTextField(7), \"wrap\");\nugrPanel.add(createLabel(\"RFQ Number:\"));\nugrPanel.add(createTextField(30), \"wrap\");\nugrPanel.add(createLabel(\"Goods:\"));\nugrPanel.add(createCheck(\"Dangerous\"), \"wrap\");\nugrPanel.add(createLabel(\"Shipper:\"));\nugrPanel.add(createTextField(30), \"wrap\");\nugrPanel.add(createLabel(\"Customer:\"));\nugrPanel.add(createTextField(\"\"), \"split 2,growx\");\nugrPanel.add(createButton(\"...\"), \"width 60px:pref,wrap\");\nugrPanel.add(createLabel(\"Port of Loading:\"));\nugrPanel.add(createTextField(30), \"wrap\");\nugrPanel.add(createLabel(\"Destination:\"));\nugrPanel.add(createTextField(30), \"wrap\");\n\n// Grouped Rows\nMigLayout grM = new MigLayout(\"\", \"[]\", \"[sg]\");    // \"sg\" is the only difference to previous panel\nJPanel grPanel = createTabPanel(grM);\ngrPanel.add(createLabel(\"File Number:\"));\ngrPanel.add(createTextField(30),\"wrap\");\ngrPanel.add(createLabel(\"BL/MBL number:\"));\ngrPanel.add(createTextField(7),\"split 2\");\ngrPanel.add(createTextField(7), \"wrap\");\ngrPanel.add(createLabel(\"Entry Date:\"));\ngrPanel.add(createTextField(7), \"wrap\");\ngrPanel.add(createLabel(\"RFQ Number:\"));\ngrPanel.add(createTextField(30), \"wrap\");\ngrPanel.add(createLabel(\"Goods:\"));\ngrPanel.add(createCheck(\"Dangerous\"), \"wrap\");\ngrPanel.add(createLabel(\"Shipper:\"));\ngrPanel.add(createTextField(30), \"wrap\");\ngrPanel.add(createLabel(\"Customer:\"));\ngrPanel.add(createTextField(\"\"), \"split 2,growx\");\ngrPanel.add(createButton(\"...\"), \"width 50px:pref,wrap\");\ngrPanel.add(createLabel(\"Port of Loading:\"));\ngrPanel.add(createTextField(30), \"wrap\");\ngrPanel.add(createLabel(\"Destination:\"));\ngrPanel.add(createTextField(30), \"wrap\");\n\ntabbedPane.addTab(\"Ungrouped\", ugPanel);\ntabbedPane.addTab(\"Grouped (Components)\", gPanel);\ntabbedPane.addTab(\"Grouped (Columns)\", gcPanel);\ntabbedPane.addTab(\"Ungrouped Rows\", ugrPanel);\ntabbedPane.addTab(\"Grouped Rows\", grPanel);");
        return tabbedPane;
    }

    public JComponent createSpan() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout colLM = new MigLayout("nocache", "[fill][25%!,fill][105lp!,fill][100px!,fill]", "[]15[][]");
        JPanel colPanel = this.createTabPanel(colLM);
        colPanel.add(this.createTextField("Col1 [ ]"));
        colPanel.add(this.createTextField("Col2 [25%!]"));
        colPanel.add(this.createTextField("Col3 [105lp!]"));
        colPanel.add((Component)this.createTextField("Col4 [100px!]"), "wrap");
        colPanel.add(this.createLabel("Full Name:"));
        colPanel.add((Component)this.createTextField("span, growx", 40), "span,growx");
        colPanel.add(this.createLabel("Phone:"));
        colPanel.add((Component)this.createTextField(5), "span 3, split 5");
        colPanel.add(this.createTextField(7));
        colPanel.add(this.createTextField(7));
        colPanel.add(this.createTextField(9));
        colPanel.add((Component)this.createLabel("(span 3, split 4)"), "wrap");
        colPanel.add(this.createLabel("Zip/City:"));
        colPanel.add(this.createTextField(5));
        colPanel.add((Component)this.createTextField("span 2, growx", 5), "span 2,growx");
        MigLayout rowLM = new MigLayout("wrap", "[225lp]para[225lp]", "[]3[]unrel[]3[]unrel[]3[]");
        JPanel rowPanel = this.createTabPanel(rowLM);
        rowPanel.add(this.createLabel("Name"));
        rowPanel.add(this.createLabel("Notes"));
        rowPanel.add((Component)this.createTextField("growx"), "growx");
        rowPanel.add((Component)this.createTextArea("spany,grow", 5, 20), "spany,grow");
        rowPanel.add(this.createLabel("Phone"));
        rowPanel.add((Component)this.createTextField("growx"), "growx");
        rowPanel.add(this.createLabel("Fax"));
        rowPanel.add((Component)this.createTextField("growx"), "growx");
        tabbedPane.addTab("Column Span/Split", colPanel);
        tabbedPane.addTab("Row Span", rowPanel);
        this.setSource("\t\tJTabbedPane tabbedPane = new JTabbedPane();\n\n\t\t// Horizontal span\n\t\tMigLayout colLM = new MigLayout(\"\",\n\t\t                                     \"[fill][25%!,fill][105lp!,fill][100px!,fill]\",\n\t\t                                     \"[]15[][]\");\n\t\tJPanel colPanel = createTabPanel(colLM);\n\t\tcolPanel.add(createTextField(\"Col1 [ ]\"));\n\t\tcolPanel.add(createTextField(\"Col2 [25%!]\"));\n\t\tcolPanel.add(createTextField(\"Col3 [105lp!]\"));\n\t\tcolPanel.add(createTextField(\"Col4 [100px!]\"), \"wrap\");\n\n\t\tcolPanel.add(createLabel(\"Full Name:\"));\n\t\tcolPanel.add(createTextField(\"span, growx\", 40), \"span,growx\");\n\n\t\tcolPanel.add(createLabel(\"Phone:\"));\n\t\tcolPanel.add(createTextField(5), \"span 3, split 5\");\n\t\tcolPanel.add(createTextField(7));\n\t\tcolPanel.add(createTextField(7));\n\t\tcolPanel.add(createTextField(9));\n\t\tcolPanel.add(createLabel(\"(span 3, split 4)\"), \"wrap\");\n\n\t\tcolPanel.add(createLabel(\"Zip/City:\"));\n\t\tcolPanel.add(createTextField(5));\n\t\tcolPanel.add(createTextField(\"span 2, growx\", 5), \"span 2,growx\");\n\n\t\t// Vertical span\n\t\tMigLayout rowLM = new MigLayout(\"wrap\",\n\t\t                                     \"[225lp]para[225lp]\",\n\t\t                                     \"[]3[]unrel[]3[]unrel[]3[]\");\n\t\tJPanel rowPanel = createTabPanel(rowLM);\n\t\trowPanel.add(createLabel(\"Name\"));\n\t\trowPanel.add(createLabel(\"Notes\"));\n\t\trowPanel.add(createTextField(\"growx\"), \"growx\");\n\t\trowPanel.add(createTextArea(\"spany,grow\", 5, 20), \"spany,grow\");\n\t\trowPanel.add(createLabel(\"Phone\"));\n\t\trowPanel.add(createTextField(\"growx\"), \"growx\");\n\t\trowPanel.add(createLabel(\"Fax\"));\n\t\trowPanel.add(createTextField(\"growx\"), \"growx\");\n\n\t\ttabbedPane.addTab(\"Column Span/Split\", colPanel);\n\t\ttabbedPane.addTab(\"Row Span\", rowPanel);");
        return tabbedPane;
    }

    public JComponent createGrowing() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout allLM = new MigLayout("", "[pref!][grow,fill]", "[]15[]");
        JPanel allTab = this.createTabPanel(allLM);
        allTab.add(this.createLabel("Fixed"));
        allTab.add((Component)this.createLabel("Gets all extra space"), "wrap");
        allTab.add(this.createTextField(5));
        allTab.add(this.createTextField(5));
        MigLayout halfLM = new MigLayout("", "[pref!][grow,fill]", "[]15[]");
        JPanel halfTab = this.createTabPanel(halfLM);
        halfTab.add(this.createLabel("Fixed"));
        halfTab.add(this.createLabel("Gets half of extra space"));
        halfTab.add((Component)this.createLabel("Gets half of extra space"), "wrap");
        halfTab.add(this.createTextField(5));
        halfTab.add(this.createTextField(5));
        halfTab.add(this.createTextField(5));
        MigLayout p1LM = new MigLayout("", "[pref!][0:0,grow 25,fill][0:0,grow 75,fill]", "[]15[]");
        JPanel p1Tab = this.createTabPanel(p1LM);
        p1Tab.add(this.createLabel("Fixed"));
        p1Tab.add((Component)this.createLabel("Gets 25% of extra space"), "");
        p1Tab.add((Component)this.createLabel("Gets 75% of extra space"), "wrap");
        p1Tab.add(this.createTextField(5));
        p1Tab.add(this.createTextField(5));
        p1Tab.add(this.createTextField(5));
        MigLayout p2LM = new MigLayout("", "[0:0,grow 33,fill][0:0,grow 67,fill]", "[]15[]");
        JPanel p2Tab = this.createTabPanel(p2LM);
        p2Tab.add((Component)this.createLabel("Gets 33% of extra space"), "");
        p2Tab.add((Component)this.createLabel("Gets 67% of extra space"), "wrap");
        p2Tab.add(this.createTextField(5));
        p2Tab.add(this.createTextField(5));
        MigLayout v1LM = new MigLayout("flowy", "[]15[]", "[][c,pref!][c,grow 25,fill][c,grow 75,fill]");
        JPanel v1Tab = this.createTabPanel(v1LM);
        v1Tab.add((Component)this.createLabel("Fixed"), "skip");
        v1Tab.add(this.createLabel("Gets 25% of extra space"));
        v1Tab.add((Component)this.createLabel("Gets 75% of extra space"), "wrap");
        v1Tab.add(this.createLabel("new JTextArea(4, 30)"));
        v1Tab.add(this.createTextAreaScroll("", 4, 30, false));
        v1Tab.add(this.createTextAreaScroll("", 4, 30, false));
        v1Tab.add(this.createTextAreaScroll("", 4, 30, false));
        MigLayout v2LM = new MigLayout("flowy", "[]15[]", "[][c,grow 33,fill][c,grow 67,fill]");
        JPanel v2Tab = this.createTabPanel(v2LM);
        v2Tab.add((Component)this.createLabel("Gets 33% of extra space"), "skip");
        v2Tab.add((Component)this.createLabel("Gets 67% of extra space"), "wrap");
        v2Tab.add(this.createLabel("new JTextArea(4, 30)"));
        v2Tab.add(this.createTextAreaScroll("", 4, 30, false));
        v2Tab.add(this.createTextAreaScroll("", 4, 30, false));
        tabbedPane.addTab("All", allTab);
        tabbedPane.addTab("Half", halfTab);
        tabbedPane.addTab("Percent 1", p1Tab);
        tabbedPane.addTab("Percent 2", p2Tab);
        tabbedPane.addTab("Vertical 1", v1Tab);
        tabbedPane.addTab("Vertical 2", v2Tab);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// All tab\nMigLayout allLM = new MigLayout(\"\",\n                                \"[pref!][grow,fill]\",\n                                \"[]15[]\");\nJPanel allTab = createTabPanel(allLM);\nallTab.add(createLabel(\"Fixed\"));\nallTab.add(createLabel(\"Gets all extra space\"), \"wrap\");\nallTab.add(createTextField(5));\nallTab.add(createTextField(5));\n\n// Half tab\nMigLayout halfLM = new MigLayout(\"\",\n                                 \"[pref!][grow,fill]\",\n                                 \"[]15[]\");\nJPanel halfTab = createTabPanel(halfLM);\nhalfTab.add(createLabel(\"Fixed\"));\nhalfTab.add(createLabel(\"Gets half of extra space\"));\nhalfTab.add(createLabel(\"Gets half of extra space\"), \"wrap\");\nhalfTab.add(createTextField(5));\nhalfTab.add(createTextField(5));\nhalfTab.add(createTextField(5));\n\n// Percent 1 tab\nMigLayout p1LM = new MigLayout(\"\",\n                               \"[pref!][0:0,grow 25,fill][0:0,grow 75,fill]\",\n                               \"[]15[]\");\nJPanel p1Tab = createTabPanel(p1LM);\np1Tab.add(createLabel(\"Fixed\"));\np1Tab.add(createLabel(\"Gets 25% of extra space\"), \"\");\np1Tab.add(createLabel(\"Gets 75% of extra space\"), \"wrap\");\np1Tab.add(createTextField(5));\np1Tab.add(createTextField(5));\np1Tab.add(createTextField(5));\n\n// Percent 2 tab\nMigLayout p2LM = new MigLayout(\"\",\n                               \"[0:0,grow 33,fill][0:0,grow 67,fill]\",\n                               \"[]15[]\");\nJPanel p2Tab = createTabPanel(p2LM);\np2Tab.add(createLabel(\"Gets 33% of extra space\"), \"\");\np2Tab.add(createLabel(\"Gets 67% of extra space\"), \"wrap\");\np2Tab.add(createTextField(5));\np2Tab.add(createTextField(5));\n\n// Vertical 1 tab\nMigLayout v1LM = new MigLayout(\"flowy\",\n                               \"[]15[]\",\n                               \"[][c,pref!][c,grow 25,fill][c,grow 75,fill]\");\nJPanel v1Tab = createTabPanel(v1LM);\nv1Tab.add(createLabel(\"Fixed\"), \"skip\");\nv1Tab.add(createLabel(\"Gets 25% of extra space\"));\nv1Tab.add(createLabel(\"Gets 75% of extra space\"), \"wrap\");\nv1Tab.add(createLabel(\"new JTextArea(4, 30)\"));\nv1Tab.add(createTextAreaScroll(\"\", 4, 30, false));\nv1Tab.add(createTextAreaScroll(\"\", 4, 30, false));\nv1Tab.add(createTextAreaScroll(\"\", 4, 30, false));\n\n// Vertical 2 tab\nMigLayout v2LM = new MigLayout(\"flowy\",\n                               \"[]15[]\",\n                               \"[][c,grow 33,fill][c,grow 67,fill]\");\nJPanel v2Tab = createTabPanel(v2LM);\nv2Tab.add(createLabel(\"Gets 33% of extra space\"), \"skip\");\nv2Tab.add(createLabel(\"Gets 67% of extra space\"), \"wrap\");\nv2Tab.add(createLabel(\"new JTextArea(4, 30)\"));\nv2Tab.add(createTextAreaScroll(\"\", 4, 30, false));\nv2Tab.add(createTextAreaScroll(\"\", 4, 30, false));\n\ntabbedPane.addTab(\"All\", allTab);\ntabbedPane.addTab(\"Half\", halfTab);\ntabbedPane.addTab(\"Percent 1\", p1Tab);\ntabbedPane.addTab(\"Percent 2\", p2Tab);\ntabbedPane.addTab(\"Vertical 1\", v1Tab);\ntabbedPane.addTab(\"Vertical 2\", v2Tab);");
        return tabbedPane;
    }

    public JComponent createBasic_Sizes() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout horLM = new MigLayout("", "[]15[75px]25[min]25[]", "[]15");
        JPanel horTab = this.createTabPanel(horLM);
        horTab.add((Component)this.createLabel("75px"), "skip");
        horTab.add(this.createLabel("Min"));
        horTab.add((Component)this.createLabel("Pref"), "wrap");
        horTab.add(this.createLabel("new TextField(15)"));
        horTab.add(this.createTextField(15));
        horTab.add(this.createTextField(15));
        horTab.add(this.createTextField(15));
        MigLayout verLM = new MigLayout("flowy,wrap", "[]15[]", "[]15[c,45px]15[c,min]15[c,pref]");
        JPanel verTab = this.createTabPanel(verLM);
        verTab.add((Component)this.createLabel("45px"), "skip");
        verTab.add(this.createLabel("Min"));
        verTab.add(this.createLabel("Pref"));
        verTab.add(this.createLabel("new JTextArea(10, 40)"));
        verTab.add(this.createTextArea("", 10, 40));
        verTab.add(this.createTextArea("", 10, 40));
        verTab.add(this.createTextArea("", 10, 40));
        MigLayout verLM2 = new MigLayout("flowy,wrap", "[]15[]", "[]15[baseline]15[baseline]15[baseline]");
        JPanel verTab2 = this.createTabPanel(verLM2);
        verTab2.add((Component)this.createLabel("45px"), "skip");
        verTab2.add(this.createLabel("Min"));
        verTab2.add(this.createLabel("Pref"));
        verTab2.add(this.createLabel("new JTextArea(10, 40)"));
        verTab2.add((Component)this.createTextArea("", 10, 40), "height 45");
        verTab2.add((Component)this.createTextArea("", 10, 40), "height min");
        verTab2.add((Component)this.createTextArea("", 10, 40), "height pref");
        tabbedPane.addTab("Horizontal - Column size set", horTab);
        tabbedPane.addTab("Vertical - Row sized", verTab);
        tabbedPane.addTab("Vertical - Component sized + Baseline", verTab2);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// Horizontal tab\nMigLayout horLM = new MigLayout(\"\",\n                                     \"[]15[75px]25[min]25[]\",\n                                     \"[]15\");\nJPanel horTab = createTabPanel(horLM);\nhorTab.add(createLabel(\"75px\"), \"skip\");\nhorTab.add(createLabel(\"Min\"));\nhorTab.add(createLabel(\"Pref\"), \"wrap\");\n\nhorTab.add(createLabel(\"new TextField(15)\"));\nhorTab.add(createTextField(15));\nhorTab.add(createTextField(15));\nhorTab.add(createTextField(15));\n\n// Vertical tab 1\nMigLayout verLM = new MigLayout(\"flowy,wrap\",\n                                     \"[]15[]\",\n                                     \"[]15[c,45px]15[c,min]15[c,pref]\");\nJPanel verTab = createTabPanel(verLM);\nverTab.add(createLabel(\"45px\"), \"skip\");\nverTab.add(createLabel(\"Min\"));\nverTab.add(createLabel(\"Pref\"));\n\nverTab.add(createLabel(\"new JTextArea(10, 40)\"));\nverTab.add(createTextArea(\"\", 10, 40));\nverTab.add(createTextArea(\"\", 10, 40));\nverTab.add(createTextArea(\"\", 10, 40));\n\n// Componentsized/Baseline 2\nMigLayout verLM2 = new MigLayout(\"flowy,wrap\",\n                                 \"[]15[]\",\n                                 \"[]15[baseline]15[baseline]15[baseline]\");\nJPanel verTab2 = createTabPanel(verLM2);\nverTab2.add(createLabel(\"45px\"), \"skip\");\nverTab2.add(createLabel(\"Min\"));\nverTab2.add(createLabel(\"Pref\"));\n\nverTab2.add(createLabel(\"new JTextArea(10, 40)\"));\nverTab2.add(createTextArea(\"\", 10, 40), \"height 45\");\nverTab2.add(createTextArea(\"\", 10, 40), \"height min\");\nverTab2.add(createTextArea(\"\", 10, 40), \"height pref\");\n\ntabbedPane.addTab(\"Horizontal - Column size set\", horTab);\ntabbedPane.addTab(\"Vertical - Row sized\", verTab);\ntabbedPane.addTab(\"Vertical - Component sized + Baseline\", verTab2);");
        return tabbedPane;
    }

    public JComponent createAlignments() {
        int c;
        String[] stringArray;
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout horLM = new MigLayout("wrap", "[label]15[left]15[center]15[right]15[fill]15[]", "[]15[]");
        String[] horLabels = new String[]{"[label]", "[left]", "[center]", "[right]", "[fill]", "[] (Default)"};
        JPanel horTab = this.createTabPanel(horLM);
        String[] horNames = new String[]{"First Name", "Phone Number", "Facsmile", "Email", "Address", "Other"};
        for (int c2 = 0; c2 < horLabels.length; ++c2) {
            horTab.add(this.createLabel(horLabels[c2]));
        }
        for (int r = 0; r < horLabels.length; ++r) {
            for (int c3 = 0; c3 < horNames.length; ++c3) {
                horTab.add(c3 == 0 ? this.createLabel(horNames[r] + ":") : this.createButton(horNames[r]));
            }
        }
        MigLayout verLM = new MigLayout("wrap,flowy", "[]unrel[]rel[]", "[top]15[center]15[bottom]15[fill]15[fill,baseline]15[baseline]15[]");
        String[] verLabels = new String[]{"[top]", "[center]", "[bottom]", "[fill]", "[fill,baseline]", "[baseline]", "[] (Default)"};
        JPanel verTab = this.createTabPanel(verLM);
        if (benchRuns == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "<html>One</html>";
            stringArray = stringArray2;
            stringArray2[1] = "<html>One<br>Two</html>";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "One";
            stringArray = stringArray3;
            stringArray3[1] = "One/Two";
        }
        String[] verNames = stringArray;
        for (c = 0; c < verLabels.length; ++c) {
            verTab.add(this.createLabel(verLabels[c]));
        }
        for (int r = 0; r < verNames.length; ++r) {
            for (int c4 = 0; c4 < verLabels.length; ++c4) {
                verTab.add(this.createButton(verNames[r]));
            }
        }
        for (c = 0; c < verLabels.length; ++c) {
            verTab.add(this.createTextField("JTextFied"));
        }
        for (c = 0; c < verLabels.length; ++c) {
            verTab.add(this.createTextArea("JTextArea", 1, 8));
        }
        for (c = 0; c < verLabels.length; ++c) {
            verTab.add(this.createTextArea("JTextArea\nwith two lines", 1, 10));
        }
        for (c = 0; c < verLabels.length; ++c) {
            verTab.add(this.createTextAreaScroll("Scrolling JTextArea\nwith two lines", 1, 15, true));
        }
        tabbedPane.addTab("Horizontal", horTab);
        tabbedPane.addTab("Vertical", verTab);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// Horizontal tab\nMigLayout horLM = new MigLayout(\"wrap\",\n                                     \"[left]15[center]15[right]15[fill]15[]\",\n                                     \"rel[]rel\");\n\nString[] horLabels = new String[] {\"[left]\", \"[center]\", \"[right]\", \"[fill]\", \"[] (Default)\"};\nJPanel horTab = createTabPanel(horLM);\nString[] horNames = new String[] {\"First Name\", \"Phone Number\", \"Facsmile\", \"Email\", \"Address\"};\nfor (int c = 0; c < horLabels.length; c++)\n\thorTab.add(createLabel(horLabels[c]));\n\nfor (int r = 0; r < horLabels.length; r++) {\n\tfor (int c = 0; c < horNames.length; c++)\n\t\thorTab.add(createButton(horNames[r]));\n}\n\n// Vertical tab\nMigLayout verLM = new MigLayout(\"wrap,flowy\",\n                                \"[]unrel[]rel[]\",\n                                \"[top]15[center]15[bottom]15[fill]15[fill,baseline]15[baseline]15[]\");\n\nString[] verLabels = new String[] {\"[top]\", \"[center]\", \"[bottom]\", \"[fill]\", \"[fill,baseline]\", \"[baseline]\", \"[] (Default)\"};\nJPanel verTab = createTabPanel(verLM);\n\nString[] verNames = new String[] {\"<html>One</html>\", \"<html>One<br>Two</html>\"};\nfor (int c = 0; c < verLabels.length; c++)\n\tverTab.add(createLabel(verLabels[c]));\n\nfor (int r = 0; r < verNames.length; r++) {\n\tfor (int c = 0; c < verLabels.length; c++)\n\t\tverTab.add(createButton(verNames[r]));\n}\n\nfor (int c = 0; c < verLabels.length; c++)\n\tverTab.add(createTextField(\"JTextFied\"));\n\nfor (int c = 0; c < verLabels.length; c++)\n\tverTab.add(createTextArea(\"JTextArea\", 1, 8));\n\nfor (int c = 0; c < verLabels.length; c++)\n\tverTab.add(createTextArea(\"JTextArea\\nwith two lines\", 1, 10));\n\nfor (int c = 0; c < verLabels.length; c++)\n\tverTab.add(createTextAreaScroll(\"Scrolling JTextArea\\nwith two lines\", 1, 15, true));\n\ntabbedPane.addTab(\"Horizontal\", horTab);\ntabbedPane.addTab(\"Vertical\", verTab);");
        return tabbedPane;
    }

    public JComponent createQuick_Start() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel p = this.createTabPanel(new MigLayout("inset 20"));
        this.addSeparator(p, "General");
        p.add((Component)this.createLabel("Company"), "gap para");
        p.add((Component)this.createTextField(""), "span, growx");
        p.add((Component)this.createLabel("Contact"), "gap para");
        p.add((Component)this.createTextField(""), "span, growx, wrap para");
        this.addSeparator(p, "Propeller");
        p.add((Component)this.createLabel("PTI/kW"), "gap para");
        p.add(this.createTextField(10));
        p.add((Component)this.createLabel("Power/kW"), "gap para");
        p.add((Component)this.createTextField(10), "wrap");
        p.add((Component)this.createLabel("R/mm"), "gap para");
        p.add(this.createTextField(10));
        p.add((Component)this.createLabel("D/mm"), "gap para");
        p.add(this.createTextField(10));
        tabbedPane.addTab("Quick Start", p);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\nJPanel p = createTabPanel(new MigLayout());\n\naddSeparator(p, \"General\");\n\np.add(createLabel(\"Company\"), \"gap para\");\np.add(createTextField(\"\"),    \"span, growx, wrap\");\np.add(createLabel(\"Contact\"), \"gap para\");\np.add(createTextField(\"\"),    \"span, growx, wrap para\");\n\naddSeparator(p, \"Propeller\");\n\np.add(createLabel(\"PTI/kW\"),  \"gap para\");\np.add(createTextField(10));\np.add(createLabel(\"Power/kW\"),\"gap para\");\np.add(createTextField(10),    \"wrap\");\np.add(createLabel(\"R/mm\"),    \"gap para\");\np.add(createTextField(10));\np.add(createLabel(\"D/mm\"),    \"gap para\");\np.add(createTextField(10));\n\ntabbedPane.addTab(\"Quick Start\", p);");
        return tabbedPane;
    }

    public JComponent createGrow_Shrink() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout slm = new MigLayout("nogrid");
        JPanel sPanel = this.createTabPanel(slm);
        JScrollPane sDescrText = this.createTextAreaScroll("Use the slider to see how the components shrink depending on the constraints set on them.\n\n'shp' means Shrink Priority. Lower values will be shrunk before higer ones and the default value is 100.\n\n'shrink' means Shrink Weight. Lower values relative to other's means they will shrink less when space is scarse. Shrink Weight is only relative to components with the same Shrink Priority. Default Shrink Weight is 100.\n\nThe component's minimum size will always be honored.", 0, 0, true);
        sDescrText.setOpaque(false);
        sDescrText.setBorder(new EmptyBorder(10, 10, 10, 10));
        ((JTextArea)sDescrText.getViewport().getView()).setOpaque(false);
        sDescrText.getViewport().setOpaque(false);
        JSplitPane sSplitPane = new JSplitPane(1, true, sPanel, sDescrText);
        sSplitPane.setOpaque(false);
        sSplitPane.setBorder(null);
        sPanel.add((Component)this.createTextField("shp 110", 12), "shp 110");
        sPanel.add((Component)this.createTextField("Default (100)", 12), "");
        sPanel.add((Component)this.createTextField("shp 90", 12), "shp 90");
        sPanel.add((Component)this.createTextField("shrink 25", 20), "newline,shrink 25");
        sPanel.add((Component)this.createTextField("shrink 75", 20), "shrink 75");
        sPanel.add((Component)this.createTextField("Default", 20), "newline");
        sPanel.add((Component)this.createTextField("Default", 20), "");
        sPanel.add((Component)this.createTextField("shrink 0", 40), "newline,shrink 0");
        sPanel.add((Component)this.createTextField("shp 110", 12), "newline,shp 110");
        sPanel.add((Component)this.createTextField("shp 100,shrink 25", 12), "shp 100,shrink 25");
        sPanel.add((Component)this.createTextField("shp 100,shrink 75", 12), "shp 100,shrink 75");
        tabbedPane.addTab("Shrink", sSplitPane);
        MigLayout glm = new MigLayout("nogrid", "[grow]", "");
        JPanel gPanel = this.createTabPanel(glm);
        JScrollPane gDescrText = this.createTextAreaScroll("'gp' means Grow Priority. Higher values will be grown before lower ones and the default value is 100.\n\n'grow' means Grow Weight. Higher values relative to other's means they will grow more when space is up for takes. Grow Weight is only relative to components with the same Grow Priority. Default Grow Weight is 0 which means components will normally not grow. \n\nNote that the buttons in the first and last row have max width set to 170 to emphasize Grow Priority.\n\nThe component's maximum size will always be honored.", 0, 0, true);
        gDescrText.setOpaque(false);
        gDescrText.setBorder(new EmptyBorder(10, 10, 10, 10));
        ((JTextArea)gDescrText.getViewport().getView()).setOpaque(false);
        gDescrText.getViewport().setOpaque(false);
        JSplitPane gSplitPane = new JSplitPane(1, true, gPanel, gDescrText);
        gSplitPane.setOpaque(false);
        gSplitPane.setBorder(null);
        gPanel.add((Component)this.createButton("gp 110,grow"), "gp 110,grow,wmax 170");
        gPanel.add((Component)this.createButton("Default (100),grow"), "grow,wmax 170");
        gPanel.add((Component)this.createButton("gp 90,grow"), "gp 90,grow,wmax 170");
        gPanel.add((Component)this.createButton("Default Button"), "newline");
        gPanel.add((Component)this.createButton("growx"), "newline,growx,wrap");
        gPanel.add((Component)this.createButton("gp 110,grow"), "gp 110,grow,wmax 170");
        gPanel.add((Component)this.createButton("gp 100,grow 25"), "gp 100,grow 25,wmax 170");
        gPanel.add((Component)this.createButton("gp 100,grow 75"), "gp 100,grow 75,wmax 170");
        tabbedPane.addTab("Grow", gSplitPane);
        this.setSource("JTabbedPane tabbedPane = new JTabbedPane();\n\n// shrink tab\nMigLayout slm = new MigLayout(\"nogrid\");\nJPanel sPanel = createTabPanel(slm);\n\nJScrollPane sDescrText = createTextAreaScroll(\"Use the slider to see how the components shrink depending on the constraints set on them.\\n\\n'shp' means Shrink Priority. \" +\n                                              \"Lower values will be shrunk before higer ones and the default value is 100.\\n\\n'shrink' means Shrink Weight. \" +\n                                              \"Lower values relative to other's means they will shrink less when space is scarse. \" +\n                                              \"Shrink Weight is only relative to components with the same Shrink Priority. Default Shrink Weight is 100.\\n\\n\" +\n                                              \"The component's minimum size will always be honored.\", 0, 0, true);\n\nsDescrText.setOpaque(OPAQUE);\nsDescrText.setBorder(new EmptyBorder(10, 10, 10, 10));\n((JTextArea) sDescrText.getViewport().getView()).setOpaque(OPAQUE);\nsDescrText.getViewport().setOpaque(OPAQUE);\n\nJSplitPane sSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, sPanel, sDescrText);\nsSplitPane.setOpaque(OPAQUE);\nsSplitPane.setBorder(null);\n\nsPanel.add(createTextField(\"shp 110\", 12), \"shp 110\");\nsPanel.add(createTextField(\"Default (100)\", 12), \"\");\nsPanel.add(createTextField(\"shp 90\", 12), \"shp 90\");\n\nsPanel.add(createTextField(\"shrink 25\", 20), \"newline,shrink 25\");\nsPanel.add(createTextField(\"shrink 75\", 20), \"shrink 75\");\n\nsPanel.add(createTextField(\"Default\", 20), \"newline\");\nsPanel.add(createTextField(\"Default\", 20), \"\");\n\nsPanel.add(createTextField(\"shrink 0\", 40), \"newline,shrink 0\");\n\nsPanel.add(createTextField(\"shp 110\", 12), \"newline,shp 110\");\nsPanel.add(createTextField(\"shp 100,shrink 25\", 12), \"shp 100,shrink 25\");\nsPanel.add(createTextField(\"shp 100,shrink 75\", 12), \"shp 100,shrink 75\");\ntabbedPane.addTab(\"Shrink\", sSplitPane);\n\n// Grow tab\nMigLayout glm = new MigLayout(\"nogrid\", \"[grow]\", \"\");\nJPanel gPanel = createTabPanel(glm);\n\nJScrollPane gDescrText = createTextAreaScroll(\"'gp' means Grow Priority. \" +\n                                              \"Higher values will be grown before lower ones and the default value is 100.\\n\\n'grow' means Grow Weight. \" +\n                                              \"Higher values relative to other's means they will grow more when space is up for takes. \" +\n                                              \"Grow Weight is only relative to components with the same Grow Priority. Default Grow Weight is 0 which means \" +\n                                              \"components will normally not grow. \\n\\nNote that the buttons in the first and last row have max width set to 170 to \" +\n                                              \"emphasize Grow Priority.\\n\\nThe component's maximum size will always be honored.\", 0, 0, true);\n\ngDescrText.setOpaque(OPAQUE);\ngDescrText.setBorder(new EmptyBorder(10, 10, 10, 10));\n((JTextArea) gDescrText.getViewport().getView()).setOpaque(OPAQUE);\ngDescrText.getViewport().setOpaque(OPAQUE);\n\nJSplitPane gSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, gPanel, gDescrText);\ngSplitPane.setOpaque(OPAQUE);\ngSplitPane.setBorder(null);\n\ngPanel.add(createButton(\"gp 110,grow\"), \"gp 110,grow,wmax 170\");\ngPanel.add(createButton(\"Default (100),grow\"), \"grow,wmax 170\");\ngPanel.add(createButton(\"gp 90,grow\"), \"gp 90,grow,wmax 170\");\n\ngPanel.add(createButton(\"Default Button\"), \"newline\");\n\ngPanel.add(createButton(\"growx\"), \"newline,growx,wrap\");\n\ngPanel.add(createButton(\"gp 110,grow\"), \"gp 110,grow,wmax 170\");\ngPanel.add(createButton(\"gp 100,grow 25\"), \"gp 100,grow 25,wmax 170\");\ngPanel.add(createButton(\"gp 100,grow 75\"), \"gp 100,grow 75,wmax 170\");\ntabbedPane.addTab(\"Grow\", gSplitPane);");
        return tabbedPane;
    }

    public JComponent createPlainApi() {
        JTabbedPane tabbedPane = new JTabbedPane();
        MigLayout lm = new MigLayout(new LC(), null, null);
        JPanel panel = this.createTabPanel(lm);
        this.addSeparator(panel, "Manufacturer");
        panel.add(this.createLabel("Company"));
        panel.add((Component)this.createTextField(""), "span,growx");
        panel.add(this.createLabel("Contact"));
        panel.add((Component)this.createTextField(""), "span,growx");
        panel.add(this.createLabel("Order No"));
        panel.add((Component)this.createTextField(15), "wrap");
        this.addSeparator(panel, "Inspector");
        panel.add(this.createLabel("Name"));
        panel.add((Component)this.createTextField(""), "span,growx");
        panel.add(this.createLabel("Reference No"));
        panel.add((Component)this.createTextField(""), "wrap");
        panel.add(this.createLabel("Status"));
        panel.add((Component)this.createCombo(new String[]{"In Progress", "Finnished", "Released"}), "wrap");
        this.addSeparator(panel, "Ship");
        panel.add(this.createLabel("Shipyard"));
        panel.add((Component)this.createTextField(""), "span,growx");
        panel.add(this.createLabel("Register No"));
        panel.add(this.createTextField(""));
        panel.add((Component)this.createLabel("Hull No"), "right");
        panel.add((Component)this.createTextField(15), "wrap");
        panel.add(this.createLabel("Project StructureType"));
        panel.add(this.createCombo(new String[]{"New Building", "Convention", "Repair"}));
        tabbedPane.addTab("Plain", panel);
        return tabbedPane;
    }

    private JLabel createLabel(String text) {
        return this.createLabel(text, 10);
    }

    private JLabel createLabel(String text, int align) {
        JLabel b = new JLabel(text, align);
        this.configureActiveComponet(b);
        return b;
    }

    public JComboBox createCombo(String[] items) {
        JComboBox<String> combo = new JComboBox<String>(items);
        if (PlatformDefaults.getCurrentPlatform() == 1) {
            combo.setOpaque(false);
        }
        return combo;
    }

    private JTextField createTextField(int cols) {
        return this.createTextField("", cols);
    }

    private JTextField createTextField(String text) {
        return this.createTextField(text, 0);
    }

    private JTextField createTextField(String text, int cols) {
        JTextField b = new JTextField(text, cols);
        this.configureActiveComponet(b);
        return b;
    }

    private JButton createButton() {
        return this.createButton("");
    }

    private JButton createButton(String text) {
        return this.createButton(text, false);
    }

    private JButton createButton(String text, boolean bold) {
        JButton b = new JButton(text){

            public void addNotify() {
                super.addNotify();
                if (benchRuns == 0) {
                    if (this.getText().length() == 0) {
                        String lText = (String)((MigLayout)this.getParent().getLayout()).getComponentConstraints(this);
                        this.setText(lText != null && lText.length() > 0 ? lText : "<Empty>");
                    }
                } else {
                    this.setText("Benchmark Version");
                }
            }
        };
        if (bold) {
            b.setFont(b.getFont().deriveFont(1));
        }
        this.configureActiveComponet(b);
        b.setOpaque(buttonOpaque);
        b.setContentAreaFilled(contentAreaFilled);
        return b;
    }

    private JToggleButton createToggleButton(String text) {
        JToggleButton b = new JToggleButton(text);
        b.setOpaque(buttonOpaque);
        return b;
    }

    private JCheckBox createCheck(String text) {
        JCheckBox b = new JCheckBox(text);
        this.configureActiveComponet(b);
        b.setOpaque(false);
        return b;
    }

    private JPanel createTabPanel(LayoutManager lm) {
        JPanel panel = new JPanel(lm);
        this.configureActiveComponet(panel);
        panel.setOpaque(false);
        return panel;
    }

    private JComponent createPanel() {
        return this.createPanel("");
    }

    private JComponent createPanel(String s) {
        JLabel panel = new JLabel(s, 0){

            public void addNotify() {
                super.addNotify();
                if (benchRuns == 0 && this.getText().length() == 0) {
                    String lText = (String)((MigLayout)this.getParent().getLayout()).getComponentConstraints(this);
                    this.setText(lText != null && lText.length() > 0 ? lText : "<Empty>");
                }
            }
        };
        panel.setBorder(new EtchedBorder());
        panel.setOpaque(true);
        this.configureActiveComponet(panel);
        return panel;
    }

    private JTextArea createTextArea(String text, int rows, int cols) {
        JTextArea ta = new JTextArea(text, rows, cols);
        ta.setBorder(UIManager.getBorder("TextField.border"));
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        this.configureActiveComponet(ta);
        return ta;
    }

    private JScrollPane createTextAreaScroll(String text, int rows, int cols, boolean hasVerScroll) {
        JTextArea ta = new JTextArea(text, rows, cols);
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(ta, hasVerScroll ? 20 : 21, 31);
        return scroll;
    }

    private JComponent configureActiveComponet(JComponent c) {
        if (benchRuns == 0) {
            c.addMouseMotionListener(this.toolTipListener);
            c.addMouseListener(this.constraintListener);
        }
        return c;
    }

    private void addSeparator(JPanel panel, String text) {
        JLabel l = this.createLabel(text);
        l.setForeground(LABEL_COLOR);
        panel.add((Component)l, "gapbottom 1, span, split 2, aligny center");
        panel.add((Component)this.configureActiveComponet(new JSeparator()), "gapleft rel, growx");
    }

    private static class ConstraintsDialog
    extends JDialog
    implements ActionListener,
    KeyEventDispatcher {
        private static final Color ERROR_COLOR = new Color(255, 180, 180);
        private final JPanel mainPanel = new JPanel(new MigLayout("fillx,flowy,ins dialog", "[fill]", "2[]2"));
        final JTextField layoutConstrTF;
        final JTextField rowsConstrTF;
        final JTextField colsConstrTF;
        final JTextField componentConstrTF;
        private final JButton okButt = new JButton("OK");
        private final JButton cancelButt = new JButton("Cancel");
        private boolean okPressed = false;

        public ConstraintsDialog(Frame owner, String layoutConstr, String rowsConstr, String colsConstr, String compConstr) {
            super(owner, compConstr != null ? "Edit Component Constraints" : "Edit Container Constraints", true);
            this.layoutConstrTF = this.createConstraintField(layoutConstr);
            this.rowsConstrTF = this.createConstraintField(rowsConstr);
            this.colsConstrTF = this.createConstraintField(colsConstr);
            this.componentConstrTF = this.createConstraintField(compConstr);
            if (this.componentConstrTF != null) {
                this.mainPanel.add(new JLabel("Component Constraints"));
                this.mainPanel.add(this.componentConstrTF);
            }
            if (this.layoutConstrTF != null) {
                this.mainPanel.add(new JLabel("Layout Constraints"));
                this.mainPanel.add(this.layoutConstrTF);
            }
            if (this.colsConstrTF != null) {
                this.mainPanel.add((Component)new JLabel("Column Constraints"), "gaptop unrel");
                this.mainPanel.add(this.colsConstrTF);
            }
            if (this.rowsConstrTF != null) {
                this.mainPanel.add((Component)new JLabel("Row Constraints"), "gaptop unrel");
                this.mainPanel.add(this.rowsConstrTF);
            }
            this.mainPanel.add((Component)this.okButt, "tag ok,split,flowx,gaptop 15");
            this.mainPanel.add((Component)this.cancelButt, "tag cancel,gaptop 15");
            this.setContentPane(this.mainPanel);
            this.okButt.addActionListener(this);
            this.cancelButt.addActionListener(this);
        }

        public void addNotify() {
            super.addNotify();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }

        public void removeNotify() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            super.removeNotify();
        }

        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                this.dispose();
            }
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButt) {
                this.okPressed = true;
            }
            this.dispose();
        }

        private JTextField createConstraintField(String text) {
            if (text == null) {
                return null;
            }
            final JTextField tf = new JTextField(text, 50);
            tf.setFont(new Font("monospaced", 0, 12));
            tf.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ConstraintsDialog.this.okButt.doClick();
                        return;
                    }
                    Timer timer = new Timer(50, new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            String constr = tf.getText();
                            try {
                                if (tf == ConstraintsDialog.this.layoutConstrTF) {
                                    ConstraintParser.parseLayoutConstraint(constr);
                                } else if (tf == ConstraintsDialog.this.rowsConstrTF) {
                                    ConstraintParser.parseRowConstraints(constr);
                                } else if (tf == ConstraintsDialog.this.colsConstrTF) {
                                    ConstraintParser.parseColumnConstraints(constr);
                                } else if (tf == ConstraintsDialog.this.componentConstrTF) {
                                    ConstraintParser.parseComponentConstraint(constr);
                                }
                                tf.setBackground(Color.WHITE);
                                ConstraintsDialog.this.okButt.setEnabled(true);
                            }
                            catch (Exception ex) {
                                tf.setBackground(ERROR_COLOR);
                                ConstraintsDialog.this.okButt.setEnabled(false);
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            });
            return tf;
        }

        private boolean showDialog() {
            this.setVisible(true);
            return this.okPressed;
        }
    }

    private static class ToolTipListener
    extends MouseMotionAdapter {
        private ToolTipListener() {
        }

        public void mouseMoved(MouseEvent e) {
            Object constr;
            JComponent c = (JComponent)e.getSource();
            LayoutManager lm = c.getParent().getLayout();
            if (lm instanceof MigLayout && (constr = ((MigLayout)lm).getComponentConstraints(c)) instanceof String) {
                c.setToolTipText(constr != null ? "\"" + constr + "\"" : "null");
            }
        }
    }

    private class ConstraintListener
    extends MouseAdapter {
        private ConstraintListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.react(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.react(e);
            }
        }

        public void react(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            LayoutManager lm = c.getParent().getLayout();
            if (!(lm instanceof MigLayout)) {
                lm = c.getLayout();
            }
            if (lm instanceof MigLayout) {
                Object compConstr;
                MigLayout layout = (MigLayout)lm;
                boolean isComp = layout.isManagingComponent(c);
                Object object = compConstr = isComp ? layout.getComponentConstraints(c) : null;
                if (isComp && compConstr == null) {
                    compConstr = "";
                }
                Object rowsConstr = isComp ? null : layout.getRowConstraints();
                Object colsConstr = isComp ? null : layout.getColumnConstraints();
                Object layoutConstr = isComp ? null : layout.getLayoutConstraints();
                ConstraintsDialog cDlg = new ConstraintsDialog(SwingDemo.this, layoutConstr instanceof LC ? IDEUtil.getConstraintString((LC)layoutConstr, false) : (String)layoutConstr, rowsConstr instanceof AC ? IDEUtil.getConstraintString((AC)rowsConstr, false, false) : (String)rowsConstr, colsConstr instanceof AC ? IDEUtil.getConstraintString((AC)colsConstr, false, false) : (String)colsConstr, compConstr instanceof CC ? IDEUtil.getConstraintString((CC)compConstr, false) : (String)compConstr);
                cDlg.pack();
                cDlg.setLocationRelativeTo(c);
                if (cDlg.showDialog()) {
                    try {
                        if (isComp) {
                            String constrStr = cDlg.componentConstrTF.getText().trim();
                            layout.setComponentConstraints(c, constrStr);
                            if (c instanceof JButton) {
                                c.setFont(BUTT_FONT);
                                ((JButton)c).setText(constrStr.length() == 0 ? "<Empty>" : constrStr);
                            }
                        } else {
                            layout.setLayoutConstraints(cDlg.layoutConstrTF.getText());
                            layout.setRowConstraints(cDlg.rowsConstrTF.getText());
                            layout.setColumnConstraints(cDlg.colsConstrTF.getText());
                        }
                    }
                    catch (Exception ex) {
                        StringWriter sw = new StringWriter();
                        ex.printStackTrace(new PrintWriter(sw));
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(c), sw.toString(), "Error parsing Constraint!", 0);
                        return;
                    }
                    c.invalidate();
                    c.getParent().validate();
                }
            }
        }
    }
}

