/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.PWDClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PWDClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PWDClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class PWDClientKeyExchangeHandler
extends ClientKeyExchangeHandler<PWDClientKeyExchangeMessage> {
    public PWDClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public PWDClientKeyExchangeParser getParser(byte[] message, int pointer) {
        return new PWDClientKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), AlgorithmResolver.getKeyExchangeAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite()), this.tlsContext.getConfig());
    }

    public PWDClientKeyExchangePreparator getPreparator(PWDClientKeyExchangeMessage message) {
        return new PWDClientKeyExchangePreparator(this.tlsContext.getChooser(), message);
    }

    public PWDClientKeyExchangeSerializer getSerializer(PWDClientKeyExchangeMessage message) {
        return new PWDClientKeyExchangeSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(PWDClientKeyExchangeMessage message) {
        if (message.getComputations() != null) {
            this.tlsContext.setPWDPE(message.getComputations().getPasswordElement());
            this.tlsContext.setClientPWDPrivate(message.getComputations().getPrivateKeyScalar());
        }
        this.adjustPremasterSecret(message);
        this.adjustMasterSecret(message);
        this.setRecordCipher();
        this.spawnNewSession();
    }
}

