/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.AlertHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class AlertMessage
extends ProtocolMessage {
    private byte[] config;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    ModifiableByte level;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    ModifiableByte description;

    public AlertMessage() {
        this.protocolMessageType = ProtocolMessageType.ALERT;
    }

    public AlertMessage(Config tlsConfig) {
        this.protocolMessageType = ProtocolMessageType.ALERT;
    }

    public ModifiableByte getLevel() {
        return this.level;
    }

    public void setLevel(byte level) {
        this.level = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.level, (Byte)level);
    }

    public void setLevel(ModifiableByte level) {
        this.level = level;
    }

    public ModifiableByte getDescription() {
        return this.description;
    }

    public void setDescription(byte description) {
        this.description = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.description, (Byte)description);
    }

    public void setDescription(ModifiableByte description) {
        this.description = description;
    }

    public byte[] getConfig() {
        return this.config;
    }

    public void setConfig(byte[] config) {
        this.config = config;
    }

    public void setConfig(AlertLevel level, AlertDescription description) {
        this.config = new byte[2];
        this.config[0] = level.getValue();
        this.config[1] = description.getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertMessage:");
        sb.append("\n  Level: ");
        if (this.level != null) {
            if (AlertLevel.getAlertLevel((Byte)this.level.getValue()) == AlertLevel.UNDEFINED) {
                sb.append(this.level.getValue());
            } else {
                sb.append((Object)AlertLevel.getAlertLevel((Byte)this.level.getValue()));
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Description: ");
        if (this.description != null) {
            if (AlertDescription.getAlertDescription((Byte)this.description.getValue()) == null) {
                sb.append(this.description.getValue());
            } else {
                sb.append((Object)AlertDescription.getAlertDescription((Byte)this.description.getValue()));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        AlertDescription desc;
        StringBuilder sb = new StringBuilder();
        String levelString = this.level != null && this.level.getValue() != null ? AlertLevel.getAlertLevel((Byte)this.level.getValue()).name() : "null";
        String descriptionString = this.description != null && this.description.getValue() != null ? ((desc = AlertDescription.getAlertDescription((Byte)this.description.getValue())) != null ? desc.name() : "" + this.description.getValue()) : "null";
        sb.append("Alert(").append(levelString).append(",").append(descriptionString).append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlertMessage)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AlertMessage alert = (AlertMessage)obj;
        return Objects.equals(alert.getLevel().getValue(), this.getLevel().getValue()) && Objects.equals(alert.getDescription().getValue(), this.getDescription().getValue());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.level.getValue());
        hash = 73 * hash + Objects.hashCode(this.description.getValue());
        return hash;
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new AlertHandler(context);
    }
}

