/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDServerKeyExchangeParser
extends ServerKeyExchangeParser<PWDServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion version;
    private final KeyExchangeAlgorithm keyExchangeAlgorithm;

    public PWDServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        this(pointer, array, version, null, config);
    }

    public PWDServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, KeyExchangeAlgorithm keyExchangeAlgorithm, Config config) {
        super(pointer, array, HandshakeMessageType.SERVER_KEY_EXCHANGE, version, config);
        this.version = version;
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
    }

    @Override
    protected PWDServerKeyExchangeMessage createHandshakeMessage() {
        return new PWDServerKeyExchangeMessage();
    }

    @Override
    protected void parseHandshakeMessageContent(PWDServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PWDServerKeyExchangeMessage");
        this.parseSaltLength(msg);
        this.parseSalt(msg);
        this.parseCurveType(msg);
        this.parseNamedGroup(msg);
        this.parseElementLength(msg);
        this.parseElement(msg);
        this.parseScalarLength(msg);
        this.parseScalar(msg);
    }

    private void parseSaltLength(PWDServerKeyExchangeMessage msg) {
        msg.setSaltLength(this.parseIntField(1));
        LOGGER.debug("SaltLength: " + msg.getSaltLength().getValue());
    }

    private void parseSalt(PWDServerKeyExchangeMessage msg) {
        msg.setSalt(this.parseByteArrayField((Integer)msg.getSaltLength().getValue()));
        LOGGER.debug("Salt: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSalt().getValue())));
    }

    private void parseCurveType(PWDServerKeyExchangeMessage msg) {
        msg.setCurveType(this.parseByteField(1));
        LOGGER.debug("CurveType: " + msg.getGroupType().getValue());
    }

    private void parseNamedGroup(PWDServerKeyExchangeMessage msg) {
        msg.setNamedGroup(this.parseByteArrayField(2));
        LOGGER.debug("NamedGroup: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getNamedGroup().getValue())));
    }

    private void parseElementLength(PWDServerKeyExchangeMessage msg) {
        msg.setElementLength(this.parseIntField(1));
        LOGGER.debug("ElementLegnth: " + msg.getElementLength().getValue());
    }

    private void parseElement(PWDServerKeyExchangeMessage msg) {
        msg.setElement(this.parseByteArrayField((Integer)msg.getElementLength().getValue()));
        LOGGER.debug("Element: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getElement().getValue())));
    }

    private void parseScalarLength(PWDServerKeyExchangeMessage msg) {
        msg.setScalarLength(this.parseIntField(1));
        LOGGER.debug("ScalarLength: " + msg.getScalarLength().getValue());
    }

    private void parseScalar(PWDServerKeyExchangeMessage msg) {
        msg.setScalar(this.parseByteArrayField((Integer)msg.getScalarLength().getValue()));
        LOGGER.debug("Scalar: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getScalar().getValue())));
    }
}

