/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HelloMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHelloPreparator
extends HelloMessagePreparator<ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientHelloMessage msg;

    public ClientHelloPreparator(Chooser chooser, ClientHelloMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing ClientHelloMessage");
        this.prepareProtocolVersion(this.msg);
        this.prepareRandom();
        this.prepareSessionID();
        this.prepareSessionIDLength();
        this.prepareCompressions(this.msg);
        this.prepareCompressionLength(this.msg);
        this.prepareCipherSuites(this.msg);
        this.prepareCipherSuitesLength(this.msg);
        if (this.isDTLS()) {
            if (this.hasHandshakeCookie()) {
                this.prepareCookie(this.msg);
                this.prepareCookieLength(this.msg);
                this.msg.setIncludeInDigest(true);
            } else {
                this.msg.setIncludeInDigest(false);
            }
        }
        if (!this.chooser.getConfig().getHighestProtocolVersion().isSSL() || this.chooser.getConfig().getHighestProtocolVersion().isSSL() && this.chooser.getConfig().isAddExtensionsInSSL().booleanValue()) {
            this.prepareExtensions();
            this.prepareExtensionLength();
        }
    }

    @Override
    protected void prepareRandom() {
        if (this.isDTLS() && this.hasClientRandom()) {
            this.msg.setRandom(this.chooser.getClientRandom());
        } else {
            super.prepareRandom();
        }
    }

    private void prepareSessionID() {
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            if (this.chooser.getContext().getServerSessionId() == null) {
                this.msg.setSessionId(this.chooser.getClientSessionId());
            } else {
                this.msg.setSessionId(this.chooser.getServerSessionId());
            }
        } else if (this.chooser.getContext().getServerSessionId() == null) {
            this.msg.setSessionId(this.chooser.getClientSessionId());
        } else {
            this.msg.setSessionId(this.chooser.getServerSessionId());
        }
        LOGGER.debug("SessionId: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getSessionId().getValue())));
    }

    private boolean isDTLS() {
        return this.chooser.getSelectedProtocolVersion().isDTLS();
    }

    private byte[] convertCompressions(List<CompressionMethod> compressionList) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (CompressionMethod compression : compressionList) {
            try {
                stream.write(compression.getArrayValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not prepare ClientHelloMessage. Failed to write Ciphersuites into message", ex);
            }
        }
        return stream.toByteArray();
    }

    private byte[] convertCipherSuites(List<CipherSuite> suiteList) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (CipherSuite suite : suiteList) {
            try {
                stream.write(suite.getByteValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not prepare ClientHelloMessage. Failed to write Ciphersuites into message", ex);
            }
        }
        return stream.toByteArray();
    }

    private void prepareProtocolVersion(ClientHelloMessage msg) {
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            msg.setProtocolVersion(ProtocolVersion.TLS12.getValue());
        } else {
            msg.setProtocolVersion(this.chooser.getConfig().getHighestProtocolVersion().getValue());
        }
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getProtocolVersion().getValue())));
    }

    private void prepareCompressions(ClientHelloMessage msg) {
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            msg.setCompressions(CompressionMethod.NULL.getArrayValue());
        } else {
            msg.setCompressions(this.convertCompressions(this.chooser.getConfig().getDefaultClientSupportedCompressionMethods()));
        }
        LOGGER.debug("Compressions: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCompressions().getValue())));
    }

    private void prepareCompressionLength(ClientHelloMessage msg) {
        msg.setCompressionLength(((byte[])msg.getCompressions().getValue()).length);
        LOGGER.debug("CompressionLength: " + msg.getCompressionLength().getValue());
    }

    private void prepareCipherSuites(ClientHelloMessage msg) {
        msg.setCipherSuites(this.convertCipherSuites(this.chooser.getConfig().getDefaultClientSupportedCiphersuites()));
        LOGGER.debug("CipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuites().getValue())));
    }

    private void prepareCipherSuitesLength(ClientHelloMessage msg) {
        msg.setCipherSuiteLength(((byte[])msg.getCipherSuites().getValue()).length);
        LOGGER.debug("CipherSuitesLength: " + msg.getCipherSuiteLength().getValue());
    }

    private boolean hasClientRandom() {
        return this.chooser.getContext().getClientRandom() != null;
    }

    private boolean hasHandshakeCookie() {
        return this.chooser.getContext().getDtlsCookie() != null;
    }

    private void prepareCookie(ClientHelloMessage msg) {
        msg.setCookie(this.chooser.getDtlsCookie());
        LOGGER.debug("Cookie: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCookie().getValue())));
    }

    private void prepareCookieLength(ClientHelloMessage msg) {
        msg.setCookieLength((byte)((byte[])msg.getCookie().getValue()).length);
        LOGGER.debug("CookieLength: " + msg.getCookieLength().getValue());
    }

    @Override
    public void afterPrepare() {
        this.afterPrepareExtensions();
    }
}

