/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css21;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssHeight
extends org.w3c.css.properties.css.CssHeight {
    public CssHeight() {
    }

    public CssHeight(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        switch (val.getType()) {
            case 0: {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(val)) {
                    this.value = inherit;
                    break;
                }
                if (auto.equals(val)) {
                    this.value = auto;
                    break;
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            case 5: {
                val = ((CssNumber)val).getLength();
            }
            case 6: {
                CssLength l = (CssLength)val;
                if (!l.isPositive()) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.value = l;
                break;
            }
            case 4: {
                CssPercentage p = (CssPercentage)val;
                if (!p.isPositive()) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.value = p;
                break;
            }
            default: {
                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssHeight(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return this.value == auto;
    }
}

