untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwaIALuficNzSer5LctiYxzSrHjUVzoe1Q46Hd7b8NamJejBZW08UmlvJf+bGCWNx6ZXYhAFqphCAyx82KtwKZAs=

OpenBSD 5.9 errata 19, Jul 14, 2016:

Invalid file descriptor use with kevent(2) could lead to a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 019_kevent.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/kern_event.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_event.c,v
retrieving revision 1.71
diff -u -p -r1.71 kern_event.c
--- sys/kern/kern_event.c	6 Jan 2016 17:58:46 -0000	1.71
+++ sys/kern/kern_event.c	14 Jul 2016 02:37:59 -0000
@@ -576,6 +576,8 @@ kqueue_register(struct kqueue *kq, struc
 
 	if (fops->f_isfd) {
 		/* validate descriptor */
+		if (kev->ident > INT_MAX)
+			return (EBADF);
 		if ((fp = fd_getfile(fdp, kev->ident)) == NULL)
 			return (EBADF);
 		FREF(fp);
