untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ6AGZHP5WaZ87TSASuD0+j8d7zcLc6DFiZ9qdp9hdsWvm7ZqTzwtoTZqGoAvLQ1CLnfS33VxY5/oTukJO/kLwgU=

OpenBSD 6.0 errata 028, June 12, 2017:

An unprivileged console user can cause a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 028_wsmux.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/wscons/wsmux.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsmux.c,v
retrieving revision 1.31
diff -u -p -r1.31 wsmux.c
--- sys/dev/wscons/wsmux.c	10 Sep 2015 18:14:52 -0000	1.31
+++ sys/dev/wscons/wsmux.c	12 Jun 2017 16:33:17 -0000
@@ -142,10 +142,10 @@ wsmux_getmux(int n)
 			bcopy(old, new, nwsmux * sizeof(*wsmuxdevs));
 		for (i = nwsmux; i < (n + 1); i++)
 			new[i] = NULL;
-		wsmuxdevs = new;
-		nwsmux = n + 1;
 		if (old != NULL)
 			free(old, M_DEVBUF, nwsmux * sizeof(*wsmuxdevs));
+		wsmuxdevs = new;
+		nwsmux = n + 1;
 	}
 
 	sc = wsmuxdevs[n];
