untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEu2i0Rk+2jegwVongnaA2ojcYgaEhpz07n4N7Y1uKv0jQ2+KIw333jm32ObggMxcnwwmB7mEn6WeG9u8bhUZ8gQ=

OpenBSD 6.1 errata 014, July 5, 2017:

Distinguish between self-issued certificates and self-signed certificates,
so that self-issued certificates verify correctly in a chain.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 014_libcrypto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make depend
	make
	make install

Index: lib/libcrypto/x509v3/v3_purp.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509v3/v3_purp.c,v
retrieving revision 1.29
diff -u -p -u -p -r1.29 v3_purp.c
--- lib/libcrypto/x509v3/v3_purp.c	29 Jan 2017 17:49:23 -0000	1.29
+++ lib/libcrypto/x509v3/v3_purp.c	4 Jul 2017 16:59:03 -0000
@@ -65,6 +65,14 @@
 #include <openssl/x509v3.h>
 #include <openssl/x509_vfy.h>
 
+#define V1_ROOT (EXFLAG_V1|EXFLAG_SS)
+#define ku_reject(x, usage) \
+	(((x)->ex_flags & EXFLAG_KUSAGE) && !((x)->ex_kusage & (usage)))
+#define xku_reject(x, usage) \
+	(((x)->ex_flags & EXFLAG_XKUSAGE) && !((x)->ex_xkusage & (usage)))
+#define ns_reject(x, usage) \
+	(((x)->ex_flags & EXFLAG_NSCERT) && !((x)->ex_nscert & (usage)))
+
 static void x509v3_cache_extensions(X509 *x);
 
 static int check_ssl_ca(const X509 *x);
@@ -427,19 +435,19 @@ x509v3_cache_extensions(X509 *x)
 	ASN1_BIT_STRING *ns;
 	EXTENDED_KEY_USAGE *extusage;
 	X509_EXTENSION *ex;
-
 	int i;
+
 	if (x->ex_flags & EXFLAG_SET)
 		return;
+
 #ifndef OPENSSL_NO_SHA
 	X509_digest(x, EVP_sha1(), x->sha1_hash, NULL);
 #endif
-	/* Does subject name match issuer ? */
-	if (!X509_NAME_cmp(X509_get_subject_name(x), X509_get_issuer_name(x)))
-		x->ex_flags |= EXFLAG_SI;
+
 	/* V1 should mean no extensions ... */
 	if (!X509_get_version(x))
 		x->ex_flags |= EXFLAG_V1;
+
 	/* Handle basic constraints */
 	if ((bs = X509_get_ext_d2i(x, NID_basic_constraints, NULL, NULL))) {
 		if (bs->ca)
@@ -456,6 +464,7 @@ x509v3_cache_extensions(X509 *x)
 		BASIC_CONSTRAINTS_free(bs);
 		x->ex_flags |= EXFLAG_BCONS;
 	}
+
 	/* Handle proxy certificates */
 	if ((pci = X509_get_ext_d2i(x, NID_proxyCertInfo, NULL, NULL))) {
 		if (x->ex_flags & EXFLAG_CA ||
@@ -477,6 +486,7 @@ x509v3_cache_extensions(X509 *x)
 		PROXY_CERT_INFO_EXTENSION_free(pci);
 		x->ex_flags |= EXFLAG_PROXY;
 	}
+
 	/* Handle key usage */
 	if ((usage = X509_get_ext_d2i(x, NID_key_usage, NULL, NULL))) {
 		if (usage->length > 0) {
@@ -541,6 +551,16 @@ x509v3_cache_extensions(X509 *x)
 
 	x->skid = X509_get_ext_d2i(x, NID_subject_key_identifier, NULL, NULL);
 	x->akid = X509_get_ext_d2i(x, NID_authority_key_identifier, NULL, NULL);
+
+	/* Does subject name match issuer? */
+	if (!X509_NAME_cmp(X509_get_subject_name(x), X509_get_issuer_name(x))) {
+		x->ex_flags |= EXFLAG_SI;
+		/* If SKID matches AKID also indicate self signed. */
+		if (X509_check_akid(x, x->akid) == X509_V_OK &&
+		    !ku_reject(x, KU_KEY_CERT_SIGN))
+			x->ex_flags |= EXFLAG_SS;
+	}
+
 	x->altname = X509_get_ext_d2i(x, NID_subject_alt_name, NULL, NULL);
 	x->nc = X509_get_ext_d2i(x, NID_name_constraints, &i, NULL);
 	if (!x->nc && (i != -1))
@@ -570,14 +590,6 @@ x509v3_cache_extensions(X509 *x)
  * 3 basicConstraints absent but self signed V1.
  * 4 basicConstraints absent but keyUsage present and keyCertSign asserted.
  */
-
-#define V1_ROOT (EXFLAG_V1|EXFLAG_SS)
-#define ku_reject(x, usage) \
-	(((x)->ex_flags & EXFLAG_KUSAGE) && !((x)->ex_kusage & (usage)))
-#define xku_reject(x, usage) \
-	(((x)->ex_flags & EXFLAG_XKUSAGE) && !((x)->ex_xkusage & (usage)))
-#define ns_reject(x, usage) \
-	(((x)->ex_flags & EXFLAG_NSCERT) && !((x)->ex_nscert & (usage)))
 
 static int
 check_ca(const X509 *x)
Index: lib/libcrypto/x509v3/x509v3.h
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509v3/x509v3.h,v
retrieving revision 1.21
diff -u -p -u -p -r1.21 x509v3.h
--- lib/libcrypto/x509v3/x509v3.h	30 Dec 2016 16:19:24 -0000	1.21
+++ lib/libcrypto/x509v3/x509v3.h	4 Jul 2017 16:59:04 -0000
@@ -411,23 +411,21 @@ struct ISSUING_DIST_POINT_st
 
 /* X509_PURPOSE stuff */
 
-#define EXFLAG_BCONS		0x1
-#define EXFLAG_KUSAGE		0x2
-#define EXFLAG_XKUSAGE		0x4
-#define EXFLAG_NSCERT		0x8
+#define EXFLAG_BCONS		0x0001
+#define EXFLAG_KUSAGE		0x0002
+#define EXFLAG_XKUSAGE		0x0004
+#define EXFLAG_NSCERT		0x0008
 
-#define EXFLAG_CA		0x10
-/* Really self issued not necessarily self signed */
-#define EXFLAG_SI		0x20
-#define EXFLAG_SS		0x20
-#define EXFLAG_V1		0x40
-#define EXFLAG_INVALID		0x80
-#define EXFLAG_SET		0x100
-#define EXFLAG_CRITICAL		0x200
-#define EXFLAG_PROXY		0x400
-
-#define EXFLAG_INVALID_POLICY	0x800
+#define EXFLAG_CA		0x0010
+#define EXFLAG_SI		0x0020  /* Self issued. */
+#define EXFLAG_V1		0x0040
+#define EXFLAG_INVALID		0x0080
+#define EXFLAG_SET		0x0100
+#define EXFLAG_CRITICAL		0x0200
+#define EXFLAG_PROXY		0x0400
+#define EXFLAG_INVALID_POLICY	0x0800
 #define EXFLAG_FRESHEST		0x1000
+#define EXFLAG_SS               0x2000	/* Self signed. */
 
 #define KU_DIGITAL_SIGNATURE	0x0080
 #define KU_NON_REPUDIATION	0x0040
