untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEsWTjLOtqOS+Fao5sF1EKcZH+kPZFnxdogeMb6lkW6HoMi2RQF22IjFFnsmUAg8mIq69MRfNOBEan87c/SNhygI=

OpenBSD 6.1 errata 036, February 2nd, 2018:

If the EtherIP tunnel protocol was disabled, IPv6 packets were not
discarded properly.  This causes a double free in the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 036_etherip.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/if_etherip.c
===================================================================
RCS file: /cvs/src/sys/net/if_etherip.c,v
retrieving revision 1.16
diff -u -p -r1.16 if_etherip.c
--- sys/net/if_etherip.c	27 Mar 2017 23:49:03 -0000	1.16
+++ sys/net/if_etherip.c	1 Feb 2018 20:20:38 -0000
@@ -582,7 +582,7 @@ ip6_etherip_input(struct mbuf **mp, int 
 	if (!etherip_allow && (m->m_flags & (M_AUTH|M_CONF)) == 0) {
 		m_freem(m);
 		etheripstat.etherips_pdrops++;
-		return IPPROTO_NONE;
+		return IPPROTO_DONE;
 	}
 
 	ip6 = mtod(m, const struct ip6_hdr *);
