untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3oO28Ts7Yye46ewSH+mwnUfRDh6Mk+FPp2tj0eysaZbC/XjIq1AT+LqVCpfJ/OGFlJ3eGDtucQf59bE2Axy2oAs=

OpenBSD 6.7 errata 002, May 22, 2020:

Fix rpki-client hang because of improper waitpid idiom for rsync processes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 002_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install rpki-client:
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make clean
    make
    make install

Index: usr.sbin/rpki-client/main.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/main.c,v
diff -u -p -r1.69 main.c
--- usr.sbin/rpki-client/main.c	6 May 2020 12:15:50 -0000	1.69
+++ usr.sbin/rpki-client/main.c	18 May 2020 02:29:05 -0000
@@ -649,27 +649,28 @@ proc_rsync(char *prog, char *bind_addr, 
 			 * Then we respond to the parent.
 			 */
 
-			if ((pid = waitpid(WAIT_ANY, &st, 0)) == -1)
-				err(1, "waitpid");
+			while ((pid = waitpid(WAIT_ANY, &st, WNOHANG)) > 0) {
+				for (i = 0; i < idsz; i++)
+					if (ids[i].pid == pid)
+						break;
+				assert(i < idsz);
 
-			for (i = 0; i < idsz; i++)
-				if (ids[i].pid == pid)
-					break;
-			assert(i < idsz);
+				if (!WIFEXITED(st)) {
+					warnx("rsync %s terminated abnormally",
+					    ids[i].uri);
+					rc = 1;
+				} else if (WEXITSTATUS(st) != 0) {
+					warnx("rsync %s failed", ids[i].uri);
+				}
 
-			if (!WIFEXITED(st)) {
-				warnx("rsync %s terminated abnormally",
-				    ids[i].uri);
-				rc = 1;
-			} else if (WEXITSTATUS(st) != 0) {
-				warnx("rsync %s failed", ids[i].uri);
+				io_simple_write(fd, &ids[i].id, sizeof(size_t));
+				free(ids[i].uri);
+				ids[i].uri = NULL;
+				ids[i].pid = 0;
+				ids[i].id = 0;
 			}
-
-			io_simple_write(fd, &ids[i].id, sizeof(size_t));
-			free(ids[i].uri);
-			ids[i].uri = NULL;
-			ids[i].pid = 0;
-			ids[i].id = 0;
+			if (pid == -1 && errno != ECHILD)
+				err(1, "waitpid");
 			continue;
 		}
 
