untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3goNFAqetULgQLlULlGF7go8bqXkC2K5OwqUlahIa5L3MwGKlBSdtne2A94nW9ZU/BUr6os+x9FdUdAUKvKNAAM=

OpenBSD 6.7 errata 013, July 22, 2020:

Only pty devices need reprint delays.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 013_tty.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/tty.c
===================================================================
RCS file: /cvs/src/sys/kern/tty.c,v
diff -u -p -u -r1.154.4.1 tty.c
--- sys/kern/tty.c	15 Jul 2020 21:55:53 -0000	1.154.4.1
+++ sys/kern/tty.c	20 Jul 2020 19:06:20 -0000
@@ -226,8 +226,8 @@ ttyclose(struct tty *tp)
 
 
 /*
- * Process input of a single character received on a tty.  Returns 0 for
- * simple operations, 1 for costly ones (ptcwrite needs to know).
+ * Process input of a single character received on a tty.  Returns 0 normally,
+ * 1 if a costly operation was reached.
  */
 int
 ttyinput(int c, struct tty *tp)
@@ -2005,11 +2005,7 @@ ttyretype(struct tty *tp)
 
 	tp->t_rocount = tp->t_rawq.c_cc;
 	tp->t_rocol = 0;
-	/*
-	 * Yield because of expense, or possible ptcwrite() injection flood.
-	 * Also check for interrupt, and return upwards.
-	 */
-	return tsleep_nsec(tp, TTIPRI | PCATCH, "ttyretype", 1);
+	return (1);
 }
 
 /*
Index: sys/kern/tty_pty.c
===================================================================
RCS file: /cvs/src/sys/kern/tty_pty.c,v
diff -u -p -u -r1.98.4.1 tty_pty.c
--- sys/kern/tty_pty.c	15 Jul 2020 21:55:53 -0000	1.98.4.1
+++ sys/kern/tty_pty.c	20 Jul 2020 14:34:57 -0000
@@ -564,7 +564,8 @@ again:
 				wakeup(&tp->t_rawq);
 				goto block;
 			}
-			if ((*linesw[tp->t_line].l_rint)(*cp++, tp) == EINTR)
+			if ((*linesw[tp->t_line].l_rint)(*cp++, tp) == 1 &&
+			    tsleep(tp, TTIPRI | PCATCH, "ttyretype", 1) == EINTR)
 				goto interrupt;
 			cnt++;
 			cc--;
