untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3uA4quwmzRWfmahDybgpV/hEPKVAq3jbYgY+FdKk8+WCWF/1OHUhwDZaodhqzXpcZo8xpBuT1a+4EU+fy/l1kg0=

OpenBSD 6.7 errata 014, July 27, 2020:

In iked, incorrect use of EVP_PKEY_cmp allows an authentication bypass.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 014_iked.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install iked:
    cd /usr/src/sbin/iked
    make obj
    make
    make install

Index: sbin/iked/ca.c
===================================================================
RCS file: /cvs/src/sbin/iked/ca.c,v
diff -u -p -u -r1.60 ca.c
--- sbin/iked/ca.c	12 Apr 2020 20:18:45 -0000	1.60
+++ sbin/iked/ca.c	23 Jul 2020 16:12:41 -0000
@@ -1404,7 +1404,7 @@ ca_validate_pubkey(struct iked *env, str
 	if (localkey == NULL)
 		goto sslerr;
 
-	if (!EVP_PKEY_cmp(peerkey, localkey)) {
+	if (EVP_PKEY_cmp(peerkey, localkey) != 1) {
 		log_debug("%s: public key does not match %s", __func__, file);
 		goto done;
 	}
