/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.plugin.AbstractProvisionCommand;

public class ProvisionCommand
extends AbstractProvisionCommand {
    public ProvisionCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected String getDescription() {
        return "Provision an installation from a provisioning file";
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.maingrp.core.CoreProvisionCommand";
    }

    @Override
    public String getCoreVersion(PmSession session) throws ProvisioningException {
        String file = this.getFile();
        try {
            return session.getGalleonBuilder().getCoreVersion(this.getAbsolutePath(file, session.getAeshContext()));
        }
        catch (IOException ex) {
            throw new ProvisioningException(ex);
        }
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("").hasValue(true).description("File describing the desired provisioned state").type(String.class).optionType(OptionType.ARGUMENT).completer(FileOptionCompleter.class).build());
        return options;
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String filePath = this.getFile();
        if (filePath != null) {
            try {
                if (!Files.exists(this.getAbsolutePath(filePath, invoc.getConfiguration().getAeshContext()), new LinkOption[0])) {
                    throw new CommandExecutionException(filePath + " doesn't exist");
                }
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ex.getMessage());
            }
        }
    }

    public Path getProvisioningFile() throws IOException {
        String file = this.getFile();
        if (file == null) {
            return null;
        }
        return this.getAbsolutePath(file, this.pmSession.getAeshContext());
    }

    private String getFile() {
        String file = (String)this.getValue("");
        if (file == null) {
            file = this.getArgumentValue();
        }
        return file;
    }

    @Override
    protected void doRunCommand(PmCommandInvocation invoc, Map<String, String> options) throws CommandExecutionException {
        throw new CommandExecutionException("SHOULDN'T be called");
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }
}

