/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.conf;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CaseInsensitivePatternDeserializer
extends StdScalarDeserializer<Pattern> {
    private static final long serialVersionUID = 1L;

    public CaseInsensitivePatternDeserializer() {
        super(Pattern.class);
    }

    public LogicalType logicalType() {
        return LogicalType.Textual;
    }

    public boolean isCachable() {
        return true;
    }

    public Pattern deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        if (!parser.hasToken(JsonToken.VALUE_STRING)) {
            throw new JsonParseException(parser, "Regular expressions may only be represented as strings.");
        }
        try {
            return Pattern.compile(parser.getText(), 2);
        }
        catch (PatternSyntaxException e) {
            throw new JsonParseException(parser, "Invalid regular expression.", (Throwable)e);
        }
    }
}

