/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.posix;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.CDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LineNumberInfo;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.posix.AddressDataSource;
import sun.jvm.hotspot.debugger.posix.elf.ELFException;
import sun.jvm.hotspot.debugger.posix.elf.ELFFile;
import sun.jvm.hotspot.debugger.posix.elf.ELFFileParser;
import sun.jvm.hotspot.debugger.posix.elf.ELFSymbol;
import sun.jvm.hotspot.utilities.memo.MemoizedBoolean;
import sun.jvm.hotspot.utilities.memo.MemoizedObject;

public abstract class DSO
implements LoadObject {
    private MemoizedObject file;
    private String filename;
    private Address addr;
    private long size;
    private IsDSO dso = new IsDSO();

    public DSO(String filename, long size, Address relocation) throws ELFException {
        this.filename = filename;
        this.size = size;
        this.addr = relocation;
        this.file = new ELFFileByName();
    }

    public DSO(long size, Address relocation) throws ELFException {
        this.addr = relocation;
        this.size = size;
        this.file = new ELFFileByAddress();
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public Address getBase() {
        return this.addr;
    }

    public void setBase(Address newBase) {
        this.addr = newBase;
        if (this.filename == null) {
            this.file = new ELFFileByAddress();
            this.dso = new IsDSO();
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public CDebugInfoDataBase getDebugInfoDataBase() throws DebuggerException {
        return null;
    }

    @Override
    public BlockSym debugInfoForPC(Address pc) throws DebuggerException {
        return null;
    }

    @Override
    public ClosestSymbol closestSymbolToPC(Address pcAsAddr) throws DebuggerException {
        boolean dso = this.isDSO();
        long offset = dso ? pcAsAddr.minus(this.addr) : this.getAddressValue(pcAsAddr);
        ELFSymbol sym = this.getFile().getHeader().getELFSymbol(offset);
        return sym != null ? this.createClosestSymbol(sym.getName(), offset - sym.getValue()) : null;
    }

    @Override
    public LineNumberInfo lineNumberForPC(Address pc) throws DebuggerException {
        return null;
    }

    public boolean isDSO() {
        return this.dso.getValue();
    }

    public Address lookupSymbol(String symbol) throws ELFException {
        ELFSymbol sym = this.getFile().getHeader().getELFSymbol(symbol);
        if (sym == null) {
            return null;
        }
        long value = sym.getValue();
        if (this.isDSO()) {
            return this.addr.addOffsetTo(value);
        }
        return this.newAddress(value);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DSO)) {
            return false;
        }
        DSO other = (DSO)o;
        return this.getBase().equals(other.getBase());
    }

    public int hashCode() {
        return this.getBase().hashCode();
    }

    protected ELFFile getFile() {
        return (ELFFile)this.file.getValue();
    }

    protected abstract Address newAddress(long var1);

    protected abstract long getAddressValue(Address var1);

    protected ClosestSymbol createClosestSymbol(String name, long diff) {
        return new ClosestSymbol(name, diff);
    }

    class ELFFileByAddress
    extends MemoizedObject {
        ELFFileByAddress() {
        }

        @Override
        protected Object computeValue() {
            return ELFFileParser.getParser().parse(new AddressDataSource(DSO.this.addr));
        }
    }

    class ELFFileByName
    extends MemoizedObject {
        ELFFileByName() {
        }

        @Override
        protected Object computeValue() {
            return ELFFileParser.getParser().parse(DSO.this.filename);
        }
    }

    class IsDSO
    extends MemoizedBoolean {
        IsDSO() {
        }

        @Override
        protected boolean computeValue() {
            return DSO.this.getFile().getHeader().getFileType() == 3;
        }
    }
}

