/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class SharpenImageProcessor
implements ImageProcessor,
SessionAwareReadApply {
    private float sharpenLevel = 1.0f;
    private ConvolveOp op;
    private static final float[] KERNEL_IDENTITY = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] KERNEL_BLUR = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
    private static final float[] KERNEL_SHARPEN = new float[]{-0.5f, -1.0f, -0.5f, -1.0f, 7.0f, -1.0f, -0.5f, -1.0f, -0.5f};

    public float getSharpenLevel() {
        return this.sharpenLevel;
    }

    public void setSharpenLevel(float sharpenLevel) {
        this.sharpenLevel = sharpenLevel < 0.0f ? 0.0f : sharpenLevel;
        this.op = (double)this.sharpenLevel < 0.95 ? SharpenImageProcessor.generateMixed(this.sharpenLevel, KERNEL_IDENTITY, KERNEL_BLUR) : ((double)this.sharpenLevel > 1.05 ? SharpenImageProcessor.generateMixed(this.sharpenLevel - 1.0f, KERNEL_SHARPEN, KERNEL_IDENTITY) : null);
    }

    private static ConvolveOp generateMixed(float aFactor, float[] a, float[] b) {
        if (a.length != 9 || b.length != 9) {
            throw new IllegalArgumentException("Illegal kernel array length.");
        }
        float[] values = new float[9];
        for (int i = 0; i < values.length; ++i) {
            values[i] = aFactor * a[i] + (1.0f - aFactor) * b[i];
        }
        return new ConvolveOp(new Kernel(3, 3, values), 1, null);
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        if (this.op != null) {
            return this.op.filter(image, null);
        }
        return image;
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> properties) {
        String vStr = properties.get("sharpenlevel");
        if (vStr != null) {
            try {
                this.setSharpenLevel(Float.parseFloat(vStr));
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        if (Utils.equalsEpsilon(this.sharpenLevel, 1.0)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("sharpenlevel", Float.toString(this.sharpenLevel));
    }

    public String toString() {
        return "SharpenImageProcessor [sharpenLevel=" + this.sharpenLevel + "]";
    }
}

