/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractGeneratedSecretKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.GeneratedHmacKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.SecretKeyProviderUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedHmacKeyProviderFactory
extends AbstractGeneratedSecretKeyProviderFactory<GeneratedHmacKeyProvider> {
    private static final Logger logger = Logger.getLogger(GeneratedHmacKeyProviderFactory.class);
    public static final String ID = "hmac-generated";
    private static final String HELP_TEXT = "Generates HMAC secret key";
    public static final int DEFAULT_HMAC_KEY_SIZE = 128;
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = SecretKeyProviderUtils.configurationBuilder().property(Attributes.SECRET_SIZE_PROPERTY).property(Attributes.HS_ALGORITHM_PROPERTY).build();

    public GeneratedHmacKeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedHmacKeyProvider(model);
    }

    public boolean createFallbackKeys(KeycloakSession session, KeyUse keyUse, String algorithm) {
        if (keyUse.equals((Object)KeyUse.SIG) && (algorithm.equals("HS256") || algorithm.equals("HS384") || algorithm.equals("HS512"))) {
            RealmModel realm = session.getContext().getRealm();
            ComponentModel generated = new ComponentModel();
            generated.setName("fallback-" + algorithm);
            generated.setParentId(realm.getId());
            generated.setProviderId(ID);
            generated.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"-100");
            config.putSingle((Object)"algorithm", (Object)algorithm);
            generated.setConfig(config);
            realm.addComponentModel(generated);
            return true;
        }
        return false;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    @Override
    protected int getDefaultKeySize() {
        return 128;
    }
}

