/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.PathResolutionException;
import org.hibernate.metamodel.mapping.ordering.ast.RootSequencePart;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;

public class PathConsumer {
    private final TranslationContext translationContext;
    private final SequencePart rootSequencePart;
    private final StringBuilder pathSoFar = new StringBuilder();
    private SequencePart currentPart;

    public PathConsumer(PluralAttributeMapping pluralAttributeMapping, TranslationContext translationContext) {
        this.translationContext = translationContext;
        this.rootSequencePart = new RootSequencePart(pluralAttributeMapping);
    }

    public SequencePart getConsumedPart() {
        return this.currentPart;
    }

    public void consumeIdentifier(String unquotedIdentifier, String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        if (!this.pathSoFar.isEmpty()) {
            this.pathSoFar.append('.');
        }
        this.pathSoFar.append(unquotedIdentifier);
        try {
            this.currentPart = this.currentPart.resolvePathPart(unquotedIdentifier, identifier, isTerminal, this.translationContext);
        }
        catch (PathResolutionException pre) {
            throw new PathResolutionException("Unable to resolve path '" + String.valueOf(this.pathSoFar) + "'");
        }
    }

    private void reset() {
        this.pathSoFar.setLength(0);
        this.currentPart = this.rootSequencePart;
    }
}

