/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.types.StateDescriptionFragment;
import org.openhab.core.types.StateDescriptionFragmentBuilder;
import org.openhab.core.types.StateDescriptionFragmentProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={StateDescriptionFragmentProvider.class, DefaultStateDescriptionFragmentProvider.class}, immediate=true, property={"service.ranking:Integer=-2"})
public class DefaultStateDescriptionFragmentProvider
implements StateDescriptionFragmentProvider {
    private static final StateDescriptionFragment DEFAULT_STRING = StateDescriptionFragmentBuilder.create().withPattern("%s").build();
    private static final StateDescriptionFragment DEFAULT_DATETIME = StateDescriptionFragmentBuilder.create().withPattern("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS").build();
    private static final StateDescriptionFragment DEFAULT_NUMBER = StateDescriptionFragmentBuilder.create().withPattern("%.0f").build();
    private static final StateDescriptionFragment DEFAULT_NUMBER_WITH_DIMENSION = StateDescriptionFragmentBuilder.create().withPattern("%.0f %unit%").build();
    private final Logger logger = LoggerFactory.getLogger(DefaultStateDescriptionFragmentProvider.class);
    private final Map<String, StateDescriptionFragment> stateDescriptionFragments = new ConcurrentHashMap<String, StateDescriptionFragment>();
    private Integer rank = -2;

    /*
     * WARNING - void declaration
     */
    @Activate
    public DefaultStateDescriptionFragmentProvider(Map<String, Object> properties) {
        Object serviceRanking;
        Object object = serviceRanking = properties.get("service.ranking");
        if (object instanceof Integer) {
            void rankValue;
            Integer n = (Integer)object;
            Integer cfr_ignored_0 = (Integer)object;
            this.rank = rankValue;
        }
    }

    @Deactivate
    protected void deactivate() {
        this.stateDescriptionFragments.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void onItemAdded(Item item) {
        block15: {
            block16: {
                block14: {
                    void group;
                    this.logger.trace("onItemAdded {} {}", (Object)item.getName(), (Object)item.getType());
                    Item item2 = item;
                    if (!(item2 instanceof GroupItem)) break block14;
                    GroupItem groupItem = (GroupItem)item2;
                    GroupItem cfr_ignored_0 = (GroupItem)item2;
                    Item baseItem = group.getBaseItem();
                    if (baseItem != null) {
                        this.onItemAdded(baseItem);
                    }
                    break block15;
                }
                if (!item.getType().startsWith("Number:")) break block16;
                this.stateDescriptionFragments.put(item.getName(), DEFAULT_NUMBER_WITH_DIMENSION);
                break block15;
            }
            switch (item.getType()) {
                case "String": {
                    this.stateDescriptionFragments.put(item.getName(), DEFAULT_STRING);
                    break;
                }
                case "DateTime": {
                    this.stateDescriptionFragments.put(item.getName(), DEFAULT_DATETIME);
                    break;
                }
                case "Number": {
                    this.stateDescriptionFragments.put(item.getName(), DEFAULT_NUMBER);
                    break;
                }
                default: {
                    this.stateDescriptionFragments.remove(item.getName());
                }
            }
        }
    }

    public void onItemRemoved(Item item) {
        this.logger.trace("onItemRemoved {}", (Object)item.getName());
        this.stateDescriptionFragments.remove(item.getName());
    }

    @Override
    public @Nullable StateDescriptionFragment getStateDescriptionFragment(String itemName, @Nullable Locale locale) {
        return this.stateDescriptionFragments.get(itemName);
    }

    @Override
    public Integer getRank() {
        return this.rank;
    }
}

