/*
 * Decompiled with CFR 0.152.
 */
package org.cryptorb;

import java.security.MessageDigest;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Ed25519::Provider::JRuby"})
public class Ed25519Provider {
    public static RubyModule createEd25519Module(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Ed25519");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("Provider");
        RubyModule rubyModule3 = rubyModule2.defineOrGetModuleUnder("JRuby");
        rubyModule3.defineAnnotatedMethods(Ed25519Provider.class);
        return rubyModule3;
    }

    @JRubyMethod(name={"create_keypair"}, module=true)
    public static IRubyObject create_keypair(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        byte[] byArray = iRubyObject2.convertToString().getByteList().bytes();
        if (byArray.length != 32) {
            throw threadContext.runtime.newArgumentError("expected 32-byte seed value, got " + byArray.length);
        }
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(byArray, edDSANamedCurveSpec);
        EdDSAPublicKeySpec edDSAPublicKeySpec = new EdDSAPublicKeySpec(edDSAPrivateKeySpec.getA(), (EdDSAParameterSpec)edDSANamedCurveSpec);
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, 32);
        System.arraycopy(edDSAPublicKeySpec.getA().toByteArray(), 0, byArray2, 32, 32);
        return RubyString.newString((Ruby)threadContext.getRuntime(), (byte[])byArray2);
    }

    @JRubyMethod(name={"sign"}, module=true)
    public static IRubyObject sign(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) throws Exception {
        byte[] byArray = iRubyObject2.convertToString().getByteList().bytes();
        if (byArray.length != 64) {
            throw threadContext.runtime.newArgumentError("expected 64-byte keypair value, got " + byArray.length);
        }
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAEngine edDSAEngine = new EdDSAEngine(MessageDigest.getInstance(edDSANamedCurveSpec.getHashAlgorithm()));
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 32);
        EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(byArray2, edDSANamedCurveSpec);
        edDSAEngine.initSign(new EdDSAPrivateKey(edDSAPrivateKeySpec));
        edDSAEngine.update(iRubyObject3.convertToString().getByteList().bytes());
        return RubyString.newString((Ruby)threadContext.getRuntime(), (byte[])edDSAEngine.sign());
    }

    @JRubyMethod(name={"verify"}, module=true)
    public static IRubyObject verify(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) throws Exception {
        byte[] byArray = iRubyObject2.convertToString().getByteList().bytes();
        byte[] byArray2 = iRubyObject3.convertToString().getByteList().bytes();
        if (byArray.length != 32) {
            throw threadContext.runtime.newArgumentError("expected 32-byte verify key, got " + byArray.length);
        }
        if (byArray2.length != 64) {
            throw threadContext.runtime.newArgumentError("expected 64-byte signature, got " + byArray2.length);
        }
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAEngine edDSAEngine = new EdDSAEngine(MessageDigest.getInstance(edDSANamedCurveSpec.getHashAlgorithm()));
        EdDSAPublicKeySpec edDSAPublicKeySpec = new EdDSAPublicKeySpec(byArray, (EdDSAParameterSpec)edDSANamedCurveSpec);
        edDSAEngine.initVerify(new EdDSAPublicKey(edDSAPublicKeySpec));
        edDSAEngine.update(iRubyObject4.convertToString().getByteList().bytes());
        boolean bl = edDSAEngine.verify(byArray2);
        return threadContext.runtime.newBoolean(bl);
    }
}

