/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import java.util.stream.Stream;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;

public class GenitiveLabelFilter
extends SingleLabelFilterBase {
    private static final char[][] ENDINGS = (char[][])Stream.of("'s", "`s", "s'", "s`").map(String::toCharArray).toArray(x$0 -> new char[x$0][]);

    public GenitiveLabelFilter() {
        super("Genitive label filter enabled");
    }

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        return this.isGenitive(context.allWords.image, wordIndices[wordIndices.length - 1]);
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return this.isGenitive(context.allWords.image, wordIndex);
    }

    private boolean isGenitive(char[][] wordImage, int wordIndex) {
        char[] image = wordImage[wordIndex];
        block0: for (char[] ending : ENDINGS) {
            if (image.length < ending.length) continue;
            for (int i = 0; i < ending.length; ++i) {
                if (image[image.length - ending.length + i] != ending[i]) continue block0;
            }
            return false;
        }
        return true;
    }
}

