/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class XexunProtocolDecoder
extends BaseProtocolDecoder {
    private final boolean full;
    private static final Pattern PATTERN_BASIC = new PatternBuilder().expression("G[PN]RMC,").number("(?:(dd)(dd)(dd))?.?d*,").expression("([AV]),").number("(d*?)(d?d.d+),([NS]),").number("(d*?)(d?d.d+),([EW])?,").number("(d+.?d*),").number("(d+.?d*)?,").number("(?:(dd)(dd)(dd))?,").expression("[^*]*").text("*").number("xx").expression("\\r\\n").optional().expression(",([FL]),").expression("([^,]*),").optional().any().number("imei:(d+),").compile();
    private static final Pattern PATTERN_FULL = new PatternBuilder().any().number("(d+),").expression("([^,]+)?,").expression(PATTERN_BASIC.pattern()).number("(d+),").number("(-?d+.d+)?,").number("[FL]:(d+.d+)V").any().compile();

    public XexunProtocolDecoder(Protocol protocol, boolean full) {
        super(protocol);
        this.full = full;
    }

    private void decodeStatus(Position position, String value) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "acc on": 
                case "accstart": {
                    position.set("ignition", true);
                    break;
                }
                case "acc off": 
                case "accstop": {
                    position.set("ignition", false);
                    break;
                }
                case "help me!": 
                case "help me": {
                    position.addAlarm("sos");
                    break;
                }
                case "low battery": {
                    position.addAlarm("lowBattery");
                    break;
                }
                case "move!": 
                case "moved!": {
                    position.addAlarm("movement");
                }
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        Pattern pattern = PATTERN_BASIC;
        if (this.full) {
            pattern = PATTERN_FULL;
        }
        if (!(parser = new Parser(pattern, (String)msg)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        if (this.full) {
            position.set("serial", parser.next());
            position.set("number", parser.next());
        }
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(this.convertSpeed(parser.nextDouble(0.0), "kn"));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        position.set("signal", parser.next());
        this.decodeStatus(position, parser.next());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        if (this.full) {
            position.set("sat", parser.nextInt());
            position.setAltitude(parser.nextDouble(0.0));
            position.set("power", parser.nextDouble(0.0));
        }
        return position;
    }
}

