/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.PacketRequestor;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamError;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.StreamSSPI;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class IOBuffer {
    int nInIndex;
    int nRecvSize;
    DBComms dbCom;
    byte[] binDataBuffer;
    int nLastRetStatIndex;
    Vector sqlWarnings;
    private StreamDone streamDone;
    private static Logger tdsDiagLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.TOKEN");
    private static final byte ENVCHANGE_DATABASE = 1;
    private static final byte ENVCHANGE_LANGUAGE = 2;
    private static final byte ENVCHANGE_CHARSET = 3;
    private static final byte ENVCHANGE_PACKETSIZE = 4;
    private static final byte ENVCHANGE_SORTLOCALEID = 5;
    private static final byte ENVCHANGE_SORTFLAGS = 6;
    private static final byte ENVCHANGE_SQLCOLLATION = 7;
    private static final byte ENVCHANGE_XACT_BEGIN = 8;
    private static final byte ENVCHANGE_XACT_COMMIT = 9;
    private static final byte ENVCHANGE_XACT_ROLLBACK = 10;
    private static final byte ENVCHANGE_DTC_ENLIST = 11;
    private static final byte ENVCHANGE_DTC_DEFECT = 12;
    private static final byte ENVCHANGE_CHANGE_MIRROR = 13;
    private static final byte ENVCHANGE_UNUSED_14 = 14;
    private static final byte ENVCHANGE_DTC_PROMOTE = 15;
    private static final byte ENVCHANGE_DTC_MGR_ADDR = 16;
    private static final byte ENVCHANGE_XACT_ENDED = 17;
    private static final byte ENVCHANGE_RESET_COMPLETE = 18;
    private static final byte ENVCHANGE_USER_INFO = 19;

    IOBuffer(DBComms dBComms, int n) {
        this.extendByteBuffer(n);
        this.streamDone = new StreamDone(-3);
        this.dbCom = dBComms;
    }

    final DBComms getDbCom() {
        return this.dbCom;
    }

    final void setDbCom(DBComms dBComms) {
        this.dbCom = dBComms;
    }

    final String instanceId() {
        String string = "" + this;
        int n = string.length();
        String string2 = "" + this.dbCom;
        int n2 = string2.length();
        if (n2 < 5) {
            n2 = 5;
        }
        if (n < 5) {
            n = 5;
        }
        String string3 = "[" + Thread.currentThread() + ", IO:" + string.substring(n - 5) + ", Dbc:" + string2.substring(n2 - 5) + "]";
        return string3;
    }

    final SQLServerConnection getSQLServerConnection() {
        if (this instanceof SQLServerConnection) {
            return (SQLServerConnection)this;
        }
        if (this instanceof SQLServerStatement) {
            return ((SQLServerStatement)this).connection;
        }
        return null;
    }

    void extendByteBuffer(int n) {
        if (n < 1024) {
            n = 1024;
        }
        int n2 = 0;
        if (this.binDataBuffer != null) {
            n2 = this.binDataBuffer.length;
        }
        byte[] byArray = new byte[n2 + n];
        if (n2 > 0) {
            System.arraycopy(this.binDataBuffer, 0, byArray, 0, n2);
            this.binDataBuffer = null;
        }
        this.binDataBuffer = null;
        this.binDataBuffer = byArray;
        byArray = null;
    }

    final void resetInBuffer() {
        this.nRecvSize = 0;
        this.nInIndex = 0;
    }

    final boolean pastEndBuffer() {
        return this.nInIndex >= this.nRecvSize;
    }

    private final String packetName(byte by) {
        String string = "";
        switch (by) {
            case -86: {
                string = "ERR";
                break;
            }
            case -85: {
                string = "MSG";
                break;
            }
            case -3: {
                string = "DONE";
                break;
            }
            case -47: {
                string = "ROW";
                break;
            }
            case -2: {
                string = "DONEPROC";
                break;
            }
            case -1: {
                string = "DONEINPROC";
                break;
            }
            case 121: {
                string = "RET_STAT";
                break;
            }
            case -84: {
                string = "RET_VAL";
                break;
            }
            case -127: {
                string = "COLMETADATA";
                break;
            }
            case -92: {
                string = "TABNAME";
                break;
            }
            case -87: {
                string = "ORDER";
                break;
            }
            case -91: {
                string = "COLINFO";
                break;
            }
            case 124: {
                string = "PROCID";
                break;
            }
            case -29: {
                string = "ENVCHANGE";
                break;
            }
            case -83: {
                string = "LOGINACK";
            }
        }
        return "TDS_" + string + "(" + by + ")";
    }

    final StreamPacket processPackets(SQLServerConnection sQLServerConnection, PacketRequestor[] packetRequestorArray, int n, String string, boolean bl) throws SQLServerException {
        int n2;
        Serializable serializable;
        int n3 = 0;
        boolean bl2 = false;
        Object object = null;
        byte[] byArray = null;
        int n4 = n;
        boolean bl3 = false;
        this.sqlWarnings = null;
        StreamError streamError = null;
        int n5 = 0;
        if (tdsDiagLogger.isLoggable(Level.FINEST)) {
            serializable = new StringBuffer("------------- Start IOBuff.processPackets " + string + " --------------------\r\n" + "Looking for:");
            for (n2 = 0; n2 < n4; ++n2) {
                ((StringBuffer)serializable).append(" " + this.packetName((byte)packetRequestorArray[n2].nPacketType));
            }
            this.logTDSDiag(((StringBuffer)serializable).toString());
        }
        while (!bl3) {
            if (this.nInIndex >= this.nRecvSize) {
                if (null != streamError) {
                    this.nInIndex = n5;
                    SQLServerException.makeFromDatabaseError(sQLServerConnection, this, streamError.getMessage(), streamError, false);
                }
                if (bl) {
                    return null;
                }
                serializable = new MessageFormat(SQLServerException.getErrString("R_exhaustedInput"));
                Object[] objectArray = new Object[]{string};
                String string2 = ((Format)serializable).format(objectArray);
                for (int i = 0; i < n4; ++i) {
                    string2 = string2 + this.packetName((byte)packetRequestorArray[i].nPacketType) + " ";
                }
                SQLException sQLException = new SQLException(string2);
                sQLServerConnection.notifyPooledConnection(sQLException);
                SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, string2, null, true);
            }
            byte by = this.binDataBuffer[this.nInIndex++];
            n2 = -1;
            for (int i = 0; i < n4; ++i) {
                if (by != packetRequestorArray[i].nPacketType) continue;
                n2 = i;
                break;
            }
            if (tdsDiagLogger.isLoggable(Level.FINEST)) {
                this.logTDSDiag(this.packetName(by) + " at:" + (this.nInIndex - 1));
            }
            switch (by) {
                case -3: 
                case -1: {
                    if (n2 >= 0) {
                        if (!packetRequestorArray[n2].bEatPacket) {
                            packetRequestorArray[n2].bFound = true;
                            --this.nInIndex;
                            object = null;
                            bl3 = true;
                            break;
                        }
                        this.streamDone.setData(by, this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                        if (this.streamDone.isFinal()) {
                            object = this.streamDone;
                        }
                        if (this.streamDone.hasCount()) {
                            object = this.streamDone;
                        }
                    }
                    if (n2 >= 0 && packetRequestorArray[n2].bDONEINPROCUnconditional) {
                        object = this.streamDone;
                    }
                    this.nInIndex += 8;
                    if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                    this.nInIndex += 4;
                    break;
                }
                case -2: {
                    if (n2 >= 0) {
                        this.streamDone.setData(by, this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                        object = this.streamDone;
                    }
                    this.nInIndex += 8;
                    if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                    this.nInIndex += 4;
                    break;
                }
                case -127: {
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    StreamColumns streamColumns = new StreamColumns();
                    int n6 = streamColumns.processBytes(by, this.getSQLServerConnection(), this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                    this.nInIndex += n6;
                    if (n2 < 0) break;
                    object = streamColumns;
                    break;
                }
                case -47: {
                    Object object2;
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    if (null == streamError) {
                        String string3 = SQLServerException.getErrString("R_unexpectedPacket");
                        object2 = new SQLException(string3);
                        sQLServerConnection.notifyPooledConnection((Exception)object2);
                        SQLServerException.makeFromDriverError(sQLServerConnection, this, string3, null, true);
                    } else {
                        this.nInIndex = n5;
                        SQLServerException.makeFromDatabaseError(sQLServerConnection, this, streamError.getMessage(), streamError, false);
                    }
                }
                case 121: {
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    this.nLastRetStatIndex = this.nInIndex - 1;
                    this.nInIndex += 4;
                    break;
                }
                case -84: {
                    if (n2 >= 0 && !packetRequestorArray[n2].bEatPacket) {
                        packetRequestorArray[n2].bFound = true;
                        --this.nInIndex;
                        object = null;
                        bl3 = true;
                        break;
                    }
                    this.nInIndex += 2;
                    Object object2 = new StreamRetValue(new Parameter());
                    this.nInIndex = ((StreamRetValue)object2).deserialize(this.binDataBuffer, this.nInIndex, this.dbCom.getTDSVersion());
                    if (n2 < 0) break;
                    object = object2;
                    break;
                }
                case -91: 
                case -89: 
                case -88: 
                case -30: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    this.nInIndex += n3;
                    break;
                }
                case -29: {
                    this.processEnvChange();
                    break;
                }
                case -19: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    byArray = new byte[n3];
                    System.arraycopy(this.binDataBuffer, this.nInIndex, byArray, 0, n3);
                    object = new StreamSSPI(byArray);
                    this.nInIndex += n3;
                    break;
                }
                case -83: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    if (n2 >= 0) {
                        byArray = new byte[n3];
                        System.arraycopy(this.binDataBuffer, this.nInIndex, byArray, 0, n3);
                        object = new StreamLoginAck(byArray);
                    }
                    this.nInIndex += n3;
                    if (this.nInIndex >= this.nRecvSize || -29 != this.binDataBuffer[this.nInIndex]) break;
                    ++this.nInIndex;
                    this.processEnvChange();
                    break;
                }
                case -86: 
                case -85: {
                    SQLException sQLException;
                    Object object3;
                    Serializable serializable2;
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    byArray = new byte[n3];
                    System.arraycopy(this.binDataBuffer, this.nInIndex, byArray, 0, n3);
                    if (by == -86) {
                        object = new StreamError(byArray, this.dbCom.getTDSVersion());
                    } else {
                        serializable2 = new StreamError(byArray, this.dbCom.getTDSVersion());
                        object3 = new SQLWarning(((StreamError)serializable2).getMessage(), SQLServerException.generateStateCode(this.getSQLServerConnection(), ((StreamError)serializable2).getErrorNumber(), ((StreamError)serializable2).getErrorState()), ((StreamError)serializable2).getErrorNumber());
                        if (this.sqlWarnings == null) {
                            this.sqlWarnings = new Vector();
                        } else {
                            int n7 = this.sqlWarnings.size();
                            sQLException = (SQLWarning)this.sqlWarnings.elementAt(n7 - 1);
                            ((SQLWarning)sQLException).setNextWarning((SQLWarning)object3);
                        }
                        this.sqlWarnings.add(object3);
                    }
                    this.nInIndex += n3;
                    break;
                }
                case -92: 
                case -87: {
                    n3 = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
                    this.nInIndex += n3;
                    break;
                }
                case 124: {
                    this.nInIndex += 8;
                    break;
                }
                default: {
                    Serializable serializable2 = new MessageFormat(SQLServerException.getErrString("R_unknownPacket"));
                    Object object3 = new Object[]{new Byte(by), new Integer(this.nInIndex - 1), new Integer(this.nRecvSize)};
                    String string4 = ((Format)serializable2).format(object3);
                    for (int i = 0; i < n4; ++i) {
                        string4 = string4 + this.packetName((byte)packetRequestorArray[i].nPacketType) + " ";
                    }
                    SQLException sQLException = new SQLException(string4);
                    sQLServerConnection.notifyPooledConnection(sQLException);
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, string4, null, true);
                }
            }
            if (null == streamError && object instanceof StreamError) {
                StreamError streamError2 = (StreamError)object;
                if (streamError2.getErrorSeverity() >= 16 && streamError2.getErrorSeverity() < 20 && this.dbCom.getTDSVersion().isYukonOrLater()) {
                    n4 = 0;
                    streamError = streamError2;
                    n5 = this.nInIndex;
                } else {
                    SQLServerException.makeFromDatabaseError(sQLServerConnection, this, streamError2.getMessage(), streamError2, false);
                }
            }
            if (null != streamError) {
                bl3 = false;
                continue;
            }
            if (object == null && !bl3) continue;
            return object;
        }
        return null;
    }

    private final void processEnvChange() throws SQLServerException {
        int n = (this.binDataBuffer[this.nInIndex++] & 0xFF) + ((this.binDataBuffer[this.nInIndex++] & 0xFF) << 8);
        int n2 = this.nInIndex;
        byte by = this.binDataBuffer[n2++];
        switch (by) {
            case 2: {
                break;
            }
            case 4: {
                int n3 = 2 * this.binDataBuffer[n2++];
                String string = Util.readUnicodeString(this.binDataBuffer, n2, n3);
                try {
                    this.getSQLServerConnection().setTDSPacketSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_invalidTDS"), null, true);
                }
                break;
            }
            case 7: {
                byte by2 = this.binDataBuffer[n2++];
                if (5 != by2) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_invalidTDS"), null, true);
                }
                this.dbCom.setDatabaseCollation(new SQLCollation(this.binDataBuffer, n2));
                break;
            }
            case 8: 
            case 11: {
                if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                byte[] byArray = this.getSQLServerConnection().getTransactionDescriptor();
                if (byArray.length != this.binDataBuffer[n2++]) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, SQLServerException.getErrString("R_invalidTDS"), null, true);
                }
                System.arraycopy(this.binDataBuffer, n2, byArray, 0, byArray.length);
                n2 += byArray.length;
                if (!this.getSQLServerConnection().getConnectionLogger().isLoggable(Level.FINE)) break;
                String string = 8 == by ? " started" : " enlisted";
                this.getSQLServerConnection().getConnectionLogger().fine("Connection " + this.getSQLServerConnection().connectionID + ": Transaction " + Util.byteToHexDisplayString(byArray) + string);
                break;
            }
            case 10: {
                if (this.getSQLServerConnection().inDistributedTransaction()) break;
            }
            case 9: 
            case 12: {
                if (!this.dbCom.getTDSVersion().isYukonOrLater()) break;
                SQLServerConnection sQLServerConnection = this.getSQLServerConnection();
                if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                    String string = 9 == by ? " committed" : (10 == by ? " rolled back" : " defected");
                    sQLServerConnection.getConnectionLogger().fine("Connection " + sQLServerConnection.connectionID + ": Transaction " + Util.byteToHexDisplayString(sQLServerConnection.getTransactionDescriptor()) + string);
                }
                Arrays.fill(sQLServerConnection.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 1: {
                int n4 = 2 * this.binDataBuffer[n2++];
                try {
                    this.getSQLServerConnection().setCatalogName(new String(this.binDataBuffer, n2, n4, "UTF-16LE"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, unsupportedEncodingException.toString(), null, true);
                }
                break;
            }
            case 13: {
                int n5 = 2 * this.binDataBuffer[n2++];
                try {
                    this.getSQLServerConnection().setFailoverPartnerServerProvided(new String(this.binDataBuffer, n2, n5, "UTF-16LE"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLServerException.makeFromDriverError(this.getSQLServerConnection(), this, unsupportedEncodingException.toString(), null, true);
                }
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
        }
        this.nInIndex += n;
    }

    private void logTDSDiag(String string) {
        tdsDiagLogger.finest(this.instanceId() + string.toString());
    }
}

