/*
 * Decompiled with CFR 0.152.
 */
package liquibase.exception;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.visitor.ValidatingVisitor;
import liquibase.database.Database;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.logging.LogFactory;
import liquibase.precondition.ErrorPrecondition;
import liquibase.precondition.FailedPrecondition;
import liquibase.util.StreamUtil;

public class ValidationFailedException
extends MigrationFailedException {
    private List<String> invalidMD5Sums;
    private List<FailedPrecondition> failedPreconditions;
    private List<ErrorPrecondition> errorPreconditions;
    private Set<ChangeSet> duplicateChangeSets;
    private List<SetupException> setupExceptions;
    private List<Throwable> changeValidationExceptions;
    private ValidationErrors validationErrors;
    private Database database;

    public ValidationFailedException(ValidatingVisitor changeLogHandler) {
        this.invalidMD5Sums = changeLogHandler.getInvalidMD5Sums();
        this.failedPreconditions = changeLogHandler.getFailedPreconditions();
        this.errorPreconditions = changeLogHandler.getErrorPreconditions();
        this.duplicateChangeSets = changeLogHandler.getDuplicateChangeSets();
        this.setupExceptions = changeLogHandler.getSetupExceptions();
        this.changeValidationExceptions = changeLogHandler.getChangeValidationExceptions();
        this.validationErrors = changeLogHandler.getValidationErrors();
        this.database = changeLogHandler.getDatabase();
    }

    @Override
    public String getMessage() {
        StringBuffer message = new StringBuffer();
        message.append("Validation Failed:").append(StreamUtil.getLineSeparator());
        if (this.invalidMD5Sums.size() > 0) {
            message.append("     ").append(this.invalidMD5Sums.size()).append(" change sets check sum").append(StreamUtil.getLineSeparator());
            for (int i = 0; i < this.invalidMD5Sums.size() && i <= 25; ++i) {
                message.append("          ").append(this.invalidMD5Sums.get(i));
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.failedPreconditions.size() > 0) {
            message.append("     ").append(this.failedPreconditions.size()).append(" preconditions failed").append(StreamUtil.getLineSeparator());
            for (FailedPrecondition failedPrecondition : this.failedPreconditions) {
                message.append("     ").append(failedPrecondition.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.errorPreconditions.size() > 0) {
            message.append("     ").append(this.errorPreconditions.size()).append(" preconditions generated an error").append(StreamUtil.getLineSeparator());
            for (ErrorPrecondition errorPrecondition : this.errorPreconditions) {
                message.append("     ").append(errorPrecondition.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.duplicateChangeSets.size() > 0) {
            message.append("     ").append(this.duplicateChangeSets.size()).append(" change sets had duplicate identifiers").append(StreamUtil.getLineSeparator());
            for (ChangeSet changeSet : this.duplicateChangeSets) {
                message.append("          ").append(changeSet.toString(false));
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.setupExceptions.size() > 0) {
            message.append("     ").append(this.setupExceptions.size()).append(" changes have failures").append(StreamUtil.getLineSeparator());
            for (SetupException setupException : this.setupExceptions) {
                message.append("          ").append(setupException.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.changeValidationExceptions.size() > 0) {
            message.append("     ").append(this.changeValidationExceptions.size()).append(" changes have validation errors").append(StreamUtil.getLineSeparator());
            for (Throwable throwable : this.changeValidationExceptions) {
                LogFactory.getLogger().debug("validation exception", throwable);
                message.append("          ").append(throwable.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.validationErrors.hasErrors()) {
            message.append("     ").append(this.validationErrors.getErrorMessages().size()).append(" changes have validation failures").append(StreamUtil.getLineSeparator());
            for (String string : this.validationErrors.getErrorMessages()) {
                message.append("          ").append(string);
                message.append(StreamUtil.getLineSeparator());
            }
        }
        return message.toString();
    }

    public List<String> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public void printDescriptiveError(PrintStream out) {
        out.println("Validation Error: ");
        if (this.invalidMD5Sums.size() > 0) {
            out.println("     " + this.invalidMD5Sums.size() + " change sets have changed since they were ran against the database");
            for (String message : this.invalidMD5Sums) {
                out.println("          " + message);
            }
        }
        if (this.failedPreconditions.size() > 0) {
            out.println("     " + this.failedPreconditions.size() + " preconditions failed");
            for (FailedPrecondition failedPrecondition : this.failedPreconditions) {
                out.println("          " + failedPrecondition.toString());
            }
        }
        if (this.errorPreconditions.size() > 0) {
            out.println("     " + this.errorPreconditions.size() + " preconditions generated an error");
            for (ErrorPrecondition errorPrecondition : this.errorPreconditions) {
                out.println("          " + errorPrecondition.toString());
            }
        }
        if (this.duplicateChangeSets.size() > 0) {
            out.println("     " + this.duplicateChangeSets.size() + " change sets had duplicate identifiers");
            for (ChangeSet duplicate : this.duplicateChangeSets) {
                out.println("          " + duplicate.toString(false));
            }
        }
        if (this.setupExceptions.size() > 0) {
            out.println("     " + this.setupExceptions.size() + " changes had errors");
            for (SetupException setupEx : this.setupExceptions) {
                out.println("          " + setupEx.getMessage());
            }
        }
    }
}

