/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.logstash.ext.JrubyEventExtLibrary;

public final class LsQueueUtils {
    private LsQueueUtils() {
    }

    public static void addAll(BlockingQueue<JrubyEventExtLibrary.RubyEvent> queue, Collection<JrubyEventExtLibrary.RubyEvent> events) throws InterruptedException {
        for (JrubyEventExtLibrary.RubyEvent event : events) {
            queue.put(event);
        }
    }

    public static Collection<JrubyEventExtLibrary.RubyEvent> drain(BlockingQueue<JrubyEventExtLibrary.RubyEvent> queue, int count, long nanos) throws InterruptedException {
        int drained;
        int left = count;
        ArrayList<JrubyEventExtLibrary.RubyEvent> collection = new ArrayList<JrubyEventExtLibrary.RubyEvent>(4 * count / 3 + 1);
        while ((drained = LsQueueUtils.drain(queue, collection, left, nanos)) != 0 && (left -= drained) > 0) {
        }
        return collection;
    }

    private static int drain(BlockingQueue<JrubyEventExtLibrary.RubyEvent> queue, Collection<JrubyEventExtLibrary.RubyEvent> collection, int count, long nanos) throws InterruptedException {
        int added = 0;
        do {
            if ((added += queue.drainTo(collection, count - added)) >= count) continue;
            JrubyEventExtLibrary.RubyEvent event = queue.poll(nanos, TimeUnit.NANOSECONDS);
            if (event == null) break;
            collection.add(event);
            ++added;
        } while (added < count);
        return added;
    }
}

