/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class OnceResultSet
extends NoPutResultSetImpl {
    public static final int DO_CARDINALITY_CHECK = 1;
    public static final int NO_CARDINALITY_CHECK = 2;
    public static final int UNIQUE_CARDINALITY_CHECK = 3;
    private ExecRow rowWithNulls;
    private StatementContext statementContext;
    public NoPutResultSet source;
    private GeneratedMethod emptyRowFun;
    private int cardinalityCheck;
    public int subqueryNumber;
    public int pointOfAttachment;

    public OnceResultSet(NoPutResultSet s, Activation a, GeneratedMethod emptyRowFun, int cardinalityCheck, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.emptyRowFun = emptyRowFun;
        this.cardinalityCheck = cardinalityCheck;
        this.subqueryNumber = subqueryNumber;
        this.pointOfAttachment = pointOfAttachment;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        if (this.isOpen) {
            this.reopenCore();
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.statementContext == null) {
            this.statementContext = this.getLanguageConnectionContext().getStatementContext();
        }
        this.statementContext.setSubqueryResultSet(this.subqueryNumber, this, this.activation.getNumSubqueries());
        ++this.numOpens;
        this.isOpen = true;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((boolean)this.isOpen, (String)"OnceResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow candidateRow = null;
        ExecRow secondRow = null;
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((boolean)this.isOpen, (String)"OpenResultSet not open");
        if (this.isOpen) {
            candidateRow = this.source.getNextRowCore();
            if (candidateRow != null) {
                switch (this.cardinalityCheck) {
                    case 1: 
                    case 2: {
                        candidateRow = candidateRow.getClone();
                        if (this.cardinalityCheck == 1 && (secondRow = this.source.getNextRowCore()) != null) {
                            this.close();
                            StandardException se = StandardException.newException((String)"21000", (Object[])new Object[0]);
                            throw se;
                        }
                        result = candidateRow;
                        break;
                    }
                    case 3: {
                        candidateRow = candidateRow.getClone();
                        secondRow = this.source.getNextRowCore();
                        DataValueDescriptor orderable1 = candidateRow.getColumn(1);
                        while (secondRow != null) {
                            DataValueDescriptor orderable2 = secondRow.getColumn(1);
                            if (!orderable1.compare(2, orderable2, true, true)) {
                                this.close();
                                StandardException se = StandardException.newException((String)"21000", (Object[])new Object[0]);
                                throw se;
                            }
                            secondRow = this.source.getNextRowCore();
                        }
                        result = candidateRow;
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT((String)("cardinalityCheck not unexpected to be " + this.cardinalityCheck));
                        break;
                    }
                }
            } else {
                result = this.rowWithNulls == null ? (this.rowWithNulls = (ExecRow)this.emptyRowFun.invoke(this.activation)) : this.rowWithNulls;
            }
        }
        this.setCurrentRow(result);
        ++this.rowsSeen;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of OnceResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }
}

