/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.multithread;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.SharedDrawable;
import org.lwjgl.opengl.Util;
import org.lwjgl.test.opengl.multithread.BackgroundLoader;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.Sphere;

public final class BackgroundLoadTest {
    private static boolean run = true;
    private static BackgroundLoader backgroundLoader;
    private static Sphere sphere;

    private BackgroundLoadTest() {
    }

    public static void main(String[] args) {
        BackgroundLoadTest.initialize(args);
        Util.checkGLError();
        try {
            backgroundLoader.start();
        }
        catch (LWJGLException e) {
            BackgroundLoadTest.kill("Failed to start background thread.", e);
        }
        Util.checkGLError();
        while (run) {
            if (!Display.isVisible()) {
                Thread.yield();
            } else {
                BackgroundLoadTest.handleIO();
                GL11.glClear((int)16640);
                BackgroundLoadTest.renderObject();
                Util.checkGLError();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
            }
            Display.update();
            if (!Display.isCloseRequested()) continue;
        }
        BackgroundLoadTest.cleanup();
        System.exit(0);
    }

    private static void initialize(String[] args) {
        if (args.length != 1) {
            BackgroundLoadTest.argsError();
        }
        DisplayMode displayMode = null;
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            displayMode = BackgroundLoadTest.chooseMode(modes, 1024, 768);
            if (displayMode == null) {
                displayMode = BackgroundLoadTest.chooseMode(modes, 800, 600);
            }
            if (displayMode == null) {
                displayMode = BackgroundLoadTest.chooseMode(modes, 640, 480);
            }
            if (displayMode == null) {
                BackgroundLoadTest.kill("Failed to set an appropriate display mode.");
            }
            System.out.println("Setting display mode to: " + displayMode);
            Display.setDisplayMode((DisplayMode)displayMode);
            Display.setTitle((String)"Background Loading Test");
            Display.create((PixelFormat)new PixelFormat(8, 24, 0));
        }
        catch (LWJGLException e) {
            BackgroundLoadTest.kill(e.getMessage());
        }
        GL11.glViewport((int)0, (int)0, (int)displayMode.getWidth(), (int)displayMode.getHeight());
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)45.0f, (float)((float)displayMode.getWidth() / (float)displayMode.getHeight()), (float)1.0f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-4.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glClearDepth((double)1.0);
        GL11.glDepthFunc((int)515);
        GL11.glHint((int)3152, (int)4354);
        GL11.glFrontFace((int)2305);
        GL11.glPolygonMode((int)1028, (int)6914);
        GL11.glCullFace((int)1029);
        GL11.glEnable((int)2884);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7425);
        FloatBuffer vectorBuffer = BufferUtils.createFloatBuffer((int)4);
        vectorBuffer.clear();
        vectorBuffer.put(0, 1.0f).put(1, 1.0f).put(2, 1.0f).put(3, 1.0f);
        GL11.glLight((int)16384, (int)4609, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(0, 1.0f).put(1, 1.0f).put(2, 1.0f).put(3, 1.0f);
        GL11.glLight((int)16384, (int)4608, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(0, 1.0f).put(1, 1.0f).put(2, 0.5f).put(3, 1.0f);
        GL11.glLight((int)16384, (int)4610, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(0, -0.33333334f).put(1, 0.33333334f).put(2, 0.33333334f).put(3, 0.0f);
        GL11.glLight((int)16384, (int)4611, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(0, 0.2f).put(1, 0.2f).put(2, 0.2f).put(3, 1.0f);
        GL11.glLightModel((int)2899, (FloatBuffer)vectorBuffer);
        GL11.glEnable((int)16384);
        GL11.glEnable((int)2896);
        sphere = new Sphere();
        if ("PB".equalsIgnoreCase(args[0])) {
            backgroundLoader = new BackgroundLoader(){

                @Override
                Drawable getDrawable() throws LWJGLException {
                    return new Pbuffer(2, 2, new PixelFormat(8, 24, 0), Display.getDrawable());
                }
            };
        } else if ("SD".equalsIgnoreCase(args[0])) {
            backgroundLoader = new BackgroundLoader(){

                @Override
                Drawable getDrawable() throws LWJGLException {
                    return new SharedDrawable(Display.getDrawable());
                }
            };
        } else {
            BackgroundLoadTest.argsError();
        }
    }

    private static void handleIO() {
        if (Keyboard.getNumKeyboardEvents() != 0) {
            while (Keyboard.next()) {
                if (Keyboard.getEventKeyState()) continue;
                switch (Keyboard.getEventKey()) {
                    case 1: {
                        run = false;
                    }
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    static void renderObject() {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        int texID = backgroundLoader.getTexID();
        if (texID == 0) {
            sphere.setTextureFlag(false);
            GL11.glDisable((int)3553);
        } else {
            sphere.setTextureFlag(true);
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)3553, (int)texID);
        }
        sphere.draw(1.0f, 32, 32);
        if (texID != 0) {
            GL11.glBindTexture((int)3553, (int)0);
            GL11.glDisable((int)3553);
        }
    }

    private static DisplayMode chooseMode(DisplayMode[] modes, int width, int height) {
        DisplayMode bestMode = null;
        for (DisplayMode mode : modes) {
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getFrequency() > 85 || bestMode != null && (mode.getBitsPerPixel() < bestMode.getBitsPerPixel() || mode.getFrequency() <= bestMode.getFrequency())) continue;
            bestMode = mode;
        }
        return bestMode;
    }

    private static void cleanup() {
        backgroundLoader.cleanup();
        Thread.yield();
        if (Display.isCreated()) {
            Display.destroy();
        }
    }

    private static void argsError() {
        System.out.println("\nInvalid program arguments.");
        System.out.println("\nUsage: BackgroundLoadTest <testType>, where <testType> argument can be one of the following:\n");
        System.out.println("PB\t- Use a Pbuffer context for the background thread.");
        System.out.println("SD\t- Use a SharedDrawable context for the background thread.");
        BackgroundLoadTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason) {
        System.out.println("The BackgroundLoadTest program was terminated because an error occured.\n");
        System.out.println("Reason: " + (reason == null ? "Unknown" : reason));
        BackgroundLoadTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason, Throwable t) {
        System.out.println("The BackgroundLoadTest program was terminated because an exception occured.\n");
        System.out.println("Reason: " + (reason == null ? "Unknown" : reason));
        System.out.println("Exception message: " + t.getMessage());
        BackgroundLoadTest.cleanup();
        System.exit(-1);
    }
}

