/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.keymanagement.model.OauthMetadata;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalKeyManagerMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="oauthMetadata")
    private final OauthMetadata oauthMetadata;
    @JsonProperty(value="externalVaultEndpointUrl")
    private final String externalVaultEndpointUrl;
    @JsonProperty(value="privateEndpointId")
    private final String privateEndpointId;

    @Deprecated
    @ConstructorProperties(value={"oauthMetadata", "externalVaultEndpointUrl", "privateEndpointId"})
    public ExternalKeyManagerMetadata(OauthMetadata oauthMetadata, String externalVaultEndpointUrl, String privateEndpointId) {
        this.oauthMetadata = oauthMetadata;
        this.externalVaultEndpointUrl = externalVaultEndpointUrl;
        this.privateEndpointId = privateEndpointId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OauthMetadata getOauthMetadata() {
        return this.oauthMetadata;
    }

    public String getExternalVaultEndpointUrl() {
        return this.externalVaultEndpointUrl;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalKeyManagerMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("oauthMetadata=").append(String.valueOf((Object)this.oauthMetadata));
        sb.append(", externalVaultEndpointUrl=").append(String.valueOf(this.externalVaultEndpointUrl));
        sb.append(", privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalKeyManagerMetadata)) {
            return false;
        }
        ExternalKeyManagerMetadata other = (ExternalKeyManagerMetadata)((Object)o);
        return Objects.equals((Object)this.oauthMetadata, (Object)other.oauthMetadata) && Objects.equals(this.externalVaultEndpointUrl, other.externalVaultEndpointUrl) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.oauthMetadata == null ? 43 : this.oauthMetadata.hashCode());
        result = result * 59 + (this.externalVaultEndpointUrl == null ? 43 : this.externalVaultEndpointUrl.hashCode());
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="oauthMetadata")
        private OauthMetadata oauthMetadata;
        @JsonProperty(value="externalVaultEndpointUrl")
        private String externalVaultEndpointUrl;
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder oauthMetadata(OauthMetadata oauthMetadata) {
            this.oauthMetadata = oauthMetadata;
            this.__explicitlySet__.add("oauthMetadata");
            return this;
        }

        public Builder externalVaultEndpointUrl(String externalVaultEndpointUrl) {
            this.externalVaultEndpointUrl = externalVaultEndpointUrl;
            this.__explicitlySet__.add("externalVaultEndpointUrl");
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public ExternalKeyManagerMetadata build() {
            ExternalKeyManagerMetadata model = new ExternalKeyManagerMetadata(this.oauthMetadata, this.externalVaultEndpointUrl, this.privateEndpointId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalKeyManagerMetadata model) {
            if (model.wasPropertyExplicitlySet("oauthMetadata")) {
                this.oauthMetadata(model.getOauthMetadata());
            }
            if (model.wasPropertyExplicitlySet("externalVaultEndpointUrl")) {
                this.externalVaultEndpointUrl(model.getExternalVaultEndpointUrl());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            return this;
        }
    }
}

