/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class DebuggingTruffleTreeExpansionModelFilter
implements TreeExpansionModelFilter,
PropertyChangeListener {
    private static final Reference<JPDAThread> NO_THREAD = new WeakReference<Object>(null);
    private final JPDADebugger debugger;
    private final DebuggingView.DVSupport dvSupport;
    private volatile Reference<JPDAThread> suspendedTruffleThread = NO_THREAD;
    private final Set<Object> collapsedExplicitly = Collections.newSetFromMap(new WeakHashMap());
    private final Set<ModelListener> listeners = Collections.synchronizedSet(new HashSet());

    public DebuggingTruffleTreeExpansionModelFilter(ContextProvider context) {
        this.debugger = (JPDADebugger)context.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", WeakListeners.propertyChange((PropertyChangeListener)this, (String)"currentCallStackFrame", (Object)this.debugger));
        this.dvSupport = (DebuggingView.DVSupport)context.lookupFirst(null, DebuggingView.DVSupport.class);
        this.currentStackFrameChanged(this.debugger.getCurrentCallStackFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(TreeExpansionModel original, Object node) throws UnknownTypeException {
        if (node instanceof DebuggingView.DVThread) {
            DebuggingTruffleTreeExpansionModelFilter debuggingTruffleTreeExpansionModelFilter = this;
            synchronized (debuggingTruffleTreeExpansionModelFilter) {
                if (this.collapsedExplicitly.contains(node)) {
                    return false;
                }
            }
            try {
                JPDAThread thread = (JPDAThread)node.getClass().getMethod("getKey", new Class[0]).invoke(node, new Object[0]);
                if (thread == this.suspendedTruffleThread.get()) {
                    return true;
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return original.isExpanded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object node) {
        if (node instanceof DebuggingView.DVThread) {
            DebuggingTruffleTreeExpansionModelFilter debuggingTruffleTreeExpansionModelFilter = this;
            synchronized (debuggingTruffleTreeExpansionModelFilter) {
                this.collapsedExplicitly.remove(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object node) {
        if (node instanceof DebuggingView.DVThread) {
            DebuggingTruffleTreeExpansionModelFilter debuggingTruffleTreeExpansionModelFilter = this;
            synchronized (debuggingTruffleTreeExpansionModelFilter) {
                this.collapsedExplicitly.add(node);
            }
        }
    }

    private void fireNodeExpanded(Object node) {
        ModelListener[] ls = this.listeners.toArray(new ModelListener[0]);
        if (ls.length > 0) {
            ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 16);
            for (ModelListener ml : ls) {
                ml.modelChanged((ModelEvent)event);
            }
        }
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        CallStackFrame csf = (CallStackFrame)evt.getNewValue();
        this.currentStackFrameChanged(csf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void currentStackFrameChanged(CallStackFrame csf) {
        CurrentPCInfo currentPCInfo;
        CurrentPCInfo currentPCInfo2 = currentPCInfo = csf != null ? TruffleAccess.getCurrentPCInfo(csf.getThread()) : null;
        if (csf != null && currentPCInfo != null && csf.getThread() == currentPCInfo.getThread()) {
            JPDAThread thread = csf.getThread();
            this.suspendedTruffleThread = new WeakReference<JPDAThread>(thread);
            try {
                boolean explicitCollaps;
                Object node = this.dvSupport.getClass().getMethod("get", JPDAThread.class).invoke((Object)this.dvSupport, thread);
                DebuggingTruffleTreeExpansionModelFilter debuggingTruffleTreeExpansionModelFilter = this;
                synchronized (debuggingTruffleTreeExpansionModelFilter) {
                    explicitCollaps = this.collapsedExplicitly.contains(node);
                }
                if (!explicitCollaps) {
                    this.fireNodeExpanded(node);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.suspendedTruffleThread = NO_THREAD;
        }
    }
}

