/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.component.inputslider;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.mobile.component.inputslider.InputSlider;
import org.primefaces.mobile.component.rangeslider.RangeSlider;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class InputSliderRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (!InputSliderRenderer.shouldDecode(component)) {
            return;
        }
        InputSlider inputSlider = (InputSlider)component;
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputSlider.getClientId(context));
        if (submittedValue != null) {
            inputSlider.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputSlider inputSlider = (InputSlider)component;
        this.encodeMarkup(context, inputSlider);
        if (!(inputSlider.getParent() instanceof RangeSlider)) {
            this.encodeScript(context, inputSlider);
        }
    }

    protected void encodeMarkup(FacesContext context, InputSlider inputSlider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputSlider.getClientId(context);
        String style = inputSlider.getStyle();
        String styleClass = inputSlider.getStyleClass();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputSlider);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"number", null);
        writer.writeAttribute("min", (Object)inputSlider.getMinValue(), null);
        writer.writeAttribute("max", (Object)inputSlider.getMaxValue(), null);
        writer.writeAttribute("step", (Object)inputSlider.getStep(), null);
        writer.writeAttribute("data-role", (Object)"none", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (inputSlider.isHighlight()) {
            writer.writeAttribute("data-highlight", (Object)"true", null);
        }
        if (inputSlider.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)inputSlider);
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputSlider inputSlider) throws IOException {
        String clientId = inputSlider.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputSlider", inputSlider.resolveWidgetVar(), clientId).finish();
    }
}

