/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerCompiling
extends NbPropertyPanel.Single {
    private JCheckBox debug;
    private JCheckBox deprecation;
    private JTextField options;
    private JLabel optionsLabel;

    CustomizerCompiling(SingleModuleProperties props, ProjectCustomizer.Category category) {
        super(props, CustomizerCompiling.class, category);
        this.initComponents();
        this.initAccessibility();
        this.refresh();
    }

    @Override
    protected void refresh() {
        this.debug.setSelected(this.getBooleanProperty("build.compiler.debug"));
        this.deprecation.setSelected(this.getBooleanProperty("build.compiler.deprecation"));
        this.options.setText(this.getProperty("javac.compilerargs"));
        NbPlatform platform = this.getProperties().getActivePlatform();
        this.options.setEnabled(platform == null || platform.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("javac.compilerargs".equals(evt.getPropertyName())) {
            this.options.setText(this.getProperty("javac.compilerargs"));
        }
        if ("nbPlatform".equals(evt.getPropertyName())) {
            NbPlatform platform = this.getProperties().getActivePlatform();
            this.options.setEnabled(platform == null || platform.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0);
        }
    }

    @Override
    public void store() {
        this.setBooleanProperty("build.compiler.debug", this.debug.isSelected());
        this.setBooleanProperty("build.compiler.deprecation", this.deprecation.isSelected());
        this.setProperty("javac.compilerargs", this.options.getText());
    }

    private void initComponents() {
        this.deprecation = new JCheckBox();
        this.debug = new JCheckBox();
        this.optionsLabel = new JLabel();
        this.options = new JTextField();
        Mnemonics.setLocalizedText((AbstractButton)this.deprecation, (String)NbBundle.getMessage(CustomizerCompiling.class, (String)"CTL_ReportDeprecation"));
        Mnemonics.setLocalizedText((AbstractButton)this.debug, (String)NbBundle.getMessage(CustomizerCompiling.class, (String)"CTL_GenerateDebugInfo"));
        this.optionsLabel.setLabelFor(this.options);
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(CustomizerCompiling.class, (String)"LBL_additional_compiler_options"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.debug).addComponent(this.deprecation).addGroup(layout.createSequentialGroup().addComponent(this.optionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.options, -1, 193, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.debug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deprecation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel).addComponent(this.options, -2, -1, -2)).addContainerGap(233, Short.MAX_VALUE)));
        this.options.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerCompiling.class, (String)"ACS_AdditionalCompilerOptions"));
        this.options.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompiling.class, (String)"ACSD_AdditionalCompilerOptions"));
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(CustomizerCompiling.class, (String)key);
    }

    private void initAccessibility() {
        this.debug.getAccessibleContext().setAccessibleDescription(CustomizerCompiling.getMessage("ACSD_Debug"));
        this.deprecation.getAccessibleContext().setAccessibleDescription(CustomizerCompiling.getMessage("ACSD_Deprecation"));
    }
}

