/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class OutputLogger
implements ISVNNotifyListener {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;
    private static final RequestProcessor rp = new RequestProcessor("SubversionOutput", 1);
    private boolean writable;
    private static final HashSet<String> openedWindows = new HashSet(5);
    private static final Pattern[] filePatterns = new Pattern[]{Pattern.compile("[AUCGE ][ UC][ BC][ C] ?(.+)"), Pattern.compile("Reverted '(.+)'"), Pattern.compile("Reverted (.+)"), Pattern.compile("Sending        (.+)"), Pattern.compile("Adding         (.+)")};
    private AbstractAction action;
    private String lastCompletedMessage;

    public static OutputLogger getLogger(SVNUrl repositoryRoot) {
        if (repositoryRoot != null) {
            return new OutputLogger(repositoryRoot);
        }
        return new NullLogger();
    }

    private OutputLogger(SVNUrl repositoryRoot) {
        this.repositoryRootString = SvnUtils.decodeToString(repositoryRoot);
    }

    private OutputLogger() {
    }

    public void logCommandLine(final String commandLine) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.logln(commandLine, false);
                OutputLogger.this.flush();
            }
        });
    }

    private void flush() {
        if (this.writable) {
            this.getLog().getOut().flush();
        }
    }

    public void logCompleted(final String message) {
        if (message.equals(this.lastCompletedMessage)) {
            return;
        }
        this.lastCompletedMessage = message;
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.logln(message, OutputLogger.this.ignoreCommand);
                OutputLogger.this.flush();
            }
        });
    }

    public void logError(final String message) {
        if (message == null) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.logln(message, false);
                OutputLogger.this.flush();
            }
        });
    }

    public void logMessage(final String message) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.logln(message, OutputLogger.this.ignoreCommand);
                OutputLogger.this.flush();
            }
        });
    }

    public void logRevision(long revision, String path) {
    }

    public void onNotify(File path, SVNNodeKind kind) {
    }

    public void setCommand(final int command) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.ignoreCommand = command == 19 || command == 12 || command == 25 || command == 13 || command == 11;
            }
        });
    }

    public void closeLog() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (OutputLogger.this.log != null && OutputLogger.this.writable) {
                    OutputLogger.this.getLog().getOut().flush();
                    OutputLogger.this.getLog().getOut().close();
                }
            }
        });
    }

    public void flushLog() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.getLog();
                OutputLogger.this.flush();
            }
        });
    }

    private void logln(String message, boolean ignore) {
        OpenFileOutputListener ol = null;
        for (Pattern p : filePatterns) {
            String path;
            File f;
            Matcher m = p.matcher(message);
            if (!m.matches() || m.groupCount() <= 0 || (f = new File(path = m.group(1))).isDirectory()) continue;
            ol = new OpenFileOutputListener(FileUtil.normalizeFile((File)f), m.start(1));
            break;
        }
        this.log(message + "\n", ol, ignore);
    }

    private void log(String message, OpenFileOutputListener hyperlinkListener, boolean ignore) {
        if (ignore) {
            return;
        }
        if (this.getLog().isClosed()) {
            if (SvnModuleConfig.getDefault().getAutoOpenOutput()) {
                Subversion.LOG.log(Level.FINE, "Creating OutputLogger for {0}", this.repositoryRootString);
                this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
                try {
                    this.getLog().getOut().reset();
                }
                catch (IOException e) {
                    Subversion.LOG.log(Level.SEVERE, null, e);
                }
            } else {
                this.writable = false;
            }
        }
        if (this.writable) {
            if (hyperlinkListener != null) {
                try {
                    String prefix = message.substring(0, hyperlinkListener.filePathStartPos);
                    this.getLog().getOut().write(prefix);
                    String filePath = message.substring(hyperlinkListener.filePathStartPos);
                    this.getLog().getOut().println(filePath.endsWith("\n") ? filePath.substring(0, filePath.length() - 1) : filePath, (OutputListener)hyperlinkListener);
                }
                catch (IOException e) {
                    this.getLog().getOut().write(message);
                }
            } else {
                this.getLog().getOut().write(message);
            }
        }
    }

    private InputOutput getLog() {
        this.writable = true;
        if (this.log == null) {
            Subversion.LOG.log(Level.FINE, "Creating OutputLogger for {0}", this.repositoryRootString);
            this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
            if (!openedWindows.contains(this.repositoryRootString)) {
                this.writable = SvnModuleConfig.getDefault().getAutoOpenOutput();
                openedWindows.add(this.repositoryRootString);
                if (!this.writable) {
                    this.log.closeInputOutput();
                }
            }
        }
        return this.log;
    }

    public Action getOpenOutputAction() {
        if (this.action == null) {
            this.action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputLogger.this.writable = true;
                    OutputLogger.this.getLog().select();
                }
            };
        }
        return this.action;
    }

    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        @Override
        public void logCommandLine(String commandLine) {
        }

        @Override
        public void logCompleted(String message) {
        }

        @Override
        public void logError(String message) {
        }

        @Override
        public void logMessage(String message) {
        }

        @Override
        public void logRevision(long revision, String path) {
        }

        @Override
        public void onNotify(File path, SVNNodeKind kind) {
        }

        @Override
        public void setCommand(int command) {
        }

        @Override
        public void closeLog() {
        }

        @Override
        public void flushLog() {
        }
    }

    private static class OpenFileOutputListener
    implements OutputListener {
        private final File f;
        private final int filePathStartPos;

        public OpenFileOutputListener(File f, int filePathStartPos) {
            this.f = f;
            this.filePathStartPos = filePathStartPos;
        }

        public void outputLineAction(OutputEvent ev) {
            Subversion.LOG.log(Level.FINE, "Opeining file [{0}]", this.f);
            new OpenInEditorAction(new File[]{this.f}).actionPerformed(new ActionEvent(this, 1001, this.f.getAbsolutePath()));
        }
    }
}

