/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.trees;

import java.awt.Point;
import javax.swing.text.JTextComponent;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.drivers.TreeDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;

public class JTreeMouseDriver
extends LightSupportiveDriver
implements TreeDriver {
    QueueTool queueTool = new QueueTool();

    public JTreeMouseDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JTreeOperator"});
    }

    @Override
    public void selectItem(ComponentOperator oper, int index) {
        this.selectItems(oper, new int[]{index});
    }

    @Override
    public void selectItems(final ComponentOperator oper, int[] indices) {
        ((JTreeOperator)oper).clearSelection();
        this.checkSupported(oper);
        final MouseDriver mdriver = DriverManager.getMouseDriver(oper);
        JTreeOperator toper = (JTreeOperator)oper;
        final Timeout clickTime = oper.getTimeouts().create("ComponentOperator.MouseClickTimeout");
        for (int i = 0; i < indices.length; ++i) {
            final int index = i;
            JTreeMouseDriver jTreeMouseDriver = this;
            if (!jTreeMouseDriver.queueTool.isDispatchThread()) {
                toper.scrollToRow(indices[i]);
            }
            final Point p = toper.getPointToClick(indices[index]);
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                @Override
                public Object launch() {
                    mdriver.clickMouse(oper, p.x, p.y, 1, Operator.getDefaultMouseButton(), index == 0 ? 0 : 2, clickTime);
                    return null;
                }
            });
        }
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0 && !QueueTool.isDispatchThread()) {
            this.queueTool.setOutput(oper.getOutput().createErrorOutput());
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
        }
    }

    @Override
    public void expandItem(ComponentOperator oper, final int index) {
        this.checkSupported(oper);
        final JTreeOperator toper = (JTreeOperator)oper;
        final MouseDriver mdriver = DriverManager.getMouseDriver(oper);
        if (!toper.isExpanded(index)) {
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                @Override
                public Object launch() {
                    Point p = toper.getPointToClick(index);
                    mdriver.clickMouse(toper, p.x, p.y, 2, Operator.getDefaultMouseButton(), 0, toper.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                    return null;
                }
            });
        }
    }

    @Override
    public void collapseItem(ComponentOperator oper, final int index) {
        this.checkSupported(oper);
        final JTreeOperator toper = (JTreeOperator)oper;
        final MouseDriver mdriver = DriverManager.getMouseDriver(oper);
        if (toper.isExpanded(index)) {
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

                @Override
                public Object launch() {
                    Point p = toper.getPointToClick(index);
                    mdriver.clickMouse(toper, p.x, p.y, 2, Operator.getDefaultMouseButton(), 0, toper.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                    return null;
                }
            });
        }
    }

    @Override
    public void editItem(ComponentOperator oper, int index, Object newValue, Timeout waitEditorTime) {
        JTextComponentOperator textoper = this.startEditingAndReturnEditor(oper, index, waitEditorTime);
        TextDriver text = DriverManager.getTextDriver(JTextComponentOperator.class);
        text.clearText(textoper);
        text.typeText(textoper, newValue.toString(), 0);
        DriverManager.getKeyDriver(oper).pushKey(textoper, 10, 0, oper.getTimeouts().create("ComponentOperator.PushKeyTimeout"));
    }

    @Override
    public void startEditing(ComponentOperator oper, int index, Timeout waitEditorTime) {
        this.startEditingAndReturnEditor(oper, index, waitEditorTime);
    }

    private JTextComponentOperator startEditingAndReturnEditor(ComponentOperator oper, final int index, Timeout waitEditorTime) {
        this.checkSupported(oper);
        final JTreeOperator toper = (JTreeOperator)oper;
        final MouseDriver mdriver = DriverManager.getMouseDriver(oper);
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            @Override
            public Object launch() {
                Point p = toper.getPointToClick(index);
                mdriver.clickMouse(toper, p.x, p.y, 1, Operator.getDefaultMouseButton(), 0, toper.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                return null;
            }
        });
        oper.getTimeouts().sleep("JTreeOperator.BeforeEditTimeout");
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            @Override
            public Object launch() {
                Point p = toper.getPointToClick(index);
                mdriver.clickMouse(toper, p.x, p.y, 1, Operator.getDefaultMouseButton(), 0, toper.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                return null;
            }
        });
        toper.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", waitEditorTime.getValue());
        return new JTextComponentOperator((JTextComponent)toper.waitSubComponent(new JTextComponentOperator.JTextComponentFinder()));
    }
}

