/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;

public class SourceLevelQueryImpl
implements SourceLevelQueryImplementation {
    private static final Logger LOG = Logger.getLogger(SourceLevelQueryImpl.class.getName());
    private static final int DEFAULT_SOURCE_LEVEL = 11;
    private static final String[] SOURCE_VERSION_LOCATIONS = new String[]{"src/java.compiler/share/classes/javax/lang/model/SourceVersion.java", "open/src/java.compiler/share/classes/javax/lang/model/SourceVersion.java", "langtools/src/java.compiler/share/classes/javax/lang/model/SourceVersion.java"};
    private final String sourceLevel;

    public SourceLevelQueryImpl(FileObject jdkRoot) {
        Optional<FileObject> sourceVersionCandidate = Arrays.stream(SOURCE_VERSION_LOCATIONS).map(location -> BuildUtils.getFileObject(jdkRoot, location)).filter(file -> file != null).findFirst();
        int sl = 11;
        if (sourceVersionCandidate.isPresent()) {
            try {
                TokenHierarchy th = TokenHierarchy.create((CharSequence)sourceVersionCandidate.get().asText(), (Language)JavaTokenId.language());
                TokenSequence seq = th.tokenSequence();
                while (seq.moveNext()) {
                    String ident;
                    if (seq.token().id() != JavaTokenId.IDENTIFIER || !(ident = seq.token().text().toString()).startsWith("RELEASE_")) continue;
                    try {
                        sl = Math.max(sl, Integer.parseInt(ident.substring("RELEASE_".length())));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        this.sourceLevel = "" + sl;
    }

    public String getSourceLevel(FileObject javaFile) {
        return this.sourceLevel;
    }
}

