/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.tag;

import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerTag;
import org.netbeans.modules.docker.ui.tag.Bundle;
import org.netbeans.modules.docker.ui.tag.TagPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class TagTagAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(TagTagAction.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        DockerTag tag = (DockerTag)activatedNodes[0].getLookup().lookup(DockerTag.class);
        if (tag != null) {
            JButton tagButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)tagButton, (String)Bundle.LBL_Tag());
            TagPanel panel = new TagPanel(tag.getImage().getInstance(), tagButton);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LBL_TagTag(tag.getTag()), true, new Object[]{tagButton, DialogDescriptor.CANCEL_OPTION}, (Object)tagButton, 0, null, null);
            descriptor.setClosingOptions(new Object[]{tagButton, DialogDescriptor.CANCEL_OPTION});
            panel.setMessageLine(descriptor.createNotificationLineSupport());
            Dialog dlg = null;
            try {
                dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                dlg.setVisible(true);
                if (descriptor.getValue() == tagButton) {
                    this.perform(tag, panel.getRepository(), panel.getTag(), panel.isForce());
                }
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    private void perform(final DockerTag source, final String repository, final String tag, final boolean force) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_Tagging(source.getTag()));
                handle.start();
                try {
                    DockerAction facade = new DockerAction(source.getImage().getInstance());
                    facade.tag(source, repository, tag, force);
                }
                catch (DockerException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    String msg = ex.getLocalizedMessage();
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0].getLookup().lookup(DockerTag.class) != null;
    }

    public String getName() {
        return Bundle.LBL_TagTagAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

