/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.MaintenanceRunSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListMaintenanceRunHistoryRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String targetResourceId;
    private MaintenanceRunSummary.TargetResourceType targetResourceType;
    private MaintenanceRunSummary.MaintenanceType maintenanceType;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private MaintenanceRunSummary.LifecycleState lifecycleState;
    private String availabilityDomain;
    private MaintenanceRunSummary.MaintenanceSubtype maintenanceSubtype;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public MaintenanceRunSummary.TargetResourceType getTargetResourceType() {
        return this.targetResourceType;
    }

    public MaintenanceRunSummary.MaintenanceType getMaintenanceType() {
        return this.maintenanceType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public MaintenanceRunSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public MaintenanceRunSummary.MaintenanceSubtype getMaintenanceSubtype() {
        return this.maintenanceSubtype;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).targetResourceId(this.targetResourceId).targetResourceType(this.targetResourceType).maintenanceType(this.maintenanceType).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).availabilityDomain(this.availabilityDomain).maintenanceSubtype(this.maintenanceSubtype);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",targetResourceId=").append(String.valueOf(this.targetResourceId));
        sb.append(",targetResourceType=").append(String.valueOf((Object)this.targetResourceType));
        sb.append(",maintenanceType=").append(String.valueOf((Object)this.maintenanceType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",maintenanceSubtype=").append(String.valueOf((Object)this.maintenanceSubtype));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMaintenanceRunHistoryRequest)) {
            return false;
        }
        ListMaintenanceRunHistoryRequest other = (ListMaintenanceRunHistoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetResourceId, other.targetResourceId) && Objects.equals((Object)this.targetResourceType, (Object)other.targetResourceType) && Objects.equals((Object)this.maintenanceType, (Object)other.maintenanceType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals((Object)this.maintenanceSubtype, (Object)other.maintenanceSubtype);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetResourceId == null ? 43 : this.targetResourceId.hashCode());
        result = result * 59 + (this.targetResourceType == null ? 43 : this.targetResourceType.hashCode());
        result = result * 59 + (this.maintenanceType == null ? 43 : this.maintenanceType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.maintenanceSubtype == null ? 43 : this.maintenanceSubtype.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMaintenanceRunHistoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String targetResourceId = null;
        private MaintenanceRunSummary.TargetResourceType targetResourceType = null;
        private MaintenanceRunSummary.MaintenanceType maintenanceType = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private MaintenanceRunSummary.LifecycleState lifecycleState = null;
        private String availabilityDomain = null;
        private MaintenanceRunSummary.MaintenanceSubtype maintenanceSubtype = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public Builder targetResourceType(MaintenanceRunSummary.TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        public Builder maintenanceType(MaintenanceRunSummary.MaintenanceType maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(MaintenanceRunSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder maintenanceSubtype(MaintenanceRunSummary.MaintenanceSubtype maintenanceSubtype) {
            this.maintenanceSubtype = maintenanceSubtype;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMaintenanceRunHistoryRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.targetResourceId(o.getTargetResourceId());
            this.targetResourceType(o.getTargetResourceType());
            this.maintenanceType(o.getMaintenanceType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.maintenanceSubtype(o.getMaintenanceSubtype());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMaintenanceRunHistoryRequest build() {
            ListMaintenanceRunHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMaintenanceRunHistoryRequest buildWithoutInvocationCallback() {
            ListMaintenanceRunHistoryRequest request = new ListMaintenanceRunHistoryRequest();
            request.compartmentId = this.compartmentId;
            request.targetResourceId = this.targetResourceId;
            request.targetResourceType = this.targetResourceType;
            request.maintenanceType = this.maintenanceType;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            request.availabilityDomain = this.availabilityDomain;
            request.maintenanceSubtype = this.maintenanceSubtype;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeScheduled("TIME_SCHEDULED"),
        TimeEnded("TIME_ENDED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

