/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.factory;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.internal.module.handler.ChannelEventTriggerHandler;
import org.openhab.core.automation.internal.module.handler.CompareConditionHandler;
import org.openhab.core.automation.internal.module.handler.GenericEventConditionHandler;
import org.openhab.core.automation.internal.module.handler.GenericEventTriggerHandler;
import org.openhab.core.automation.internal.module.handler.GroupCommandTriggerHandler;
import org.openhab.core.automation.internal.module.handler.GroupStateTriggerHandler;
import org.openhab.core.automation.internal.module.handler.ItemCommandActionHandler;
import org.openhab.core.automation.internal.module.handler.ItemCommandTriggerHandler;
import org.openhab.core.automation.internal.module.handler.ItemStateConditionHandler;
import org.openhab.core.automation.internal.module.handler.ItemStateTriggerHandler;
import org.openhab.core.automation.internal.module.handler.ItemStateUpdateActionHandler;
import org.openhab.core.automation.internal.module.handler.RuleEnablementActionHandler;
import org.openhab.core.automation.internal.module.handler.RunRuleActionHandler;
import org.openhab.core.automation.internal.module.handler.SystemTriggerHandler;
import org.openhab.core.automation.internal.module.handler.ThingStatusTriggerHandler;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.service.StartLevelService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class CoreModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(CoreModuleHandlerFactory.class);
    private static final Collection<String> TYPES = List.of("core.ItemCommandTrigger", "core.GroupCommandTrigger", "core.ItemStateUpdateTrigger", "core.ItemStateChangeTrigger", "core.GroupStateUpdateTrigger", "core.GroupStateChangeTrigger", "core.ThingStatusUpdateTrigger", "core.ThingStatusChangeTrigger", "core.ItemStateCondition", "core.ItemCommandAction", "core.ItemStateUpdateAction", "core.GenericEventTrigger", "core.ChannelEventTrigger", "core.GenericEventCondition", "core.GenericEventCondition", "core.GenericCompareCondition", "core.SystemStartlevelTrigger", "core.RuleEnablementAction", "core.RunRuleAction");
    private final ItemRegistry itemRegistry;
    private final TimeZoneProvider timeZoneProvider;
    private final EventPublisher eventPublisher;
    private final BundleContext bundleContext;
    private final StartLevelService startLevelService;

    @Activate
    public CoreModuleHandlerFactory(BundleContext bundleContext, @Reference EventPublisher eventPublisher, @Reference ItemRegistry itemRegistry, @Reference TimeZoneProvider timeZoneProvider, @Reference StartLevelService startLevelService) {
        this.bundleContext = bundleContext;
        this.eventPublisher = eventPublisher;
        this.itemRegistry = itemRegistry;
        this.timeZoneProvider = timeZoneProvider;
        this.startLevelService = startLevelService;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    public Collection<String> getTypes() {
        return TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {} : {}", new Object[]{module.getId(), module.getTypeUID(), ruleUID});
        String moduleTypeUID = module.getTypeUID();
        Module module2 = module;
        if (module2 instanceof Trigger) {
            void trigger;
            Trigger trigger2 = (Trigger)module2;
            Trigger cfr_ignored_0 = (Trigger)module2;
            if ("core.GenericEventTrigger".equals(moduleTypeUID)) {
                return new GenericEventTriggerHandler((Trigger)trigger, this.bundleContext);
            }
            if ("core.ChannelEventTrigger".equals(moduleTypeUID)) {
                return new ChannelEventTriggerHandler((Trigger)trigger, this.bundleContext);
            }
            if ("core.ItemCommandTrigger".equals(moduleTypeUID)) {
                return new ItemCommandTriggerHandler((Trigger)trigger, ruleUID, this.bundleContext, this.itemRegistry);
            }
            if ("core.SystemStartlevelTrigger".equals(moduleTypeUID)) {
                return new SystemTriggerHandler((Trigger)trigger, this.bundleContext);
            }
            if ("core.ThingStatusChangeTrigger".equals(moduleTypeUID) || "core.ThingStatusUpdateTrigger".equals(moduleTypeUID)) {
                return new ThingStatusTriggerHandler((Trigger)trigger, this.bundleContext);
            }
            if ("core.ItemStateChangeTrigger".equals(moduleTypeUID) || "core.ItemStateUpdateTrigger".equals(moduleTypeUID)) {
                return new ItemStateTriggerHandler((Trigger)trigger, ruleUID, this.bundleContext, this.itemRegistry);
            }
            if ("core.GroupCommandTrigger".equals(moduleTypeUID)) {
                return new GroupCommandTriggerHandler((Trigger)trigger, ruleUID, this.bundleContext, this.itemRegistry);
            }
            if ("core.GroupStateChangeTrigger".equals(moduleTypeUID) || "core.GroupStateUpdateTrigger".equals(moduleTypeUID)) {
                return new GroupStateTriggerHandler((Trigger)trigger, ruleUID, this.bundleContext, this.itemRegistry);
            }
        } else {
            Module module3 = module;
            if (module3 instanceof Condition) {
                void condition;
                Condition condition2 = (Condition)module3;
                Condition cfr_ignored_1 = (Condition)module3;
                if ("core.ItemStateCondition".equals(moduleTypeUID)) {
                    return new ItemStateConditionHandler((Condition)condition, ruleUID, this.bundleContext, this.itemRegistry, this.timeZoneProvider);
                }
                if ("core.GenericEventCondition".equals(moduleTypeUID)) {
                    return new GenericEventConditionHandler((Condition)condition);
                }
                if ("core.GenericCompareCondition".equals(moduleTypeUID)) {
                    return new CompareConditionHandler((Condition)condition);
                }
            } else {
                Module module4 = module;
                if (module4 instanceof Action) {
                    void action;
                    Action action2 = (Action)module4;
                    Action cfr_ignored_2 = (Action)module4;
                    if ("core.ItemCommandAction".equals(moduleTypeUID)) {
                        return new ItemCommandActionHandler((Action)action, this.eventPublisher, this.itemRegistry);
                    }
                    if ("core.ItemStateUpdateAction".equals(moduleTypeUID)) {
                        return new ItemStateUpdateActionHandler((Action)action, this.eventPublisher, this.itemRegistry);
                    }
                    if ("core.RuleEnablementAction".equals(moduleTypeUID)) {
                        return new RuleEnablementActionHandler((Action)action);
                    }
                    if ("core.RunRuleAction".equals(moduleTypeUID)) {
                        return new RunRuleActionHandler((Action)action);
                    }
                }
            }
        }
        this.logger.error("The ModuleHandler is not supported: {}", (Object)moduleTypeUID);
        return null;
    }
}

