/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) >> u64vec2(13ul, 63ul)) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> u64vec2(52ul, 50ul)) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> u64vec2(24ul, 61ul)) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> u64vec2(13ul, 63ul)) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> u64vec2(52ul, 50ul)) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> u64vec2(24ul, 61ul)) => u64vec2(0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) >> u64vec2(13ul, 63ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) >> u64vec2(52ul, 50ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) >> u64vec2(24ul, 61ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(42ul, 48ul) >> u64vec2(13ul, 63ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(42ul, 48ul) >> u64vec2(52ul, 50ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(42ul, 48ul) >> u64vec2(24ul, 61ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
