/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.AmqpClient;
import org.traccar.forward.EventData;
import org.traccar.forward.EventForwarder;
import org.traccar.forward.ResultHandler;

public class EventForwarderAmqp
implements EventForwarder {
    private final AmqpClient amqpClient;
    private final ObjectMapper objectMapper;

    public EventForwarderAmqp(Config config, ObjectMapper objectMapper) {
        String connectionUrl = config.getString(Keys.EVENT_FORWARD_URL);
        String exchange = config.getString(Keys.EVENT_FORWARD_EXCHANGE);
        String topic = config.getString(Keys.EVENT_FORWARD_TOPIC);
        this.objectMapper = objectMapper;
        this.amqpClient = new AmqpClient(connectionUrl, exchange, topic);
    }

    @Override
    public void forward(EventData eventData, ResultHandler resultHandler) {
        try {
            String value = this.objectMapper.writeValueAsString((Object)eventData);
            this.amqpClient.publishMessage(value);
            resultHandler.onResult(true, null);
        }
        catch (IOException e) {
            resultHandler.onResult(false, e);
        }
    }
}

