/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

public class BeanPropertySetterRule
extends Rule {
    private String propertyName;
    private String propertyNameFromAttribute;
    private String bodyText = null;

    public BeanPropertySetterRule(String propertyName) {
        this.propertyName = propertyName;
    }

    public BeanPropertySetterRule() {
        this(null);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyNameFromAttribute(String propertyNameFromAttribute) {
        this.propertyNameFromAttribute = propertyNameFromAttribute;
    }

    protected String getBodyText() {
        return this.bodyText;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.propertyNameFromAttribute != null) {
            this.propertyName = attributes.getValue(this.propertyNameFromAttribute);
            this.getDigester().getLogger().warn((Object)String.format("[BeanPropertySetterRule]{%s} Attribute '%s' not found in matching element '%s'", this.getDigester().getMatch(), this.propertyNameFromAttribute, name));
        }
    }

    public void body(String namespace, String name, String text) throws Exception {
        if (this.getDigester().getLogger().isDebugEnabled()) {
            this.getDigester().getLogger().debug((Object)String.format("[BeanPropertySetterRule]{%s} Called with text '%s'", this.getDigester().getMatch(), text));
        }
        this.bodyText = text.trim();
    }

    public void end(String namespace, String name) throws Exception {
        DynaProperty desc;
        String property = this.propertyName;
        if (property == null) {
            property = name;
        }
        Object top = this.getDigester().peek();
        if (this.getDigester().getLogger().isDebugEnabled()) {
            this.getDigester().getLogger().debug((Object)String.format("[BeanPropertySetterRule]{%s} Set %s property %s with text %s", this.getDigester().getMatch(), top.getClass().getName(), property, this.bodyText));
        }
        if (top instanceof DynaBean ? (desc = ((DynaBean)top).getDynaClass().getDynaProperty(property)) == null : (desc = PropertyUtils.getPropertyDescriptor(top, (String)property)) == null) {
            throw new NoSuchMethodException("Bean has no property named " + property);
        }
        BeanUtils.setProperty(top, (String)property, (Object)this.bodyText);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public String toString() {
        return String.format("BeanPropertySetterRule[propertyName=%s]", this.propertyName);
    }
}

